/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.weaponinnate;

import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataKeys;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.projectile.ThrownTridentPatch;

public class EverlastingAllegiance
extends WeaponInnateSkill {
    private AnimationManager.AnimationAccessor<? extends StaticAnimation> callingAnimation = Animations.EVERLASTING_ALLEGIANCE_CALL;

    public static void setThrownTridentEntityId(SkillContainer skillContainer, int entityId) {
        skillContainer.getDataManager().setDataSync((SkillDataKey)SkillDataKeys.THROWN_TRIDENT_ENTITY_ID.get(), entityId);
    }

    public static int getThrownTridentEntityId(SkillContainer skillContainer) {
        return (Integer)skillContainer.getDataManager().getDataValue((SkillDataKey)SkillDataKeys.THROWN_TRIDENT_ENTITY_ID.get());
    }

    public EverlastingAllegiance(SkillBuilder<? extends WeaponInnateSkill> builder) {
        super(builder);
    }

    @Override
    public void onInitiate(SkillContainer container) {
    }

    @Override
    public boolean checkExecuteCondition(SkillContainer container) {
        return (Integer)container.getDataManager().getDataValue((SkillDataKey)SkillDataKeys.THROWN_TRIDENT_ENTITY_ID.get()) >= 0;
    }

    @Override
    public boolean canExecute(SkillContainer container) {
        return this.checkExecuteCondition(container);
    }

    @Override
    public void executeOnServer(SkillContainer container, FriendlyByteBuf args) {
        super.executeOnServer(container, args);
        Entity entity = ((Player)container.getExecutor().getOriginal()).m_9236_().m_6815_(((Integer)container.getDataManager().getDataValue((SkillDataKey)SkillDataKeys.THROWN_TRIDENT_ENTITY_ID.get())).intValue());
        if (entity instanceof ThrownTrident) {
            ThrownTrident trident = (ThrownTrident)entity;
            ThrownTridentPatch tridentPatch = EpicFightCapabilities.getEntityPatch((Entity)trident, ThrownTridentPatch.class);
            tridentPatch.recalledBySkill();
            container.getExecutor().playAnimationSynchronized(this.callingAnimation, 0.0f);
            this.cancelOnServer(container, args);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void cancelOnClient(SkillContainer container, FriendlyByteBuf args) {
        super.cancelOnClient(container, args);
        Entity entity = ((Player)container.getExecutor().getOriginal()).m_9236_().m_6815_(((Integer)container.getDataManager().getDataValue((SkillDataKey)SkillDataKeys.THROWN_TRIDENT_ENTITY_ID.get())).intValue());
        if (entity instanceof ThrownTrident) {
            ThrownTrident trident = (ThrownTrident)entity;
            EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)trident, ThrownTridentPatch.class).ifPresent(ThrownTridentPatch::recalledBySkill);
        }
    }

    @Override
    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        int thrownTrident = (Integer)container.getDataManager().getDataValue((SkillDataKey)SkillDataKeys.THROWN_TRIDENT_ENTITY_ID.get());
        if (container.isDisabled() && thrownTrident >= 0) {
            container.setDisabled(false);
        } else if (!container.isDisabled() && thrownTrident < 0) {
            container.setDisabled(true);
        }
    }

    @Override
    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerCap) {
        List<Component> list = super.getTooltipOnItem(itemStack, cap, playerCap);
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(0), "Returning Trident:");
        return list;
    }

    @Override
    public WeaponInnateSkill registerPropertiesToAnimation() {
        return this;
    }
}

