/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.creeperconfetti.config;

import cc.cassian.creeperconfetti.CreeperConfettiMod;
import cc.cassian.creeperconfetti.config.neoforge.ModConfigImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;

public class ModConfig {
    public static float chance = 1.0f;
    public static float damage = 1.0f;
    public static float soundChance = 0.05f;
    static final Path configPath = ModConfig.configPath();

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path configPath() {
        return ModConfigImpl.configPath();
    }

    static float parseRangedFloat(String s, float min, float max, float def) {
        if (s == null) {
            return def;
        }
        try {
            return Math.min(Math.max(Float.parseFloat(s), min), max);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    static void serialize() {
        Properties prop = new Properties();
        prop.setProperty("chance", Float.toString(chance));
        prop.setProperty("damage", Float.toString(damage));
        prop.setProperty("soundChance", Float.toString(soundChance));
        try {
            OutputStream s = Files.newOutputStream(configPath, new OpenOption[0]);
            prop.store(s, "Creeper Confetti Config");
            s.close();
        }
        catch (IOException e) {
            CreeperConfettiMod.LOGGER.warn("Failed to write config!");
        }
    }

    public static void deserialize() {
        Properties prop = new Properties();
        try {
            InputStream s = Files.newInputStream(configPath, new OpenOption[0]);
            prop.load(s);
            chance = ModConfig.parseRangedFloat(prop.getProperty("chance"), 0.0f, 1.0f, 1.0f);
            damage = ModConfig.parseRangedFloat(prop.getProperty("damage"), 0.0f, 1.0f, 1.0f);
            soundChance = ModConfig.parseRangedFloat(prop.getProperty("soundChance"), 0.0f, 1.0f, 0.05f);
        }
        catch (IOException e) {
            CreeperConfettiMod.LOGGER.warn("Failed to read config!");
        }
        ModConfig.serialize();
    }
}

