/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.butlershandbell.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.butlershandbell.ButlersHandBellMod;
import net.mcreator.butlershandbell.procedures.DisappearClickProcedure;
import net.mcreator.butlershandbell.procedures.ExtinguishClickProcedure;
import net.mcreator.butlershandbell.procedures.HealingClickProcedure;
import net.mcreator.butlershandbell.procedures.LightClickProcedure;
import net.mcreator.butlershandbell.procedures.OpenFoodMenuProcedure;
import net.mcreator.butlershandbell.procedures.OpenMusicMenuProcedure;
import net.mcreator.butlershandbell.procedures.RepairItemClickProcedure;
import net.mcreator.butlershandbell.procedures.WhoAreYouClickProcedure;
import net.mcreator.butlershandbell.world.inventory.ButlerActionsMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ButlerActionsButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public ButlerActionsButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public ButlerActionsButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(ButlerActionsButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(ButlerActionsButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            ButlerActionsButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = ButlerActionsMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            DisappearClickProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            ExtinguishClickProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            OpenFoodMenuProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            HealingClickProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            OpenMusicMenuProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 5) {
            WhoAreYouClickProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 6) {
            RepairItemClickProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 7) {
            LightClickProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        ButlersHandBellMod.addNetworkMessage(ButlerActionsButtonMessage.class, ButlerActionsButtonMessage::buffer, ButlerActionsButtonMessage::new, ButlerActionsButtonMessage::handler);
    }
}

