/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.butlershandbell.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.butlershandbell.ButlersHandBellMod;
import net.mcreator.butlershandbell.procedures.Food1Procedure;
import net.mcreator.butlershandbell.procedures.Food2Procedure;
import net.mcreator.butlershandbell.procedures.Food3Procedure;
import net.mcreator.butlershandbell.procedures.Food4Procedure;
import net.mcreator.butlershandbell.procedures.Food5Procedure;
import net.mcreator.butlershandbell.procedures.Food6Procedure;
import net.mcreator.butlershandbell.procedures.Food7Procedure;
import net.mcreator.butlershandbell.procedures.Food8Procedure;
import net.mcreator.butlershandbell.world.inventory.ButlerFoodActionMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ButlerFoodActionButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public ButlerFoodActionButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public ButlerFoodActionButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(ButlerFoodActionButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(ButlerFoodActionButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            ButlerFoodActionButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = ButlerFoodActionMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            Food1Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            Food2Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            Food3Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            Food4Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            Food5Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 5) {
            Food6Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 6) {
            Food7Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 7) {
            Food8Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        ButlersHandBellMod.addNetworkMessage(ButlerFoodActionButtonMessage.class, ButlerFoodActionButtonMessage::buffer, ButlerFoodActionButtonMessage::new, ButlerFoodActionButtonMessage::handler);
    }
}

