/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.butlershandbell.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.butlershandbell.ButlersHandBellMod;
import net.mcreator.butlershandbell.procedures.PlayMusic1Procedure;
import net.mcreator.butlershandbell.procedures.PlayMusic2Procedure;
import net.mcreator.butlershandbell.procedures.PlayMusic3Procedure;
import net.mcreator.butlershandbell.procedures.PlayMusic4Procedure;
import net.mcreator.butlershandbell.procedures.PlayMusic5Procedure;
import net.mcreator.butlershandbell.procedures.PlayMusic6Procedure;
import net.mcreator.butlershandbell.procedures.PlayMusic7Procedure;
import net.mcreator.butlershandbell.procedures.PlayMusic8Procedure;
import net.mcreator.butlershandbell.world.inventory.ButlerMusicActionMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ButlerMusicActionButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public ButlerMusicActionButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public ButlerMusicActionButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(ButlerMusicActionButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(ButlerMusicActionButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            ButlerMusicActionButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = ButlerMusicActionMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            PlayMusic1Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            PlayMusic4Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            PlayMusic5Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            PlayMusic6Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            PlayMusic8Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 5) {
            PlayMusic7Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 6) {
            PlayMusic2Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 7) {
            PlayMusic3Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        ButlersHandBellMod.addNetworkMessage(ButlerMusicActionButtonMessage.class, ButlerMusicActionButtonMessage::buffer, ButlerMusicActionButtonMessage::new, ButlerMusicActionButtonMessage::handler);
    }
}

