/*
 * Decompiled with CFR 0.152.
 */
package com.sirsquidly.veilings.common;

import com.sirsquidly.veilings.common.entity.AbstractVeiling;
import com.sirsquidly.veilings.config.ConfigParser;
import com.sirsquidly.veilings.init.VeilingsEntities;
import com.sirsquidly.veilings.init.VeilingsItems;
import com.sirsquidly.veilings.init.VeilingsLootTables;
import com.sirsquidly.veilings.init.VeilingsSounds;
import com.sirsquidly.veilings.util.veilingItemUse.IVeilingUseAttributeModifier;
import com.sirsquidly.veilings.util.veilingItemUse.IVeilingUseMask;
import com.sirsquidly.veilings.util.veilingItemUse.IVeilingUseSlimeball;
import com.sirsquidly.veilings.util.veilingItemUse.IVeilingUseThrowable;
import com.sirsquidly.veilings.util.veilingItemUse.IVeilingUseTreat;
import com.sirsquidly.veilings.util.veilingItemUse.VeilingItemUseRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityEnderPearl;
import net.minecraft.entity.projectile.EntityEgg;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CommonProxy {
    public static DamageSource causeNightmareDamage(Entity source) {
        return new EntityDamageSource("veilings.nightmare", source).func_76348_h().func_151518_m();
    }

    public void preInitRegisteries(FMLPreInitializationEvent event) {
        VeilingsEntities.registerEntities();
        VeilingsLootTables.registerLootTables();
        VeilingsSounds.registerSounds();
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            VeilingsEntities.RegisterRenderers();
        }
    }

    public void postInitRegisteries(FMLPostInitializationEvent event) {
        ConfigParser.breakupConfigArrays();
        for (int i = 0; i < ConfigParser.veilingTreatItems.size(); ++i) {
            VeilingItemUseRegistry.register(ConfigParser.veilingTreatItems.get(i).func_77973_b(), new IVeilingUseTreat());
        }
        VeilingItemUseRegistry.register(VeilingsItems.VEILING_TIRAMISU, new IVeilingUseAttributeModifier("health_bonus", 2.0f){

            @Override
            public boolean requiredCondition(AbstractVeiling veiling, ItemStack stack) {
                return veiling.func_110138_aP() < 30.0f;
            }

            @Override
            public void conditionTriggerFalse(AbstractVeiling veiling, ItemStack stack) {
                veiling.func_70690_d(new PotionEffect(MobEffects.field_76444_x, 1200, 0));
            }
        });
        VeilingItemUseRegistry.register(Items.field_151114_aO, new IVeilingUseTreat());
        VeilingItemUseRegistry.register(VeilingsItems.VEILING_MASK_CUSTODIAN, new IVeilingUseMask());
        VeilingItemUseRegistry.register(VeilingsItems.VEILING_MASK_DEFT, new IVeilingUseMask());
        VeilingItemUseRegistry.register(VeilingsItems.VEILING_MASK_DRAMATIST, new IVeilingUseMask());
        VeilingItemUseRegistry.register(Items.field_151123_aH, new IVeilingUseSlimeball());
        VeilingItemUseRegistry.register(Items.field_151110_aK, new IVeilingUseThrowable(SoundEvents.field_187511_aA, 3){

            @Override
            public IProjectile getProjectileEntity(World worldIn, AbstractVeiling veiling, ItemStack stackIn) {
                return new EntityEgg(worldIn, (EntityLivingBase)veiling);
            }
        });
        VeilingItemUseRegistry.register(Items.field_151126_ay, new IVeilingUseThrowable(SoundEvents.field_187797_fA, 3){

            @Override
            public IProjectile getProjectileEntity(World worldIn, AbstractVeiling veiling, ItemStack stackIn) {
                return new EntitySnowball(worldIn, (EntityLivingBase)veiling);
            }
        });
        VeilingItemUseRegistry.register(Items.field_151079_bi, new IVeilingUseThrowable(SoundEvents.field_187595_bc, 3){

            @Override
            public IProjectile getProjectileEntity(World worldIn, AbstractVeiling veiling, ItemStack stackIn) {
                return new EntityEnderPearl(worldIn, (EntityLivingBase)veiling);
            }
        });
        VeilingItemUseRegistry.register((Item)Items.field_185155_bH, new IVeilingUseThrowable(SoundEvents.field_187827_fP, 10){

            @Override
            public IProjectile getProjectileEntity(World worldIn, AbstractVeiling veiling, ItemStack stackIn) {
                return new EntityPotion(worldIn, (EntityLivingBase)veiling, stackIn);
            }
        });
        VeilingItemUseRegistry.register((Item)Items.field_185156_bI, new IVeilingUseThrowable(SoundEvents.field_187756_df, 10){

            @Override
            public IProjectile getProjectileEntity(World worldIn, AbstractVeiling veiling, ItemStack stackIn) {
                return new EntityPotion(worldIn, (EntityLivingBase)veiling, stackIn);
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public void registerItemRenderer(Item item, int meta, String id) {
    }
}

