/*
 * Decompiled with CFR 0.152.
 */
package com.sirsquidly.veilings.common.entity.ai;

import com.google.common.base.Predicate;
import com.sirsquidly.veilings.client.model.ModelVeilingBase;
import com.sirsquidly.veilings.common.entity.AbstractVeiling;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockCarpet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityAIVeilingCommandWander
extends EntityAIBase {
    private final AbstractVeiling veiling;
    private final World world;
    private final double speed;
    protected final float probability;
    private int cooldownTimer = 0;
    private int currentActivity;
    private int activityTimer = 0;
    private Entity entityTarget;
    private BlockPos blockTarget = null;

    public EntityAIVeilingCommandWander(AbstractVeiling creatureIn, double speedIn) {
        this(creatureIn, speedIn, 0.001f);
    }

    public EntityAIVeilingCommandWander(AbstractVeiling veilingIn, double speedIn, float chance) {
        this.veiling = veilingIn;
        this.world = veilingIn.field_70170_p;
        this.speed = speedIn;
        this.probability = chance;
    }

    public boolean func_75250_a() {
        return this.veiling.getCommandMode() == 1;
    }

    public void func_75246_d() {
        --this.activityTimer;
        --this.cooldownTimer;
        if (this.currentActivity != 0 && this.activityTimer <= 0) {
            this.currentActivity = 0;
            this.cooldownTimer = 120 + this.world.field_73012_v.nextInt(30);
        }
        if (this.cooldownTimer > 0) {
            return;
        }
        switch (this.currentActivity) {
            case 0: {
                this.veiling.setArmPose(ModelVeilingBase.PoseBody.EMPTY);
                this.randomActivity();
                break;
            }
            case 1: {
                Vec3d target;
                if (!this.veiling.func_70661_as().func_75500_f() || (target = RandomPositionGenerator.func_191377_b((EntityCreature)this.veiling, (int)8, (int)3)) == null) break;
                this.veiling.func_70661_as().func_75492_a(target.field_72450_a, target.field_72448_b, target.field_72449_c, this.speed * 0.75);
                break;
            }
            case 2: {
                this.veiling.setArmPose(ModelVeilingBase.PoseBody.SITTING);
                this.veiling.func_70661_as().func_75499_g();
                break;
            }
            case 3: {
                if (this.blockTarget != null) {
                    double distToBed = this.veiling.func_174818_b(this.blockTarget);
                    if (distToBed > 0.05) {
                        this.veiling.func_70661_as().func_75492_a((double)this.blockTarget.func_177958_n(), (double)this.blockTarget.func_177956_o(), (double)this.blockTarget.func_177952_p(), this.speed * 0.6);
                        break;
                    }
                    this.veiling.func_70661_as().func_75499_g();
                    this.veiling.setArmPose(ModelVeilingBase.PoseBody.SLEEPING);
                }
                this.veiling.setArmPose(ModelVeilingBase.PoseBody.SLEEPING);
                this.veiling.func_70661_as().func_75499_g();
                break;
            }
            case 4: {
                this.veiling.func_70671_ap().func_75651_a(this.entityTarget, 30.0f, 30.0f);
                double dist = this.veiling.func_70032_d(this.entityTarget);
                if (dist > 2.0) {
                    this.veiling.func_70661_as().func_75497_a(this.entityTarget, this.speed * 0.75);
                    break;
                }
                this.veiling.func_70661_as().func_75499_g();
                if (this.world.field_72995_K || this.world.field_73012_v.nextInt(20) != 0) break;
                this.veiling.spawnOverheadParticle(EnumParticleTypes.NOTE, 1);
            }
        }
    }

    private void randomActivity() {
        EntityLivingBase target;
        double roll = this.world.field_73012_v.nextDouble();
        if (roll < 0.1) {
            this.currentActivity = 2;
            this.activityTimer = 60 + this.world.field_73012_v.nextInt(60);
            return;
        }
        if (roll < 0.7) {
            if (this.getNearestBed()) {
                this.currentActivity = 3;
                this.activityTimer = 100 + this.world.field_73012_v.nextInt(80);
                return;
            }
            return;
        }
        if (roll < 0.8 && (target = (EntityLivingBase)this.getNearbyEntity(AbstractVeiling.class, null)) != null) {
            this.currentActivity = 4;
            this.entityTarget = target;
            this.activityTimer = 80 + this.world.field_73012_v.nextInt(60);
            return;
        }
        this.currentActivity = 1;
        this.activityTimer = 60 + this.world.field_73012_v.nextInt(40);
    }

    private boolean getNearestBed() {
        int maxRadiusXZ = 6;
        int maxRadiusY = 2;
        BlockPos bestBlock = null;
        double shortestDistance = Double.MAX_VALUE;
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)this.veiling.func_180425_c().func_177982_a(-maxRadiusXZ, 0, -maxRadiusXZ), (BlockPos)this.veiling.func_180425_c().func_177982_a(maxRadiusXZ, maxRadiusY, maxRadiusXZ))) {
            double distanceSq;
            if (!this.shouldMoveTo(this.world.func_180495_p(pos).func_177230_c()) || !this.veiling.func_180485_d(pos) || !((distanceSq = this.veiling.func_174831_c(pos)) < shortestDistance) || this.veiling.func_70661_as().func_179680_a(pos) == null) continue;
            shortestDistance = distanceSq;
            bestBlock = pos.func_185334_h();
        }
        if (bestBlock != null) {
            this.blockTarget = bestBlock;
            return true;
        }
        return false;
    }

    protected boolean shouldMoveTo(Block block) {
        return block instanceof BlockBed || block == Blocks.field_150325_L || block instanceof BlockCarpet;
    }

    public <T extends Entity> T getNearbyEntity(Class<T> entityClass, Predicate<T> filter) {
        List nearby = this.world.func_175647_a(entityClass, this.veiling.func_174813_aQ().func_186662_g(6.0), entity -> entity != this.veiling && (filter == null || filter.test(entity)));
        if (nearby.isEmpty()) {
            return null;
        }
        return (T)((Entity)nearby.get(this.world.field_73012_v.nextInt(nearby.size())));
    }
}

