/*
 * Decompiled with CFR 0.152.
 */
package com.sirsquidly.veilings.common.item;

import com.sirsquidly.veilings.common.entity.AbstractVeiling;
import com.sirsquidly.veilings.init.VeilingsSounds;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCallingBell
extends Item {
    public ItemCallingBell() {
        this.field_77777_bU = 1;
        this.func_77637_a(CreativeTabs.field_78040_i);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (playerIn.func_70093_af()) {
            int current = ItemCallingBell.getCommandType(stack);
            if (++current > 2) {
                current = 0;
            }
            ItemCallingBell.setCommandType(stack, current);
            playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("message.veilings.calling_bell.set_mode_" + current, new Object[0]), true);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
        }
        double distance = 8.0;
        Vec3d eyePosition = playerIn.func_174824_e(1.0f);
        Vec3d lookVector = playerIn.func_70676_i(1.0f);
        Vec3d traceEnd = eyePosition.func_72441_c(lookVector.field_72450_a * 30.0, lookVector.field_72448_b * 30.0, lookVector.field_72449_c * 30.0);
        RayTraceResult blockTrace = worldIn.func_147447_a(eyePosition, traceEnd, false, true, false);
        if (blockTrace == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)playerIn.func_184586_b(handIn));
        }
        BlockPos selectedBlock = blockTrace.func_178782_a();
        List<AbstractVeiling> veilings2 = this.getNearbyVeilings(playerIn, selectedBlock, (int)distance);
        boolean didAnything = !veilings2.isEmpty();
        for (AbstractVeiling v : veilings2) {
            if (worldIn.field_72995_K) continue;
            v.setCommandMode(ItemCallingBell.getCommandType(stack));
            if (v.getCommandMode() == 1) {
                v.func_175449_a(v.func_180425_c(), 8);
            } else {
                v.func_110177_bN();
            }
            v.func_70624_b(null);
            v.func_70661_as().func_75499_g();
            v.func_184185_a(VeilingsSounds.ENTITY_VEILING_AGREE, 0.25f, v.getPublicSoundPitch());
        }
        if (didAnything && !worldIn.field_72995_K) {
            ((WorldServer)worldIn).func_175739_a(EnumParticleTypes.CRIT, (double)selectedBlock.func_177958_n() + 0.5, (double)(selectedBlock.func_177956_o() + 1), (double)selectedBlock.func_177952_p() + 0.5, 80, 0.3 * distance, 0.5, 0.3 * distance, 0.05, new int[0]);
        }
        playerIn.func_184609_a(handIn);
        SoundEvent sound = ItemCallingBell.getCommandType(stack) == 0 ? VeilingsSounds.ITEM_CALLING_BELL_USE1 : (ItemCallingBell.getCommandType(stack) == 1 ? VeilingsSounds.ITEM_CALLING_BELL_USE2 : VeilingsSounds.ITEM_CALLING_BELL_USE3);
        worldIn.func_184133_a(playerIn, playerIn.func_180425_c(), sound, SoundCategory.PLAYERS, didAnything ? 0.5f : 0.2f, 1.0f);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    public List<AbstractVeiling> getNearbyVeilings(EntityPlayer player, BlockPos pos, int distance) {
        List veilings2 = player.field_70170_p.func_72872_a(AbstractVeiling.class, new AxisAlignedBB(pos).func_186662_g((double)distance));
        veilings2.removeIf(thisEntity -> !player.func_110124_au().equals(thisEntity.func_184753_b()));
        return veilings2;
    }

    public static void setCommandType(ItemStack stack, int type) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        nbt.func_74768_a("ControlType", type);
        stack.func_77982_d(nbt);
    }

    public static Integer getCommandType(ItemStack stack) {
        NBTTagCompound tagCompound;
        if (stack.func_77942_o() && (tagCompound = stack.func_77978_p()) != null && tagCompound.func_74764_b("ControlType")) {
            return tagCompound.func_74762_e("ControlType");
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(TextFormatting.YELLOW + I18n.func_74837_a((String)("description.veilings.calling_bell.commandMode" + ItemCallingBell.getCommandType(stack)), (Object[])new Object[0]));
        tooltip.add(TextFormatting.BLUE + I18n.func_74837_a((String)"description.veilings.calling_bell.desc1", (Object[])new Object[0]));
        tooltip.add(TextFormatting.BLUE + I18n.func_74837_a((String)"description.veilings.calling_bell.desc2", (Object[])new Object[0]));
        tooltip.add(TextFormatting.BLUE + I18n.func_74837_a((String)"description.veilings.calling_bell.desc3", (Object[])new Object[0]));
    }
}

