/*
 * Decompiled with CFR 0.152.
 */
package com.sirsquidly.veilings.common.item;

import java.util.List;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemVeilingOutfit
extends Item {
    int outfitType;
    String outfitVariant;
    boolean hasOverlay;

    public ItemVeilingOutfit(int outfitTypeIn, String outfitVariantIn, boolean hasOverlayIn) {
        this.func_77637_a(CreativeTabs.field_78035_l);
        this.outfitType = outfitTypeIn;
        this.outfitVariant = outfitVariantIn;
        this.hasOverlay = hasOverlayIn;
        this.func_77625_d(1);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() != this) {
            return EnumActionResult.PASS;
        }
        if (!((ItemVeilingOutfit)itemstack.func_77973_b()).hasColor(itemstack)) {
            return EnumActionResult.PASS;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == Blocks.field_150383_bp) {
            BlockCauldron cauldron = (BlockCauldron)state.func_177230_c();
            int level = (Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a);
            if (level <= 0) {
                return EnumActionResult.PASS;
            }
            this.removeColor(itemstack);
            cauldron.func_176590_a(world, pos, state, level - 1);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public boolean hasColor(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        return nbttagcompound != null && nbttagcompound.func_150297_b("display", 10) ? nbttagcompound.func_74775_l("display").func_150297_b("color", 3) : false;
    }

    public int getColor(ItemStack stack) {
        NBTTagCompound nbttagcompound1;
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound != null && (nbttagcompound1 = nbttagcompound.func_74775_l("display")) != null && nbttagcompound1.func_150297_b("color", 3)) {
            return nbttagcompound1.func_74762_e("color");
        }
        return 0xFFFFFF;
    }

    public void removeColor(ItemStack stack) {
        NBTTagCompound nbttagcompound1;
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound != null && (nbttagcompound1 = nbttagcompound.func_74775_l("display")).func_74764_b("color")) {
            nbttagcompound1.func_82580_o("color");
        }
    }

    public void setColor(ItemStack stack, int color) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound == null) {
            nbttagcompound = new NBTTagCompound();
            stack.func_77982_d(nbttagcompound);
        }
        NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("display");
        if (!nbttagcompound.func_150297_b("display", 10)) {
            nbttagcompound.func_74782_a("display", (NBTBase)nbttagcompound1);
        }
        nbttagcompound1.func_74768_a("color", color);
    }

    public int getVeilingOutfitType() {
        return this.outfitType;
    }

    public String getVeilingOutfitVariant() {
        return this.outfitVariant;
    }

    public boolean getVeilingOutfitHasOverlay() {
        return this.hasOverlay;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(TextFormatting.GRAY + I18n.func_74837_a((String)"description.veilings.veiling_outfit.desc1", (Object[])new Object[0]));
        tooltip.add(TextFormatting.GRAY + I18n.func_74837_a((String)"description.veilings.veiling_outfit.desc2", (Object[])new Object[0]));
        tooltip.add(TextFormatting.BLUE + I18n.func_74837_a((String)"description.veilings.veiling_outfit.desc3", (Object[])new Object[0]));
    }
}

