/*
 * Decompiled with CFR 0.152.
 */
package com.sirsquidly.veilings.util.veilingItemUse;

import com.sirsquidly.veilings.common.entity.AbstractVeiling;
import com.sirsquidly.veilings.util.veilingItemUse.IVeilingItemUse;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class IVeilingUseThrowable
implements IVeilingItemUse {
    private SoundEvent throwSound;
    private int moodShift;

    public IVeilingUseThrowable(SoundEvent throwSoundIn, int moodShiftIn) {
        this.throwSound = throwSoundIn;
        this.moodShift = moodShiftIn;
    }

    @Override
    public void onItemUse(AbstractVeiling veiling, ItemStack stack, int useTime) {
    }

    @Override
    public void onItemUseFinish(AbstractVeiling veiling, ItemStack stack, int useTime) {
        Entity victim = this.getNearbyRandomEntity(veiling.field_70170_p, veiling, 5.0);
        if (victim != null) {
            this.spawnThrowableAtVictim(this.getProjectileEntity(veiling.field_70170_p, veiling, stack), veiling, victim);
            veiling.func_184609_a(EnumHand.MAIN_HAND);
            veiling.func_184185_a(this.throwSound, 1.0f, 1.0f);
            veiling.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
            veiling.shiftHappiness(this.moodShift);
            veiling.setPlayCooldown(200);
        }
    }

    @Override
    public boolean canUseItem(AbstractVeiling veiling, ItemStack stack) {
        return veiling.getPlayCooldown() <= 0;
    }

    @Override
    public int getUseTime() {
        return 20;
    }

    @Override
    public boolean isSafeItem(AbstractVeiling veiling, ItemStack stack) {
        return false;
    }

    public IProjectile getProjectileEntity(World worldIn, AbstractVeiling veiling, ItemStack stackIn) {
        return null;
    }

    public Entity getNearbyRandomEntity(World world, AbstractVeiling veiling, double expandByRange) {
        List list = world.func_175647_a(Entity.class, veiling.func_174813_aQ().func_186662_g(expandByRange), entity -> entity != veiling && entity.func_70089_S());
        if (list.isEmpty()) {
            return null;
        }
        return (Entity)list.get(world.field_73012_v.nextInt(list.size()));
    }

    public void spawnThrowableAtVictim(IProjectile projectile, AbstractVeiling veiling, Entity victim) {
        double s1 = victim.field_70163_u - veiling.field_70163_u;
        double s2 = victim.field_70165_t - veiling.field_70165_t;
        double s4 = victim.field_70161_v - veiling.field_70161_v;
        projectile.func_70186_c(s2, s1, s4, 0.7f, 2.0f);
        veiling.field_70170_p.func_72838_d((Entity)projectile);
    }
}

