/*
 * Decompiled with CFR 0.152.
 */
package com.Maxwell.cyber_ware_port.Client.CreativeTab;

import com.Maxwell.cyber_ware_port.Client.CreativeTab.CyberwareSideTabButton;
import com.Maxwell.cyber_ware_port.Common.CyberwareTabState;
import com.Maxwell.cyber_ware_port.Init.ModItems;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

@Mod.EventBusSubscriber(modid="cyber_ware_port", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class CyberwareTabEvent {
    private static final ResourceLocation TAB_TEXTURE = new ResourceLocation("cyber_ware_port", "textures/gui/extended_tabs.png");
    private static final List<CyberwareSideTabButton> customTabs = new ArrayList<CyberwareSideTabButton>();
    private static boolean isReloading = false;

    @SubscribeEvent
    public static void onScreenInitPre(ScreenEvent.Init.Pre event) {
        if (event.getScreen() instanceof CreativeModeInventoryScreen) {
            CyberwareTabEvent.refreshTabContents();
        }
    }

    @SubscribeEvent
    public static void onScreenClosing(ScreenEvent.Closing event) {
        if (event.getScreen() instanceof CreativeModeInventoryScreen) {
            if (isReloading) {
                return;
            }
            CyberwareTabState.currentPage = 0;
        }
    }

    @SubscribeEvent
    public static void onScreenInit(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof CreativeModeInventoryScreen) {
            CreativeModeInventoryScreen screen2 = (CreativeModeInventoryScreen)screen;
            customTabs.clear();
            int guiLeft = screen2.getGuiLeft();
            int guiTop = screen2.getGuiTop();
            int imageWidth = 28;
            int panelX = guiLeft - imageWidth;
            int panelY = guiTop;
            int buttonX = panelX + 7;
            CyberwareSideTabButton btn1 = new CyberwareSideTabButton(buttonX, panelY + 8, 17, 17, btn -> {
                if (CyberwareTabState.currentPage != 1) {
                    CyberwareTabState.currentPage = 1;
                    CyberwareTabEvent.reloadScreen();
                }
            });
            event.addListener((GuiEventListener)btn1);
            customTabs.add(btn1);
            CyberwareSideTabButton btn2 = new CyberwareSideTabButton(buttonX, panelY + 31, 17, 17, btn -> {
                if (CyberwareTabState.currentPage != 0) {
                    CyberwareTabState.currentPage = 0;
                    CyberwareTabEvent.reloadScreen();
                }
            });
            event.addListener((GuiEventListener)btn2);
            customTabs.add(btn2);
            CyberwareTabEvent.updateVisibility(screen2);
        }
    }

    @SubscribeEvent
    public static void onScreenRenderPost(ScreenEvent.Render.Post event) {
        CreativeModeInventoryScreen screen;
        Screen screen2 = event.getScreen();
        if (screen2 instanceof CreativeModeInventoryScreen && CyberwareTabEvent.updateVisibility(screen = (CreativeModeInventoryScreen)screen2)) {
            int guiLeft = screen.getGuiLeft();
            int guiTop = screen.getGuiTop();
            int panelX = guiLeft - 28;
            int panelY = guiTop;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TAB_TEXTURE);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            event.getGuiGraphics().m_280168_().m_85836_();
            event.getGuiGraphics().m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
            event.getGuiGraphics().m_280163_(TAB_TEXTURE, panelX, panelY, 0.0f, 0.0f, 28, 128, 256, 256);
            event.getGuiGraphics().m_280168_().m_85849_();
            RenderSystem.disableBlend();
        }
    }

    private static void reloadScreen() {
        isReloading = true;
        CyberwareTabEvent.refreshTabContents();
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null) {
            mc.m_91152_((Screen)new CreativeModeInventoryScreen((Player)mc.f_91074_, mc.f_91074_.f_108617_.m_247016_(), ((Boolean)mc.f_91066_.m_257871_().m_231551_()).booleanValue()));
        }
        isReloading = false;
    }

    private static void refreshTabContents() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null) {
            CreativeModeTab.ItemDisplayParameters params = new CreativeModeTab.ItemDisplayParameters(mc.f_91074_.f_108617_.m_247016_(), ((Boolean)mc.f_91066_.m_257871_().m_231551_()).booleanValue(), (HolderLookup.Provider)mc.f_91074_.m_9236_().m_9598_());
            ((CreativeModeTab)ModItems.CW_TABS.get()).m_269498_(params);
        }
    }

    private static boolean updateVisibility(CreativeModeInventoryScreen screen) {
        CreativeModeTab selectedTab = null;
        try {
            selectedTab = (CreativeModeTab)ObfuscationReflectionHelper.getPrivateValue(CreativeModeInventoryScreen.class, null, (String)"f_98505_");
        }
        catch (Exception e) {
            try {
                Field f = CreativeModeInventoryScreen.class.getDeclaredField("selectedTab");
                f.setAccessible(true);
                selectedTab = (CreativeModeTab)f.get(null);
            }
            catch (Exception ex) {
                return false;
            }
        }
        boolean isMyTab = selectedTab == ModItems.CW_TABS.get();
        for (CyberwareSideTabButton btn : customTabs) {
            btn.f_93624_ = isMyTab;
            btn.f_93623_ = isMyTab;
        }
        return isMyTab;
    }
}

