/*
 * Decompiled with CFR 0.152.
 */
package com.Maxwell.cyber_ware_port.Common.Block.Radio.Tower;

import com.Maxwell.cyber_ware_port.Common.Block.Radio.Tower.RadioTowerCoreBlock;
import com.Maxwell.cyber_ware_port.Common.Block.Radio.Tower.RadioTowerFenceBlock;
import com.Maxwell.cyber_ware_port.Common.Entity.ICyberwareMob;
import com.Maxwell.cyber_ware_port.Init.ModBlockEntities;
import com.Maxwell.cyber_ware_port.Init.ModBlocks;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class RadioTowerCoreBlockEntity
extends BlockEntity {
    private static final int SEARCH_COOLDOWN = 100;
    private static final int ATTRACTION_RANGE = 200;
    private static final int SHAFT_HEIGHT = 6;
    private static final int BASE_HEIGHT = 4;
    private static final int TOTAL_HEIGHT = 10;
    private int tickCounter = 0;

    public RadioTowerCoreBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.RADIO_TOWER_CORE.get(), pPos, pBlockState);
    }

    public static void serverTick(Level pLevel, BlockPos pPos, BlockState pState, RadioTowerCoreBlockEntity pBlockEntity) {
        if (!((Boolean)pState.m_61143_((Property)RadioTowerCoreBlock.FORMED)).booleanValue()) {
            return;
        }
        ++pBlockEntity.tickCounter;
        if (pBlockEntity.tickCounter >= 100) {
            pBlockEntity.tickCounter = 0;
            pBlockEntity.attractMobs();
        }
    }

    private static boolean isCyberMob(PathfinderMob mob) {
        return mob instanceof ICyberwareMob;
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128405_("TickCounter", this.tickCounter);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.tickCounter = pTag.m_128451_("TickCounter");
    }

    public void deformFencesOnly() {
        if (this.m_58904_() == null || this.m_58904_().m_5776_()) {
            return;
        }
        this.setStructureState(false, false);
    }

    public void tryToFormStructure() {
        if (this.m_58904_() == null || this.m_58904_().m_5776_()) {
            return;
        }
        if (this.checkStructure()) {
            this.setStructureState(true);
        }
    }

    public void deformStructure() {
        if (this.m_58904_() == null || this.m_58904_().m_5776_()) {
            return;
        }
        this.setStructureState(false);
    }

    private void setStructureState(boolean formed) {
        this.setStructureState(formed, true);
    }

    private void setStructureState(boolean formed, boolean includeCore) {
        int yOffset;
        BlockState coreState;
        Level level = this.m_58904_();
        if (level == null) {
            return;
        }
        BlockPos corePos = this.m_58899_();
        if (includeCore && (coreState = this.m_58900_()).m_61138_((Property)RadioTowerCoreBlock.FORMED)) {
            level.m_7731_(corePos, (BlockState)coreState.m_61124_((Property)RadioTowerCoreBlock.FORMED, (Comparable)Boolean.valueOf(formed)), 3);
        }
        for (yOffset = 1; yOffset <= 6; ++yOffset) {
            this.updateFenceState(level, corePos.m_6625_(yOffset), formed);
        }
        for (yOffset = 7; yOffset <= 10; ++yOffset) {
            BlockPos layerCenter = corePos.m_6625_(yOffset);
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    this.updateFenceState(level, layerCenter.m_7918_(x, 0, z), formed);
                }
            }
        }
    }

    private void updateFenceState(Level level, BlockPos pos, boolean formed) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60713_((Block)ModBlocks.RADIO_TOWER_COMPONENT.get()) && state.m_61138_((Property)RadioTowerFenceBlock.FORMED) && (Boolean)state.m_61143_((Property)RadioTowerFenceBlock.FORMED) != formed) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)RadioTowerFenceBlock.FORMED, (Comparable)Boolean.valueOf(formed)), 3);
        }
    }

    private void attractMobs() {
        Level level = this.m_58904_();
        if (level == null) {
            return;
        }
        BlockPos basePos = this.m_58899_().m_6625_(10);
        AABB searchBox = new AABB(basePos).m_82400_(200.0);
        List mobsInRange = level.m_45976_(PathfinderMob.class, searchBox);
        for (PathfinderMob mob : mobsInRange) {
            if (!RadioTowerCoreBlockEntity.isCyberMob(mob) || !(mob.m_20275_((double)basePos.m_123341_() + 0.5, (double)basePos.m_123342_(), (double)basePos.m_123343_() + 0.5) > 4.0)) continue;
            mob.m_21573_().m_26519_((double)basePos.m_123341_() + 0.5, (double)basePos.m_123342_(), (double)basePos.m_123343_() + 0.5, 1.2);
        }
    }

    public AABB getRenderBoundingBox() {
        BlockPos pos = this.m_58899_();
        return new AABB((double)pos.m_123341_() - 5.0, (double)pos.m_123342_() - 15.0, (double)pos.m_123343_() - 5.0, (double)pos.m_123341_() + 6.0, (double)pos.m_123342_() + 2.0, (double)pos.m_123343_() + 6.0);
    }

    private boolean checkStructure() {
        int z;
        int x;
        BlockPos layerCenter;
        int yOffset;
        Level level = this.m_58904_();
        if (level == null) {
            return false;
        }
        BlockPos corePos = this.m_58899_();
        for (yOffset = 1; yOffset <= 6; ++yOffset) {
            layerCenter = corePos.m_6625_(yOffset);
            for (x = -1; x <= 1; ++x) {
                for (z = -1; z <= 1; ++z) {
                    BlockPos targetPos = layerCenter.m_7918_(x, 0, z);
                    BlockState state = level.m_8055_(targetPos);
                    if (!(x == 0 && z == 0 ? !state.m_60713_((Block)ModBlocks.RADIO_TOWER_COMPONENT.get()) : !state.m_60795_())) continue;
                    return false;
                }
            }
        }
        for (yOffset = 7; yOffset <= 10; ++yOffset) {
            layerCenter = corePos.m_6625_(yOffset);
            for (x = -1; x <= 1; ++x) {
                for (z = -1; z <= 1; ++z) {
                    BlockState state = level.m_8055_(layerCenter.m_7918_(x, 0, z));
                    if (state.m_60713_((Block)ModBlocks.RADIO_TOWER_COMPONENT.get())) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

