/*
 * Decompiled with CFR 0.152.
 */
package com.Maxwell.cyber_ware_port.Common.Block.Robosurgeon;

import com.Maxwell.cyber_ware_port.Common.Block.Robosurgeon.BodyRegionEnum;
import com.Maxwell.cyber_ware_port.Common.Block.SurgeryChamber.SurgeryChamberBlock;
import com.Maxwell.cyber_ware_port.Common.Block.SurgeryChamber.SurgeryChamberBlockEntity;
import com.Maxwell.cyber_ware_port.Common.Capability.CyberwareCapabilityProvider;
import com.Maxwell.cyber_ware_port.Common.Capability.CyberwareUserData;
import com.Maxwell.cyber_ware_port.Common.Container.RobosurgeonMenu;
import com.Maxwell.cyber_ware_port.Common.Item.Base.CyberwareSlotType;
import com.Maxwell.cyber_ware_port.Common.Item.Base.ICyberware;
import com.Maxwell.cyber_ware_port.Common.Network.A_PacketHandler;
import com.Maxwell.cyber_ware_port.Common.Network.SyncSurgeryProgressPacket;
import com.Maxwell.cyber_ware_port.Init.ModBlockEntities;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RobosurgeonBlockEntity
extends BlockEntity
implements MenuProvider {
    public static final int SLOTS_PER_PART = 9;
    public static final int SLOT_EYES = BodyRegionEnum.EYES.getStartSlot();
    public static final int SLOT_BRAIN = BodyRegionEnum.BRAIN.getStartSlot();
    public static final int SLOT_HEART = BodyRegionEnum.HEART.getStartSlot();
    public static final int SLOT_LUNGS = BodyRegionEnum.LUNGS.getStartSlot();
    public static final int SLOT_STOMACH = BodyRegionEnum.STOMACH.getStartSlot();
    public static final int SLOT_SKIN = BodyRegionEnum.SKIN.getStartSlot();
    public static final int SLOT_MUSCLE = BodyRegionEnum.MUSCLE.getStartSlot();
    public static final int SLOT_BONES = BodyRegionEnum.BONES.getStartSlot();
    public static final int SLOT_ARMS = BodyRegionEnum.ARMS.getStartSlot();
    public static final int SLOT_HANDS = BodyRegionEnum.HANDS.getStartSlot();
    public static final int SLOT_LEGS = BodyRegionEnum.LEGS.getStartSlot();
    public static final int SLOT_BOOTS = BodyRegionEnum.BOOTS.getStartSlot();
    public static final int TOTAL_SLOTS = BodyRegionEnum.getTotalSlots();
    protected final ContainerData data;
    private final ItemStackHandler itemHandler = new ItemStackHandler(TOTAL_SLOTS){

        protected void onContentsChanged(int slot) {
            RobosurgeonBlockEntity.this.m_6596_();
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (stack.m_41619_()) {
                return stack;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            Item item = stack.m_41720_();
            if (item instanceof ICyberware) {
                ICyberware incomingItem = (ICyberware)item;
                int maxInstall = incomingItem.getMaxInstallAmount(stack);
                if (maxInstall <= 0) {
                    maxInstall = 1;
                }
                int currentlyInstalledTotal = 0;
                for (int i = 0; i < this.getSlots(); ++i) {
                    ItemStack inSlot = this.getStackInSlot(i);
                    if (inSlot.m_41619_() || inSlot.m_41720_() != stack.m_41720_()) continue;
                    currentlyInstalledTotal += inSlot.m_41613_();
                }
                int globalRemaining = maxInstall - currentlyInstalledTotal;
                if (globalRemaining <= 0) {
                    return stack;
                }
                if (stack.m_41613_() > globalRemaining) {
                    ItemStack toInsert = stack.m_41777_();
                    toInsert.m_41764_(globalRemaining);
                    ItemStack remainderFromInsert = super.insertItem(slot, toInsert, simulate);
                    int accepted = toInsert.m_41613_() - remainderFromInsert.m_41613_();
                    ItemStack result = stack.m_41777_();
                    result.m_41764_(stack.m_41613_() - accepted);
                    return result;
                }
            }
            return super.insertItem(slot, stack, simulate);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            int j;
            ItemStack currentStack = this.getStackInSlot(slot);
            if (!currentStack.m_41619_() && currentStack.m_41782_() && currentStack.m_41783_().m_128471_("cyberware_ghost")) {
                return false;
            }
            Item item = stack.m_41720_();
            if (!(item instanceof ICyberware)) {
                return false;
            }
            ICyberware incomingItem = (ICyberware)item;
            CyberwareSlotType itemType = CyberwareSlotType.fromId(incomingItem.getSlot(stack));
            CyberwareSlotType targetType = CyberwareSlotType.fromId(slot);
            if (itemType != targetType || itemType == CyberwareSlotType.UNKNOWN) {
                return false;
            }
            int maxInstall = incomingItem.getMaxInstallAmount(stack);
            if (maxInstall <= 0) {
                maxInstall = 1;
            }
            int installedCount = 0;
            for (j = 0; j < this.getSlots(); ++j) {
                ItemStack tableStack;
                if (j == slot || (tableStack = this.getStackInSlot(j)).m_41619_() || tableStack.m_41720_() != stack.m_41720_()) continue;
                installedCount += tableStack.m_41613_();
            }
            if (installedCount >= maxInstall) {
                return false;
            }
            for (j = 0; j < this.getSlots(); ++j) {
                ICyberware otherCW;
                ItemStack otherStack;
                if (j == slot || (otherStack = this.getStackInSlot(j)).m_41619_()) continue;
                if (incomingItem.isIncompatible(stack, otherStack)) {
                    return false;
                }
                Item item2 = otherStack.m_41720_();
                if (!(item2 instanceof ICyberware) || !(otherCW = (ICyberware)item2).isIncompatible(otherStack, stack)) continue;
                return false;
            }
            return true;
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private int progress = 0;
    private int maxProgress = 100;

    public RobosurgeonBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.ROBO_SURGEON.get(), pPos, pBlockState);
        this.data = new ContainerData(){

            public int m_6413_(int pIndex) {
                return switch (pIndex) {
                    case 0 -> RobosurgeonBlockEntity.this.progress;
                    case 1 -> RobosurgeonBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void m_8050_(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        RobosurgeonBlockEntity.this.progress = pValue;
                        break;
                    }
                    case 1: {
                        RobosurgeonBlockEntity.this.maxProgress = pValue;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    public static void tick(Level level, BlockPos pos, BlockState state, RobosurgeonBlockEntity entity) {
        if (level.f_46443_) {
            return;
        }
        BlockPos chamberPos = entity.findChamberPos();
        if (chamberPos == null) {
            entity.resetProgress();
            return;
        }
        BlockEntity be = level.m_7702_(chamberPos);
        if (!(be instanceof SurgeryChamberBlockEntity)) {
            entity.resetProgress();
            return;
        }
        SurgeryChamberBlockEntity chamber = (SurgeryChamberBlockEntity)be;
        if (chamber.isOpen()) {
            if (entity.progress > 0) {
                entity.resetProgress();
                A_PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)entity.findPatient(chamberPos)), (Object)new SyncSurgeryProgressPacket(0, entity.maxProgress));
            }
            return;
        }
        LivingEntity patient = entity.findPatient(chamberPos);
        if (patient == null || !(patient instanceof ServerPlayer)) {
            if (entity.progress > 0) {
                entity.resetProgress();
                chamber.setDoorState(true);
            }
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)patient;
        boolean needs = entity.needsSurgery(serverPlayer);
        boolean requirementsMet = entity.checkRequirements(serverPlayer);
        if (needs && requirementsMet) {
            ++entity.progress;
            RobosurgeonBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
            A_PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new SyncSurgeryProgressPacket(entity.progress, entity.maxProgress));
            if (entity.progress % 20 == 0) {
                serverPlayer.m_6469_(level.m_269111_().m_269425_(), 1.0f);
                level.m_5594_(null, chamberPos, SoundEvents.f_12323_, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            if (entity.progress >= entity.maxProgress) {
                entity.performSurgery(serverPlayer);
                entity.resetProgress();
                A_PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new SyncSurgeryProgressPacket(0, entity.maxProgress));
                chamber.setDoorState(true);
            }
        } else if (entity.progress > 0) {
            entity.resetProgress();
            A_PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new SyncSurgeryProgressPacket(0, entity.maxProgress));
            chamber.setDoorState(true);
        }
    }

    private boolean needsSurgery(ServerPlayer player) {
        LazyOptional cap = player.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY);
        if (!cap.isPresent()) {
            return false;
        }
        ItemStackHandler playerBody = ((CyberwareUserData)cap.resolve().get()).getInstalledCyberware();
        for (int i = 0; i < TOTAL_SLOTS; ++i) {
            ItemStack tableItem = this.itemHandler.getStackInSlot(i);
            ItemStack bodyItem = playerBody.getStackInSlot(i);
            if (!(!tableItem.m_41619_() ? (!tableItem.m_41782_() || !tableItem.m_41783_().m_128471_("cyberware_ghost")) && !ItemStack.m_41728_((ItemStack)tableItem, (ItemStack)bodyItem) : !bodyItem.m_41619_())) continue;
            return true;
        }
        return false;
    }

    private BlockPos findChamberPos() {
        BlockPos below = this.f_58858_.m_7495_();
        BlockState state = this.f_58857_.m_8055_(below);
        if (state.m_60734_() instanceof SurgeryChamberBlock) {
            if (state.m_61143_(SurgeryChamberBlock.HALF) == DoubleBlockHalf.UPPER) {
                return below.m_7495_();
            }
            return below;
        }
        return null;
    }

    private LivingEntity findPatient(BlockPos chamberPos) {
        double z;
        double y;
        double x = chamberPos.m_123341_();
        AABB box = new AABB(x + 0.3, (y = (double)chamberPos.m_123342_()) + 0.1, (z = (double)chamberPos.m_123343_()) + 0.3, x + 0.7, y + 1.9, z + 0.7);
        List entities = this.f_58857_.m_45976_(LivingEntity.class, box);
        if (!entities.isEmpty()) {
            return (LivingEntity)entities.get(0);
        }
        return null;
    }

    public void populateGhostItems(ServerPlayer player) {
        player.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(userData -> {
            ItemStackHandler playerBody = userData.getInstalledCyberware();
            boolean changed = false;
            for (int i = 0; i < TOTAL_SLOTS; ++i) {
                ItemStack bodyStack = playerBody.getStackInSlot(i);
                ItemStack tableStack = this.itemHandler.getStackInSlot(i);
                if (!tableStack.m_41619_() || bodyStack.m_41619_()) continue;
                ItemStack ghostStack = bodyStack.m_41777_();
                ghostStack.m_41784_().m_128379_("cyberware_ghost", true);
                this.itemHandler.setStackInSlot(i, ghostStack);
                changed = true;
            }
            if (changed) {
                this.m_6596_();
                if (this.f_58857_ != null) {
                    this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
                }
            }
        });
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    private boolean checkRequirements(ServerPlayer player) {
        LazyOptional cap = player.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY);
        if (!cap.isPresent()) {
            return false;
        }
        ItemStackHandler playerBody = ((CyberwareUserData)cap.resolve().get()).getInstalledCyberware();
        ArrayList<ItemStack> futureBody = new ArrayList<ItemStack>();
        for (int i = 0; i < TOTAL_SLOTS; ++i) {
            ItemStack tableStack = this.itemHandler.getStackInSlot(i);
            ItemStack bodyStack = playerBody.getStackInSlot(i);
            if (tableStack.m_41619_()) {
                futureBody.add(ItemStack.f_41583_);
                continue;
            }
            if (tableStack.m_41782_() && tableStack.m_41783_().m_128471_("cyberware_ghost")) {
                futureBody.add(bodyStack);
                continue;
            }
            futureBody.add(tableStack);
        }
        for (ItemStack stack : futureBody) {
            Item item;
            if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof ICyberware)) continue;
            ICyberware cw = (ICyberware)item;
            Set<Item> reqs = cw.getPrerequisites(stack);
            for (Item reqItem : reqs) {
                boolean found = false;
                for (ItemStack checkStack : futureBody) {
                    if (checkStack.m_41619_() || checkStack.m_41720_() != reqItem) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        }
        return true;
    }

    public void performSurgery(ServerPlayer player) {
        player.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(userData -> {
            ItemStackHandler playerBody = userData.getInstalledCyberware();
            boolean soundPlayed = false;
            for (int i = 0; i < TOTAL_SLOTS; ++i) {
                ItemStack tableStack = this.itemHandler.getStackInSlot(i);
                ItemStack bodyStack = playerBody.getStackInSlot(i);
                if (!tableStack.m_41619_() && tableStack.m_41782_() && tableStack.m_41783_().m_128471_("cyberware_ghost")) continue;
                if (tableStack.m_41619_()) {
                    if (bodyStack.m_41619_()) continue;
                    ItemStack removed = bodyStack.m_41777_();
                    playerBody.setStackInSlot(i, ItemStack.f_41583_);
                    if (!player.m_150109_().m_36054_(removed)) {
                        player.m_36176_(removed, false);
                    }
                    soundPlayed = true;
                    continue;
                }
                ItemStack extractedNew = this.itemHandler.extractItem(i, 64, false);
                ItemStack oldBodyItem = bodyStack.m_41777_();
                playerBody.setStackInSlot(i, extractedNew);
                if (!oldBodyItem.m_41619_() && !player.m_150109_().m_36054_(oldBodyItem)) {
                    player.m_36176_(oldBodyItem, false);
                }
                soundPlayed = true;
            }
            if (soundPlayed) {
                userData.recalculateCapacity(player);
                userData.syncToClient(player);
                player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_12008_, SoundSource.PLAYERS, 1.0f, 1.0f);
                if (userData.getTolerance() <= 0) {
                    DamageSource surgeryDeath = new DamageSource((Holder)player.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268724_)){

                        public Component m_6157_(LivingEntity entity) {
                            return Component.m_237110_((String)"death.attack.cyberware.surgery", (Object[])new Object[]{entity.m_5446_()});
                        }
                    };
                    player.m_6469_(surgeryDeath, Float.MAX_VALUE);
                }
                this.populateGhostItems(player);
            }
        });
    }

    private void resetProgress() {
        this.progress = 0;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.cyber_ware_port.robosurgeon");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new RobosurgeonMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        pTag.m_128405_("robosurgeon.progress", this.progress);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
        this.progress = pTag.m_128451_("robosurgeon.progress");
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.m_41619_() || stack.m_41782_() && stack.m_41783_().m_128471_("cyberware_ghost")) continue;
            inventory.m_6836_(i, stack);
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }
}

