/*
 * Decompiled with CFR 0.152.
 */
package com.Maxwell.cyber_ware_port.Common.Container;

import com.Maxwell.cyber_ware_port.Common.Block.Component_Box.ComponentBoxBlockEntity;
import com.Maxwell.cyber_ware_port.Init.ModMenuTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ComponentBoxMenu
extends AbstractContainerMenu {
    private final ItemStack lockedStack;
    private final int lockedSlotIndex;

    public ComponentBoxMenu(int id, Inventory playerInv, FriendlyByteBuf extraData) {
        super((MenuType)ModMenuTypes.COMPONENT_BOX_MENU.get(), id);
        LazyOptional cap;
        boolean mainHand = extraData.readBoolean();
        this.lockedStack = playerInv.f_35978_.m_21120_(mainHand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
        this.lockedSlotIndex = mainHand ? playerInv.f_35977_ : 40;
        ItemStackHandler handler = new ItemStackHandler(18);
        if (!this.lockedStack.m_41619_() && (cap = this.lockedStack.getCapability(ForgeCapabilities.ITEM_HANDLER)).isPresent()) {
            handler = (IItemHandler)cap.resolve().get();
        }
        this.addBoxSlots((IItemHandler)handler);
        this.addPlayerInventory(playerInv);
    }

    public ComponentBoxMenu(int id, Inventory playerInv, ItemStack boxStack) {
        super((MenuType)ModMenuTypes.COMPONENT_BOX_MENU.get(), id);
        this.lockedStack = boxStack;
        this.lockedSlotIndex = playerInv.f_35978_.m_21205_() == boxStack ? playerInv.f_35977_ : 40;
        boxStack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(this::addBoxSlots);
        this.addPlayerInventory(playerInv);
    }

    public ComponentBoxMenu(int id, Inventory playerInv, ComponentBoxBlockEntity blockEntity) {
        super((MenuType)ModMenuTypes.COMPONENT_BOX_MENU.get(), id);
        this.lockedStack = ItemStack.f_41583_;
        this.lockedSlotIndex = -1;
        blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(this::addBoxSlots);
        this.addPlayerInventory(playerInv);
    }

    private void addBoxSlots(IItemHandler handler) {
        for (int row = 0; row < 2; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_((Slot)new SlotItemHandler(handler, col + row * 9, 8 + col * 18, 18 + row * 18));
            }
        }
    }

    private void addPlayerInventory(Inventory playerInv) {
        int yOffset = 68;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInv, col + row * 9 + 9, 8 + col * 18, yOffset + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInv, col, 8 + col * 18, yOffset + 58));
        }
    }

    public boolean m_6875_(Player player) {
        if (!this.lockedStack.m_41619_()) {
            return player.m_150109_().m_36063_(this.lockedStack);
        }
        return true;
    }

    public void m_150399_(int slotId, int button, ClickType clickType, Player player) {
        if (this.lockedSlotIndex >= 0) {
            if (slotId >= 0 && slotId < this.f_38839_.size() && ((Slot)this.f_38839_.get(slotId)).m_7993_() == this.lockedStack) {
                return;
            }
            if (clickType == ClickType.SWAP && button == this.lockedSlotIndex) {
                return;
            }
        }
        super.m_150399_(slotId, button, clickType, player);
    }

    public ItemStack m_7648_(Player player, int index) {
        return ItemStack.f_41583_;
    }
}

