/*
 * Decompiled with CFR 0.152.
 */
package com.Maxwell.cyber_ware_port.Common.Entity.Monster.CyberWither;

import com.Maxwell.cyber_ware_port.Common.Entity.Monster.CyberWither.CyberWitherBoss;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class CyberWitherModel
extends HierarchicalModel<CyberWitherBoss> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("cyber_ware_port", "cyber_wither"), "main");
    private static final String RIBCAGE = "ribcage";
    private static final String CENTER_HEAD = "center_head";
    private static final String RIGHT_HEAD = "right_head";
    private static final String LEFT_HEAD = "left_head";
    private static final float RIBCAGE_X_ROT_OFFSET = 0.065f;
    private static final float TAIL_X_ROT_OFFSET = 0.265f;
    private final ModelPart root;
    private final ModelPart centerHead;
    private final ModelPart rightHead;
    private final ModelPart leftHead;
    private final ModelPart ribcage;
    private final ModelPart tail;

    public CyberWitherModel(ModelPart pRoot) {
        this.root = pRoot;
        this.ribcage = pRoot.m_171324_(RIBCAGE);
        this.tail = pRoot.m_171324_("tail");
        this.centerHead = pRoot.m_171324_(CENTER_HEAD);
        this.rightHead = pRoot.m_171324_(RIGHT_HEAD);
        this.leftHead = pRoot.m_171324_(LEFT_HEAD);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        CubeDeformation pCubeDeformation = CubeDeformation.f_171458_;
        partdefinition.m_171599_("shoulders", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-10.0f, 3.9f, -0.5f, 20.0f, 3.0f, 3.0f, pCubeDeformation), PartPose.f_171404_);
        float f = 0.20420352f;
        partdefinition.m_171599_(RIBCAGE, CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(0.0f, 0.0f, 0.0f, 3.0f, 10.0f, 3.0f, pCubeDeformation).m_171514_(24, 22).m_171488_(-4.0f, 1.5f, 0.5f, 11.0f, 2.0f, 2.0f, pCubeDeformation).m_171514_(24, 22).m_171488_(-4.0f, 4.0f, 0.5f, 11.0f, 2.0f, 2.0f, pCubeDeformation).m_171514_(24, 22).m_171488_(-4.0f, 6.5f, 0.5f, 11.0f, 2.0f, 2.0f, pCubeDeformation), PartPose.m_171423_((float)-2.0f, (float)6.9f, (float)-0.5f, (float)0.20420352f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(12, 22).m_171488_(0.0f, 0.0f, 0.0f, 3.0f, 6.0f, 3.0f, pCubeDeformation), PartPose.m_171423_((float)-2.0f, (float)(6.9f + Mth.m_14089_((float)0.20420352f) * 10.0f), (float)(-0.5f + Mth.m_14031_((float)0.20420352f) * 10.0f), (float)0.83252203f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_(CENTER_HEAD, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, pCubeDeformation), PartPose.f_171404_);
        CubeListBuilder cubelistbuilder = CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -4.0f, -4.0f, 6.0f, 6.0f, 6.0f, pCubeDeformation);
        partdefinition.m_171599_(RIGHT_HEAD, cubelistbuilder, PartPose.m_171419_((float)-8.0f, (float)4.0f, (float)0.0f));
        partdefinition.m_171599_(LEFT_HEAD, cubelistbuilder, PartPose.m_171419_((float)10.0f, (float)4.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    private static <T extends CyberWitherBoss> void setupHeadRotation(T pWither, ModelPart pPart, int pHead) {
        pPart.f_104204_ = (pWither.getHeadYRot(pHead) - pWither.f_20883_) * ((float)Math.PI / 180);
        pPart.f_104203_ = pWither.getHeadXRot(pHead) * ((float)Math.PI / 180);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void setupAnim(CyberWitherBoss pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        float f = Mth.m_14089_((float)(pAgeInTicks * 0.1f));
        this.ribcage.f_104203_ = (0.065f + 0.05f * f) * (float)Math.PI;
        this.tail.m_104227_(-2.0f, 6.9f + Mth.m_14089_((float)this.ribcage.f_104203_) * 10.0f, -0.5f + Mth.m_14031_((float)this.ribcage.f_104203_) * 10.0f);
        this.tail.f_104203_ = (0.265f + 0.1f * f) * (float)Math.PI;
        this.centerHead.f_104204_ = pNetHeadYaw * ((float)Math.PI / 180);
        this.centerHead.f_104203_ = pHeadPitch * ((float)Math.PI / 180);
    }

    public void prepareMobModel(CyberWitherBoss pEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick) {
        CyberWitherModel.setupHeadRotation(pEntity, this.rightHead, 0);
        CyberWitherModel.setupHeadRotation(pEntity, this.leftHead, 1);
    }
}

