/*
 * Decompiled with CFR 0.152.
 */
package com.Maxwell.cyber_ware_port.Common.Item.Base;

import com.Maxwell.cyber_ware_port.Common.Item.Base.BodyPartType;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.Set;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.energy.IEnergyStorage;

public interface ICyberware {
    public int getEssenceCost(ItemStack var1);

    public int getSlot(ItemStack var1);

    public boolean isPristine(ItemStack var1);

    public void setPristine(ItemStack var1, boolean var2);

    public int getMaxInstallAmount(ItemStack var1);

    public Set<Item> getPrerequisites(ItemStack var1);

    default public Set<Item> getIncompatibleItems(ItemStack stack) {
        return Collections.emptySet();
    }

    public boolean hasEnergyProperties(ItemStack var1);

    public int getEnergyConsumption(ItemStack var1);

    public int getEnergyGeneration(ItemStack var1);

    public int getEnergyStorage(ItemStack var1);

    public StackingRule getStackingEnergyRule(ItemStack var1);

    default public boolean isIncompatible(ItemStack self, ItemStack other) {
        if (self.m_41720_() == other.m_41720_()) {
            return this.getMaxInstallAmount(self) <= 1;
        }
        return this.getIncompatibleItems(self).contains(other.m_41720_());
    }

    default public BodyPartType getBodyPartType(ItemStack stack) {
        return BodyPartType.NONE;
    }

    default public void onWornTick(LivingEntity entity, ItemStack stack, IEnergyStorage energyStorage) {
    }

    default public boolean canToggle(ItemStack stack) {
        return false;
    }

    default public boolean isActive(ItemStack stack) {
        return !stack.m_41782_() || !stack.m_41783_().m_128441_("active") || stack.m_41783_().m_128471_("active");
    }

    default public void toggle(ItemStack stack) {
        boolean currentState = this.isActive(stack);
        stack.m_41784_().m_128379_("active", !currentState);
    }

    default public Multimap<Attribute, AttributeModifier> getAttributeModifiers(ItemStack stack) {
        return ArrayListMultimap.create();
    }

    public static enum StackingRule {
        LINEAR,
        DIMINISHING,
        STATIC;


        public int calculate(int baseCost, int count) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case LINEAR -> baseCost * count;
                case DIMINISHING -> (int)((double)baseCost * (1.0 + Math.log(count)));
                case STATIC -> count > 0 ? baseCost : 0;
            };
        }
    }
}

