/*
 * Decompiled with CFR 0.152.
 */
package com.Maxwell.cyber_ware_port.Common.Item.CyberWare;

import com.Maxwell.cyber_ware_port.Common.Capability.CyberwareCapabilityProvider;
import com.Maxwell.cyber_ware_port.Common.Capability.CyberwareUserData;
import com.Maxwell.cyber_ware_port.Common.Item.Base.ICyberware;
import com.Maxwell.cyber_ware_port.Common.Network.A_PacketHandler;
import com.Maxwell.cyber_ware_port.Common.Network.DoubleJumpPacket;
import com.Maxwell.cyber_ware_port.Init.ModEntities;
import com.Maxwell.cyber_ware_port.Init.ModItems;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemStackHandler;

@Mod.EventBusSubscriber(modid="cyber_ware_port")
public class ModCyberwareEvents {
    private static final List<Supplier<? extends EntityType<? extends Monster>>> CYBER_MOBS = Arrays.asList(ModEntities.CYBER_ZOMBIE, ModEntities.CYBER_SKELETON, ModEntities.CYBER_CREEPER);
    private static final String NBT_CROUCH_TIME = "cyberware_crouch_time";
    private static final String NBT_DOUBLE_JUMPED = "cyberware_double_jumped";

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side.isClient() || event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        player.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(data -> {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                data.tick(serverPlayer);
            }
        });
        if (player.m_9236_().m_46467_() % 20L != 0L) {
            return;
        }
        player.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(data -> {
            if (data.isCyberwareInstalled((Item)ModItems.CRANIAL_BROADCASTER.get())) {
                int spawnCost;
                ItemStack stack = ItemStack.f_41583_;
                ItemStackHandler handler = data.getInstalledCyberware();
                for (int i = 0; i < handler.getSlots(); ++i) {
                    if (handler.getStackInSlot(i).m_41720_() != ModItems.CRANIAL_BROADCASTER.get()) continue;
                    stack = handler.getStackInSlot(i);
                    break;
                }
                if (!stack.m_41619_() && ((ICyberware)stack.m_41720_()).isActive(stack) && player.m_217043_().m_188503_(20) == 0 && data.extractEnergy(spawnCost = 200, false) == spawnCost) {
                    ModCyberwareEvents.spawnRandomCyberMob(player);
                }
            }
        });
    }

    private static void spawnRandomCyberMob(Player player) {
        Monster mob;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        double angle = player.m_217043_().m_188500_() * Math.PI * 2.0;
        double distance = 20.0 + player.m_217043_().m_188500_() * 20.0;
        int x = Mth.m_14107_((double)(player.m_20185_() + Math.cos(angle) * distance));
        int z = Mth.m_14107_((double)(player.m_20189_() + Math.sin(angle) * distance));
        int y = serverLevel.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z);
        BlockPos spawnPos = new BlockPos(x, y, z);
        EntityType<? extends Monster> mobType = CYBER_MOBS.get(player.m_217043_().m_188503_(CYBER_MOBS.size())).get();
        if (NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)serverLevel, (BlockPos)spawnPos, mobType) && (mob = (Monster)mobType.m_20615_((Level)serverLevel)) != null) {
            mob.m_7678_((double)x + 0.5, (double)y, (double)z + 0.5, player.m_217043_().m_188501_() * 360.0f, 0.0f);
            if (mob.m_5545_((LevelAccessor)serverLevel, MobSpawnType.EVENT)) {
                serverLevel.m_7967_((Entity)mob);
            }
        }
    }

    @SubscribeEvent
    public static void onEnderTeleport(EntityTeleportEvent.EnderEntity event) {
        BlockPos targetPos = new BlockPos((int)event.getTargetX(), (int)event.getTargetY(), (int)event.getTargetZ());
        List players = event.getEntity().m_9236_().m_45976_(Player.class, new AABB(targetPos).m_82400_(16.0));
        for (Player player : players) {
            boolean jammed = player.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).map(data -> {
                if (data.isCyberwareInstalled((Item)ModItems.ENDER_JAMMER.get())) {
                    ItemStack stack = ItemStack.f_41583_;
                    ItemStackHandler handler = data.getInstalledCyberware();
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        if (handler.getStackInSlot(i).m_41720_() != ModItems.ENDER_JAMMER.get()) continue;
                        stack = handler.getStackInSlot(i);
                        break;
                    }
                    if (!stack.m_41619_() && ((ICyberware)stack.m_41720_()).isActive(stack)) {
                        return data.extractEnergy(200, false) == 200;
                    }
                }
                return false;
            }).orElse(false);
            if (!jammed) continue;
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public static void onItemUseTick(LivingEntityUseItemEvent.Tick event) {
        if (event.getItem().m_41720_() instanceof BowItem) {
            event.getEntity().getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(userData -> {
                int costPerTick;
                if (userData.isCyberwareInstalled((Item)ModItems.RAPID_FIRE_FLYWHEEL.get()) && userData.extractEnergy(costPerTick = 2, false) == costPerTick) {
                    event.setDuration(event.getDuration() - 1);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(data -> {
                int dodgeCost;
                boolean isLightlyArmored;
                boolean bl = isLightlyArmored = player.m_6844_(EquipmentSlot.HEAD).m_41619_() && player.m_6844_(EquipmentSlot.CHEST).m_41619_();
                if (isLightlyArmored && data.isCyberwareInstalled((Item)ModItems.THREAT_MATRIX.get()) && player.m_217043_().m_188501_() < 0.3f && data.extractEnergy(dodgeCost = 500, false) == dodgeCost) {
                    event.setCanceled(true);
                    player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 2.0f);
                    return;
                }
                Entity patt8622$temp = event.getSource().m_7639_();
                if (patt8622$temp instanceof LivingEntity) {
                    int reflexCost;
                    LivingEntity attacker = (LivingEntity)patt8622$temp;
                    if (data.isCyberwareInstalled((Item)ModItems.WIRED_REFLEXES.get()) && data.extractEnergy(reflexCost = 10, false) == reflexCost) {
                        player.m_7618_(EntityAnchorArgument.Anchor.EYES, attacker.m_146892_());
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        if (player.m_7500_()) {
            return;
        }
        if (!player.m_9236_().f_46443_) {
            player.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(data -> {
                if (data.isCyberwareInstalled((Item)ModItems.NEURAL_CONTEXTUALIZER.get())) {
                    BlockState state = player.m_9236_().m_8055_(event.getPos());
                    ItemStack currentStack = player.m_21205_();
                    if (currentStack.m_41691_(state) > 1.0f) {
                        return;
                    }
                    int bestSlot = -1;
                    float bestSpeed = 1.0f;
                    for (int i = 0; i < 9; ++i) {
                        ItemStack stack = player.m_150109_().m_8020_(i);
                        float speed = stack.m_41691_(state);
                        if (!(speed > bestSpeed)) continue;
                        bestSpeed = speed;
                        bestSlot = i;
                    }
                    if (bestSlot != -1 && bestSlot != player.m_150109_().f_35977_) {
                        player.m_150109_().f_35977_ = bestSlot;
                        ((ServerPlayer)player).f_8906_.m_9829_((Packet)new ClientboundSetCarriedItemPacket(bestSlot));
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public static void onPotionAdded(MobEffectEvent.Applicable event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            player = (Player)livingEntity;
            if (event.getEffectInstance().m_19544_() == MobEffects.f_19613_) {
                player.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(data -> {
                    int pumpCost;
                    if (data.isCyberwareInstalled((Item)ModItems.CARDIOMECHANIC_PUMP.get()) && data.extractEnergy(pumpCost = 50, false) == pumpCost) {
                        event.setResult(Event.Result.DENY);
                    }
                });
            }
        }
        if ((livingEntity = event.getEntity()) instanceof Player) {
            player = (Player)livingEntity;
            if (event.getEffectInstance().m_19544_().m_19483_() == MobEffectCategory.HARMFUL) {
                player.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(data -> {
                    int cost;
                    if (data.isCyberwareInstalled((Item)ModItems.LIVER_FILTER.get()) && data.extractEnergy(cost = 50, false) == cost) {
                        event.setResult(Event.Result.DENY);
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            player.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(data -> {
                int totalXp;
                int cost;
                if (data.isCyberwareInstalled((Item)ModItems.INTERNAL_DEFIBRILLATOR.get()) && data.extractEnergy(cost = 500, false) == cost) {
                    event.setCanceled(true);
                    player.m_21153_(player.m_21233_() * 0.5f);
                    player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_12513_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    return;
                }
                if (data.isCyberwareInstalled((Item)ModItems.CORTICAL_STACK.get()) && (totalXp = ModCyberwareEvents.getTotalXp((Player)player)) > 0) {
                    ItemStack capsule = new ItemStack((ItemLike)ModItems.EXP_CAPSULE.get());
                    capsule.m_41784_().m_128405_("xp", totalXp);
                    player.m_36176_(capsule, true);
                    player.f_36079_ = 0;
                    player.f_36078_ = 0;
                    player.f_36080_ = 0.0f;
                }
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            event.getOriginal().getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(oldData -> {
                if (oldData.isCyberwareInstalled((Item)ModItems.CONSCIOUSNESS_TRANSMITTER.get())) {
                    // empty if block
                }
            });
        }
    }

    private static int getTotalXp(Player player) {
        return (int)((float)(player.f_36078_ * 7) + player.f_36080_ * (float)player.m_36323_());
    }

    @SubscribeEvent
    public static void onHarvestCheck(PlayerEvent.HarvestCheck event) {
        if (event.canHarvest()) {
            return;
        }
        Player player = event.getEntity();
        player.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(data -> {
            if (data.isCyberwareInstalled((Item)ModItems.REINFORCED_FIST.get()) && player.m_21205_().m_41619_()) {
                event.setCanHarvest(true);
            }
        });
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        if (player.m_21205_().m_41619_()) {
            player.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(data -> {
                if (data.isCyberwareInstalled((Item)ModItems.REINFORCED_FIST.get())) {
                    event.setNewSpeed(4.0f);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        player.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(data -> {
            int cost;
            if (data.isCyberwareInstalled((Item)ModItems.LINEAR_ACTUATORS.get())) {
                CompoundTag tag = player.getPersistentData();
                if (player.m_6047_() && player.m_20096_()) {
                    int time = tag.m_128451_(NBT_CROUCH_TIME);
                    tag.m_128405_(NBT_CROUCH_TIME, time + 1);
                } else if (!player.m_6047_()) {
                    tag.m_128405_(NBT_CROUCH_TIME, 0);
                }
                if (player.f_19862_ && !player.m_20096_()) {
                    tag.m_128379_(NBT_DOUBLE_JUMPED, false);
                    Vec3 motion = player.m_20184_();
                    if (motion.f_82480_ < 0.0) {
                        player.m_20334_(motion.f_82479_, -0.15, motion.f_82481_);
                        player.f_19789_ = 0.0f;
                    }
                }
                if (player.m_20096_()) {
                    tag.m_128379_(NBT_DOUBLE_JUMPED, false);
                }
            }
            if (data.isCyberwareInstalled((Item)ModItems.AQUATIC_PROPULSION.get()) && player.m_20069_() && data.extractEnergy(cost = 1, false) == cost) {
                boolean isMoving;
                boolean bl = isMoving = player.m_20184_().m_82556_() > 0.001 || Math.abs(player.f_20900_) > 0.0f || Math.abs(player.f_20902_) > 0.0f;
                if (isMoving) {
                    Vec3 look = player.m_20154_();
                    Vec3 motion = player.m_20184_();
                    double speed = 0.05;
                    player.m_20256_(motion.m_82520_(look.f_82479_ * speed, look.f_82480_ * speed, look.f_82481_ * speed));
                }
            }
            if (data.isCyberwareInstalled((Item)ModItems.SOLARSKIN.get())) {
                boolean isDaytime;
                Level level = player.m_9236_();
                long time = level.m_46468_() % 24000L;
                boolean bl = isDaytime = time < 12500L || time > 23500L;
                if (level.m_6042_().f_223549_() && isDaytime && !level.m_46471_() && level.m_45527_(player.m_20183_())) {
                    int totalCount = 0;
                    ItemStackHandler handler = data.getInstalledCyberware();
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        ItemStack stack = handler.getStackInSlot(i);
                        if (stack.m_41720_() != ModItems.SOLARSKIN.get()) continue;
                        totalCount += stack.m_41613_();
                    }
                    int generationAmount = 2 * totalCount;
                    if (generationAmount > 0) {
                        data.receiveEnergy(generationAmount, false);
                    }
                }
            }
            if (data.isCyberwareInstalled((Item)ModItems.DEPLOYABLE_WHEELS.get())) {
                boolean isActive = false;
                ItemStackHandler handler = data.getInstalledCyberware();
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack stack = handler.getStackInSlot(i);
                    if (stack.m_41720_() != ModItems.DEPLOYABLE_WHEELS.get()) continue;
                    if (!((ICyberware)stack.m_41720_()).isActive(stack)) break;
                    isActive = true;
                    break;
                }
                if (isActive) {
                    if (player.m_274421_() < 1.25f) {
                        player.m_274367_(1.25f);
                    }
                } else if (player.m_274421_() > 0.6f) {
                    player.m_274367_(0.6f);
                }
            } else if (player.m_274421_() > 0.6f) {
                player.m_274367_(0.6f);
            }
        });
    }

    @SubscribeEvent
    public static void onLivingFall(LivingFallEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(data -> {
                if (data.isCyberwareInstalled((Item)ModItems.FALL_BRACERS.get())) {
                    float reduction = 4.0f;
                    event.setDistance(Math.max(0.0f, event.getDistance() - reduction));
                }
            });
        }
    }

    @SubscribeEvent
    public static void onLivingJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        player.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(data -> {
            CompoundTag tag;
            int time;
            if (data.isCyberwareInstalled((Item)ModItems.LINEAR_ACTUATORS.get()) && (time = (tag = player.getPersistentData()).m_128451_(NBT_CROUCH_TIME)) >= 60) {
                Vec3 look = player.m_20154_();
                double forwardSpeed = 1.5;
                double upSpeed = 1.25;
                player.m_20334_(look.f_82479_ * forwardSpeed, upSpeed, look.f_82481_ * forwardSpeed);
                tag.m_128405_(NBT_CROUCH_TIME, 0);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        LocalPlayer player;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        if (!(event.getKey() != mc.f_91066_.f_92089_.getKey().m_84873_() || event.getAction() != 1 || (player = mc.f_91074_).m_20096_() || player.m_7500_() || player.m_5833_())) {
            player.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(arg_0 -> ModCyberwareEvents.lambda$onKeyInput$15((Player)player, arg_0));
        }
    }

    public static void performDoubleJump(Player player) {
        Vec3 currentMotion = player.m_20184_();
        Vec3 look = player.m_20154_();
        double boost = 0.5;
        double jumpHeight = 0.6;
        player.m_20334_(currentMotion.f_82479_ + look.f_82479_ * boost, jumpHeight, currentMotion.f_82481_ + look.f_82481_ * boost);
        player.f_19789_ = 0.0f;
        player.getPersistentData().m_128379_(NBT_DOUBLE_JUMPED, true);
    }

    private static /* synthetic */ void lambda$onKeyInput$15(Player player, CyberwareUserData data) {
        if (data.isCyberwareInstalled((Item)ModItems.LINEAR_ACTUATORS.get()) && !player.getPersistentData().m_128471_(NBT_DOUBLE_JUMPED)) {
            A_PacketHandler.INSTANCE.sendToServer((Object)new DoubleJumpPacket());
            ModCyberwareEvents.performDoubleJump(player);
        }
    }
}

