/*
 * Decompiled with CFR 0.152.
 */
package com.Maxwell.cyber_ware_port.Common.Network;

import com.Maxwell.cyber_ware_port.Common.Capability.CyberwareCapabilityProvider;
import com.Maxwell.cyber_ware_port.Common.Item.Base.ICyberware;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ToggleCyberwarePacket {
    private final int slotId;

    public ToggleCyberwarePacket(int slotId) {
        this.slotId = slotId;
    }

    public ToggleCyberwarePacket(FriendlyByteBuf buf) {
        this.slotId = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.slotId);
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                player.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(data -> {
                    ICyberware cyberware;
                    Item patt1315$temp;
                    ItemStack stack = data.getInstalledCyberware().getStackInSlot(this.slotId);
                    if (!stack.m_41619_() && (patt1315$temp = stack.m_41720_()) instanceof ICyberware && (cyberware = (ICyberware)patt1315$temp).canToggle(stack)) {
                        cyberware.toggle(stack);
                        data.recalculateCapacity(player);
                        data.syncToClient(player);
                    }
                });
            }
        });
        context.setPacketHandled(true);
    }
}

