/*
 * Decompiled with CFR 0.152.
 */
package net.juujks.craft_defense.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import net.juujks.craft_defense.network.UpgradeUnitGUIButtonMessage;
import net.juujks.craft_defense.procedures.DmgP2Procedure;
import net.juujks.craft_defense.procedures.LvlPProcedure;
import net.juujks.craft_defense.procedures.MoneyShowOverlayProcedure;
import net.juujks.craft_defense.procedures.NextUpPProcedure;
import net.juujks.craft_defense.procedures.ReturnDMGBPProcedure;
import net.juujks.craft_defense.procedures.ReturnDamageBuffProcedure;
import net.juujks.craft_defense.procedures.ReturnPriorityPProcedure;
import net.juujks.craft_defense.procedures.ReturnRNGBPProcedure;
import net.juujks.craft_defense.procedures.ReturnRangeBuffProcedure;
import net.juujks.craft_defense.procedures.ReturnSPABPProcedure;
import net.juujks.craft_defense.procedures.ReturnSpaBuffProcedure;
import net.juujks.craft_defense.procedures.ReturnTraitPProcedure;
import net.juujks.craft_defense.procedures.RngPProcedure;
import net.juujks.craft_defense.procedures.ShowEntityTestProcedure;
import net.juujks.craft_defense.procedures.SpaPProcedure;
import net.juujks.craft_defense.procedures.UnitLevelPProcedure;
import net.juujks.craft_defense.procedures.WaveShowOverlayProcedure;
import net.juujks.craft_defense.world.inventory.UpgradeUnitGUIMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class UpgradeUnitGUIScreen
extends AbstractContainerScreen<UpgradeUnitGUIMenu> {
    private static final HashMap<String, Object> guistate = UpgradeUnitGUIMenu.guistate;
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    Button button_upgrade;
    Button button_sell;
    Button button_empty;
    private static final ResourceLocation texture = ResourceLocation.parse((String)"craft_defense:textures/screens/upgrade_unit_gui.png");

    public UpgradeUnitGUIScreen(UpgradeUnitGUIMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 176;
        this.imageHeight = 180;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        Entity entity = ShowEntityTestProcedure.execute((LevelAccessor)this.world, this.x, this.y, this.z, (Entity)this.entity);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.renderEntityInInventoryFollowsAngle(guiGraphics, this.leftPos + 43, this.topPos + 62, 30, 0.0f + (float)Math.atan((double)(this.leftPos + 43 - mouseX) / 40.0), (float)Math.atan((double)(this.topPos + 13 - mouseY) / 40.0), livingEntity);
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int gx, int gy) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(texture, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        guiGraphics.blit(ResourceLocation.parse((String)"craft_defense:textures/screens/eba3.png"), this.leftPos + 20, this.topPos + 19, 0.0f, 0.0f, 45, 45, 45, 45);
        guiGraphics.blit(ResourceLocation.parse((String)"craft_defense:textures/screens/wooden_sword.png"), this.leftPos + 87, this.topPos + 23, 0.0f, 0.0f, 16, 16, 16, 16);
        guiGraphics.blit(ResourceLocation.parse((String)"craft_defense:textures/screens/wooden_sword_1.png"), this.leftPos + 87, this.topPos + 50, 0.0f, 0.0f, 16, 16, 16, 16);
        guiGraphics.blit(ResourceLocation.parse((String)"craft_defense:textures/screens/speed.png"), this.leftPos + 87, this.topPos + 77, 0.0f, 0.0f, 18, 18, 18, 18);
        guiGraphics.blit(ResourceLocation.parse((String)"craft_defense:textures/screens/eba3.png"), this.leftPos + -43, this.topPos + 118, 0.0f, 0.0f, 45, 45, 45, 45);
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        return super.keyPressed(key, b, c);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.craft_defense.upgrade_unit_gui.label_proc_unit_name_p"), 11, 5, -12829636, false);
        guiGraphics.drawString(this.font, DmgP2Procedure.execute((LevelAccessor)this.world, this.x, this.y, this.z, (Entity)this.entity), 110, 28, -65536, false);
        guiGraphics.drawString(this.font, RngPProcedure.execute((LevelAccessor)this.world, this.x, this.y, this.z, (Entity)this.entity), 110, 55, -256, false);
        guiGraphics.drawString(this.font, SpaPProcedure.execute((LevelAccessor)this.world, this.x, this.y, this.z, (Entity)this.entity), 110, 86, -16776961, false);
        guiGraphics.drawString(this.font, LvlPProcedure.execute((LevelAccessor)this.world, this.x, this.y, this.z, (Entity)this.entity), 6, 82, -256, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.craft_defense.upgrade_unit_gui.label_status"), 119, 5, -12829636, false);
        guiGraphics.drawString(this.font, MoneyShowOverlayProcedure.execute((LevelAccessor)this.world, (Entity)this.entity), -39, 140, -16711917, false);
        guiGraphics.drawString(this.font, WaveShowOverlayProcedure.execute((LevelAccessor)this.world), -39, 127, -1, false);
        guiGraphics.drawString(this.font, NextUpPProcedure.execute((LevelAccessor)this.world, this.x, this.y, this.z, (Entity)this.entity), 47, 140, -15794432, false);
        guiGraphics.drawString(this.font, UnitLevelPProcedure.execute((LevelAccessor)this.world, this.x, this.y, this.z, (Entity)this.entity), 6, 68, -16717592, false);
        guiGraphics.drawString(this.font, ReturnPriorityPProcedure.execute((LevelAccessor)this.world, this.x, this.y, this.z, (Entity)this.entity), 92, 140, -65310, false);
        guiGraphics.drawString(this.font, ReturnTraitPProcedure.execute((LevelAccessor)this.world, this.x, this.y, this.z, (Entity)this.entity), 6, 95, -12829636, false);
        if (ReturnDMGBPProcedure.execute((LevelAccessor)this.world, this.x, this.y, this.z, (Entity)this.entity)) {
            guiGraphics.drawString(this.font, ReturnDamageBuffProcedure.execute((LevelAccessor)this.world, this.x, this.y, this.z, (Entity)this.entity), 110, 41, -65536, false);
        }
        if (ReturnRNGBPProcedure.execute((LevelAccessor)this.world, this.x, this.y, this.z, (Entity)this.entity)) {
            guiGraphics.drawString(this.font, ReturnRangeBuffProcedure.execute((LevelAccessor)this.world, this.x, this.y, this.z, (Entity)this.entity), 110, 68, -256, false);
        }
        if (ReturnSPABPProcedure.execute((LevelAccessor)this.world, this.x, this.y, this.z, (Entity)this.entity)) {
            guiGraphics.drawString(this.font, ReturnSpaBuffProcedure.execute((LevelAccessor)this.world, this.x, this.y, this.z, (Entity)this.entity), 110, 100, -16776961, false);
        }
    }

    public void init() {
        super.init();
        this.button_upgrade = Button.builder((Component)Component.translatable((String)"gui.craft_defense.upgrade_unit_gui.button_upgrade"), e -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new UpgradeUnitGUIButtonMessage(0, this.x, this.y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            UpgradeUnitGUIButtonMessage.handleButtonAction(this.entity, 0, this.x, this.y, this.z);
        }).bounds(this.leftPos + 33, this.topPos + 154, 61, 20).build();
        guistate.put("button:button_upgrade", this.button_upgrade);
        this.addRenderableWidget((GuiEventListener)this.button_upgrade);
        this.button_sell = Button.builder((Component)Component.translatable((String)"gui.craft_defense.upgrade_unit_gui.button_sell"), e -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new UpgradeUnitGUIButtonMessage(1, this.x, this.y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            UpgradeUnitGUIButtonMessage.handleButtonAction(this.entity, 1, this.x, this.y, this.z);
        }).bounds(this.leftPos + 96, this.topPos + 154, 46, 20).build();
        guistate.put("button:button_sell", this.button_sell);
        this.addRenderableWidget((GuiEventListener)this.button_sell);
        this.button_empty = Button.builder((Component)Component.translatable((String)"gui.craft_defense.upgrade_unit_gui.button_empty"), e -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new UpgradeUnitGUIButtonMessage(2, this.x, this.y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            UpgradeUnitGUIButtonMessage.handleButtonAction(this.entity, 2, this.x, this.y, this.z);
        }).bounds(this.leftPos + 92, this.topPos + 118, 30, 20).build();
        guistate.put("button:button_empty", this.button_empty);
        this.addRenderableWidget((GuiEventListener)this.button_empty);
    }

    private void renderEntityInInventoryFollowsAngle(GuiGraphics guiGraphics, int x, int y, int scale, float angleXComponent, float angleYComponent, LivingEntity entity) {
        Quaternionf pose = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf cameraOrientation = new Quaternionf().rotateX(angleYComponent * 20.0f * ((float)Math.PI / 180));
        pose.mul((Quaternionfc)cameraOrientation);
        float f2 = entity.yBodyRot;
        float f3 = entity.getYRot();
        float f4 = entity.getXRot();
        float f5 = entity.yHeadRotO;
        float f6 = entity.yHeadRot;
        entity.yBodyRot = 180.0f + angleXComponent * 20.0f;
        entity.setYRot(180.0f + angleXComponent * 40.0f);
        entity.setXRot(-angleYComponent * 20.0f);
        entity.yHeadRot = entity.getYRot();
        entity.yHeadRotO = entity.getYRot();
        InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (float)x, (float)y, (float)scale, (Vector3f)new Vector3f(0.0f, 0.0f, 0.0f), (Quaternionf)pose, (Quaternionf)cameraOrientation, (LivingEntity)entity);
        entity.yBodyRot = f2;
        entity.setYRot(f3);
        entity.setXRot(f4);
        entity.yHeadRotO = f5;
        entity.yHeadRot = f6;
    }
}

