/*
 * Decompiled with CFR 0.152.
 */
package net.juujks.craft_defense.network;

import java.util.function.Supplier;
import net.juujks.craft_defense.CraftDefenseMod;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class CraftDefenseModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"craft_defense");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        CraftDefenseMod.addNetworkMessage(SavedDataSyncMessage.TYPE, SavedDataSyncMessage.STREAM_CODEC, SavedDataSyncMessage::handleData);
        CraftDefenseMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    public record SavedDataSyncMessage(int dataType, SavedData data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SavedDataSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"craft_defense", (String)"saved_data_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SavedDataSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeInt(message.dataType);
            if (message.data != null) {
                buffer.writeNbt((Tag)message.data.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
            }
        }, buffer -> {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                }
            }
            return new SavedDataSyncMessage(dataType, data);
        });

        public CustomPacketPayload.Type<SavedDataSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(SavedDataSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    } else {
                        WorldVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"craft_defense", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeNbt((Tag)message.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess())), buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data.serializeNBT((HolderLookup.Provider)context.player().registryAccess()))).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        public double alex_spawned = 0.0;
        public boolean autoSkip = false;
        public boolean autoSkip2 = false;
        public double creeper_spawned = 0.0;
        public boolean gameNotWon = false;
        public boolean gameWon = false;
        public boolean isInQueue = false;
        public boolean isStarter = true;
        public double lastBeatenAct = 0.0;
        public String lastRolledRarity = "\"\"";
        public String lastRolledUnit = "\"\"";
        public String lastUnitType = "\"\"";
        public double moneyIG = 0.0;
        public String oldDim = "\"\"";
        public double oldX = 0.0;
        public double oldY = 0.0;
        public double oldZ = 0.0;
        public boolean playerInGame = false;
        public boolean playerVoted = false;
        public boolean playerVotedStart = false;
        public double skeleton_spawned = 0.0;
        public boolean skipWaveProcessing = false;
        public double slime_spawned = 0.0;
        public double spider_spawned = 0.0;
        public double steve_spawned = 0.0;
        public double unitLevel = 0.0;
        public double villager_spawned = 0.0;
        public double witch_spawned = 0.0;
        public double zombie_spawned = 0.0;
        public String lastRolledTrait = "\"\"";
        public String lastRolledTraitRarity = "\"\"";
        public double damageBuff = 0.0;
        public double rangeBuff = 0.0;
        public double spaBuff = 0.0;
        public double cavespider_spawned = 0.0;
        public double stray_spawned = 0.0;
        public double zombiepig_spawned = 0.0;
        public double piglin_spawned = 0.0;
        public double puffer_fish_spawned = 0.0;
        public double maxLevel = 0.0;
        public double level = 0.0;
        public double upCost = 0.0;
        public double damage = 0.0;
        public double range = 0.0;
        public double spa = 0.0;
        public String unitName = "\"\"";
        public double iron_golem_spawned = 0.0;
        public String trait = "\"\"";
        public double commonCandies = 0.0;
        public double rareCandies = 0.0;
        public double epicCandies = 0.0;
        public double xpToAdd = 0.0;
        public double snowgolem_spawned = 0.0;
        public double husk_spawned = 0.0;
        public double magmacube_spawned = 0.0;
        public double polarbear_spawned = 0.0;

        public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putDouble("alex_spawned", this.alex_spawned);
            nbt.putBoolean("autoSkip", this.autoSkip);
            nbt.putBoolean("autoSkip2", this.autoSkip2);
            nbt.putDouble("creeper_spawned", this.creeper_spawned);
            nbt.putBoolean("gameNotWon", this.gameNotWon);
            nbt.putBoolean("gameWon", this.gameWon);
            nbt.putBoolean("isInQueue", this.isInQueue);
            nbt.putBoolean("isStarter", this.isStarter);
            nbt.putDouble("lastBeatenAct", this.lastBeatenAct);
            nbt.putString("lastRolledRarity", this.lastRolledRarity);
            nbt.putString("lastRolledUnit", this.lastRolledUnit);
            nbt.putString("lastUnitType", this.lastUnitType);
            nbt.putDouble("moneyIG", this.moneyIG);
            nbt.putString("oldDim", this.oldDim);
            nbt.putDouble("oldX", this.oldX);
            nbt.putDouble("oldY", this.oldY);
            nbt.putDouble("oldZ", this.oldZ);
            nbt.putBoolean("playerInGame", this.playerInGame);
            nbt.putBoolean("playerVoted", this.playerVoted);
            nbt.putBoolean("playerVotedStart", this.playerVotedStart);
            nbt.putDouble("skeleton_spawned", this.skeleton_spawned);
            nbt.putBoolean("skipWaveProcessing", this.skipWaveProcessing);
            nbt.putDouble("slime_spawned", this.slime_spawned);
            nbt.putDouble("spider_spawned", this.spider_spawned);
            nbt.putDouble("steve_spawned", this.steve_spawned);
            nbt.putDouble("unitLevel", this.unitLevel);
            nbt.putDouble("villager_spawned", this.villager_spawned);
            nbt.putDouble("witch_spawned", this.witch_spawned);
            nbt.putDouble("zombie_spawned", this.zombie_spawned);
            nbt.putString("lastRolledTrait", this.lastRolledTrait);
            nbt.putString("lastRolledTraitRarity", this.lastRolledTraitRarity);
            nbt.putDouble("damageBuff", this.damageBuff);
            nbt.putDouble("rangeBuff", this.rangeBuff);
            nbt.putDouble("spaBuff", this.spaBuff);
            nbt.putDouble("cavespider_spawned", this.cavespider_spawned);
            nbt.putDouble("stray_spawned", this.stray_spawned);
            nbt.putDouble("zombiepig_spawned", this.zombiepig_spawned);
            nbt.putDouble("piglin_spawned", this.piglin_spawned);
            nbt.putDouble("puffer_fish_spawned", this.puffer_fish_spawned);
            nbt.putDouble("maxLevel", this.maxLevel);
            nbt.putDouble("level", this.level);
            nbt.putDouble("upCost", this.upCost);
            nbt.putDouble("damage", this.damage);
            nbt.putDouble("range", this.range);
            nbt.putDouble("spa", this.spa);
            nbt.putString("unitName", this.unitName);
            nbt.putDouble("iron_golem_spawned", this.iron_golem_spawned);
            nbt.putString("trait", this.trait);
            nbt.putDouble("commonCandies", this.commonCandies);
            nbt.putDouble("rareCandies", this.rareCandies);
            nbt.putDouble("epicCandies", this.epicCandies);
            nbt.putDouble("xpToAdd", this.xpToAdd);
            nbt.putDouble("snowgolem_spawned", this.snowgolem_spawned);
            nbt.putDouble("husk_spawned", this.husk_spawned);
            nbt.putDouble("magmacube_spawned", this.magmacube_spawned);
            nbt.putDouble("polarbear_spawned", this.polarbear_spawned);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            this.alex_spawned = nbt.getDouble("alex_spawned");
            this.autoSkip = nbt.getBoolean("autoSkip");
            this.autoSkip2 = nbt.getBoolean("autoSkip2");
            this.creeper_spawned = nbt.getDouble("creeper_spawned");
            this.gameNotWon = nbt.getBoolean("gameNotWon");
            this.gameWon = nbt.getBoolean("gameWon");
            this.isInQueue = nbt.getBoolean("isInQueue");
            this.isStarter = nbt.getBoolean("isStarter");
            this.lastBeatenAct = nbt.getDouble("lastBeatenAct");
            this.lastRolledRarity = nbt.getString("lastRolledRarity");
            this.lastRolledUnit = nbt.getString("lastRolledUnit");
            this.lastUnitType = nbt.getString("lastUnitType");
            this.moneyIG = nbt.getDouble("moneyIG");
            this.oldDim = nbt.getString("oldDim");
            this.oldX = nbt.getDouble("oldX");
            this.oldY = nbt.getDouble("oldY");
            this.oldZ = nbt.getDouble("oldZ");
            this.playerInGame = nbt.getBoolean("playerInGame");
            this.playerVoted = nbt.getBoolean("playerVoted");
            this.playerVotedStart = nbt.getBoolean("playerVotedStart");
            this.skeleton_spawned = nbt.getDouble("skeleton_spawned");
            this.skipWaveProcessing = nbt.getBoolean("skipWaveProcessing");
            this.slime_spawned = nbt.getDouble("slime_spawned");
            this.spider_spawned = nbt.getDouble("spider_spawned");
            this.steve_spawned = nbt.getDouble("steve_spawned");
            this.unitLevel = nbt.getDouble("unitLevel");
            this.villager_spawned = nbt.getDouble("villager_spawned");
            this.witch_spawned = nbt.getDouble("witch_spawned");
            this.zombie_spawned = nbt.getDouble("zombie_spawned");
            this.lastRolledTrait = nbt.getString("lastRolledTrait");
            this.lastRolledTraitRarity = nbt.getString("lastRolledTraitRarity");
            this.damageBuff = nbt.getDouble("damageBuff");
            this.rangeBuff = nbt.getDouble("rangeBuff");
            this.spaBuff = nbt.getDouble("spaBuff");
            this.cavespider_spawned = nbt.getDouble("cavespider_spawned");
            this.stray_spawned = nbt.getDouble("stray_spawned");
            this.zombiepig_spawned = nbt.getDouble("zombiepig_spawned");
            this.piglin_spawned = nbt.getDouble("piglin_spawned");
            this.puffer_fish_spawned = nbt.getDouble("puffer_fish_spawned");
            this.maxLevel = nbt.getDouble("maxLevel");
            this.level = nbt.getDouble("level");
            this.upCost = nbt.getDouble("upCost");
            this.damage = nbt.getDouble("damage");
            this.range = nbt.getDouble("range");
            this.spa = nbt.getDouble("spa");
            this.unitName = nbt.getString("unitName");
            this.iron_golem_spawned = nbt.getDouble("iron_golem_spawned");
            this.trait = nbt.getString("trait");
            this.commonCandies = nbt.getDouble("commonCandies");
            this.rareCandies = nbt.getDouble("rareCandies");
            this.epicCandies = nbt.getDouble("epicCandies");
            this.xpToAdd = nbt.getDouble("xpToAdd");
            this.snowgolem_spawned = nbt.getDouble("snowgolem_spawned");
            this.husk_spawned = nbt.getDouble("husk_spawned");
            this.magmacube_spawned = nbt.getDouble("magmacube_spawned");
            this.polarbear_spawned = nbt.getDouble("polarbear_spawned");
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayerVariablesSyncMessage(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "craft_defense_mapvars";
        public double act = 1.0;
        public boolean bossKilled = false;
        public boolean debugMode = false;
        public double enemiesKilled = 0.0;
        public double enemiesToAdd = 1.0;
        public double enemyCount = 2.0;
        public boolean farmerVar = false;
        public boolean gameEnded = false;
        public boolean gameLost = false;
        public boolean gameStart = false;
        public boolean gameStarted = false;
        public boolean gameStarting = false;
        public boolean inGame = false;
        public String map = "\"\"";
        public double numberOfUnitMachines = 0.0;
        public double playersInGame = 0.0;
        public double playersInQueue = 0.0;
        public boolean playMusic = false;
        public double shield = 0.0;
        public double skipWave = 0.0;
        public double spawnedEnemies = 0.0;
        public boolean unitReward = false;
        public double voteStart = 0.0;
        public double wave = 0.0;
        public double waveBonus = 120.0;
        public boolean placeble = false;
        public boolean spawnEnemies = false;
        public double cooldownInf = 0.0;
        public double crystalChance = 0.0;
        public double commonDrops = 0.0;
        public double rareDrops = 0.0;
        public double candyChance = 0.0;
        public double candyAmount = 0.0;
        public double commonAmount = 0.0;
        public double rareAmount = 0.0;
        public boolean disableEnemiesSpawning = false;
        public boolean disableGUI = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            MapVariables data = new MapVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.act = nbt.getDouble("act");
            this.bossKilled = nbt.getBoolean("bossKilled");
            this.debugMode = nbt.getBoolean("debugMode");
            this.enemiesKilled = nbt.getDouble("enemiesKilled");
            this.enemiesToAdd = nbt.getDouble("enemiesToAdd");
            this.enemyCount = nbt.getDouble("enemyCount");
            this.farmerVar = nbt.getBoolean("farmerVar");
            this.gameEnded = nbt.getBoolean("gameEnded");
            this.gameLost = nbt.getBoolean("gameLost");
            this.gameStart = nbt.getBoolean("gameStart");
            this.gameStarted = nbt.getBoolean("gameStarted");
            this.gameStarting = nbt.getBoolean("gameStarting");
            this.inGame = nbt.getBoolean("inGame");
            this.map = nbt.getString("map");
            this.numberOfUnitMachines = nbt.getDouble("numberOfUnitMachines");
            this.playersInGame = nbt.getDouble("playersInGame");
            this.playersInQueue = nbt.getDouble("playersInQueue");
            this.playMusic = nbt.getBoolean("playMusic");
            this.shield = nbt.getDouble("shield");
            this.skipWave = nbt.getDouble("skipWave");
            this.spawnedEnemies = nbt.getDouble("spawnedEnemies");
            this.unitReward = nbt.getBoolean("unitReward");
            this.voteStart = nbt.getDouble("voteStart");
            this.wave = nbt.getDouble("wave");
            this.waveBonus = nbt.getDouble("waveBonus");
            this.placeble = nbt.getBoolean("placeble");
            this.spawnEnemies = nbt.getBoolean("spawnEnemies");
            this.cooldownInf = nbt.getDouble("cooldownInf");
            this.crystalChance = nbt.getDouble("crystalChance");
            this.commonDrops = nbt.getDouble("commonDrops");
            this.rareDrops = nbt.getDouble("rareDrops");
            this.candyChance = nbt.getDouble("candyChance");
            this.candyAmount = nbt.getDouble("candyAmount");
            this.commonAmount = nbt.getDouble("commonAmount");
            this.rareAmount = nbt.getDouble("rareAmount");
            this.disableEnemiesSpawning = nbt.getBoolean("disableEnemiesSpawning");
            this.disableGUI = nbt.getBoolean("disableGUI");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putDouble("act", this.act);
            nbt.putBoolean("bossKilled", this.bossKilled);
            nbt.putBoolean("debugMode", this.debugMode);
            nbt.putDouble("enemiesKilled", this.enemiesKilled);
            nbt.putDouble("enemiesToAdd", this.enemiesToAdd);
            nbt.putDouble("enemyCount", this.enemyCount);
            nbt.putBoolean("farmerVar", this.farmerVar);
            nbt.putBoolean("gameEnded", this.gameEnded);
            nbt.putBoolean("gameLost", this.gameLost);
            nbt.putBoolean("gameStart", this.gameStart);
            nbt.putBoolean("gameStarted", this.gameStarted);
            nbt.putBoolean("gameStarting", this.gameStarting);
            nbt.putBoolean("inGame", this.inGame);
            nbt.putString("map", this.map);
            nbt.putDouble("numberOfUnitMachines", this.numberOfUnitMachines);
            nbt.putDouble("playersInGame", this.playersInGame);
            nbt.putDouble("playersInQueue", this.playersInQueue);
            nbt.putBoolean("playMusic", this.playMusic);
            nbt.putDouble("shield", this.shield);
            nbt.putDouble("skipWave", this.skipWave);
            nbt.putDouble("spawnedEnemies", this.spawnedEnemies);
            nbt.putBoolean("unitReward", this.unitReward);
            nbt.putDouble("voteStart", this.voteStart);
            nbt.putDouble("wave", this.wave);
            nbt.putDouble("waveBonus", this.waveBonus);
            nbt.putBoolean("placeble", this.placeble);
            nbt.putBoolean("spawnEnemies", this.spawnEnemies);
            nbt.putDouble("cooldownInf", this.cooldownInf);
            nbt.putDouble("crystalChance", this.crystalChance);
            nbt.putDouble("commonDrops", this.commonDrops);
            nbt.putDouble("rareDrops", this.rareDrops);
            nbt.putDouble("candyChance", this.candyChance);
            nbt.putDouble("candyAmount", this.candyAmount);
            nbt.putDouble("commonAmount", this.commonAmount);
            nbt.putDouble("rareAmount", this.rareAmount);
            nbt.putBoolean("disableEnemiesSpawning", this.disableEnemiesSpawning);
            nbt.putBoolean("disableGUI", this.disableGUI);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof Level && !world.isClientSide()) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SavedDataSyncMessage(0, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(MapVariables::new, MapVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "craft_defense_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            WorldVariables data = new WorldVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)new SavedDataSyncMessage(1, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(new SavedData.Factory(WorldVariables::new, WorldVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
            PlayerVariables clone = new PlayerVariables();
            clone.alex_spawned = original.alex_spawned;
            clone.autoSkip = original.autoSkip;
            clone.autoSkip2 = original.autoSkip2;
            clone.creeper_spawned = original.creeper_spawned;
            clone.gameNotWon = original.gameNotWon;
            clone.gameWon = original.gameWon;
            clone.isInQueue = original.isInQueue;
            clone.isStarter = original.isStarter;
            clone.lastBeatenAct = original.lastBeatenAct;
            clone.lastRolledRarity = original.lastRolledRarity;
            clone.lastRolledUnit = original.lastRolledUnit;
            clone.lastUnitType = original.lastUnitType;
            clone.moneyIG = original.moneyIG;
            clone.oldDim = original.oldDim;
            clone.oldX = original.oldX;
            clone.oldY = original.oldY;
            clone.oldZ = original.oldZ;
            clone.playerInGame = original.playerInGame;
            clone.playerVoted = original.playerVoted;
            clone.playerVotedStart = original.playerVotedStart;
            clone.skeleton_spawned = original.skeleton_spawned;
            clone.skipWaveProcessing = original.skipWaveProcessing;
            clone.slime_spawned = original.slime_spawned;
            clone.spider_spawned = original.spider_spawned;
            clone.steve_spawned = original.steve_spawned;
            clone.unitLevel = original.unitLevel;
            clone.villager_spawned = original.villager_spawned;
            clone.witch_spawned = original.witch_spawned;
            clone.zombie_spawned = original.zombie_spawned;
            clone.lastRolledTrait = original.lastRolledTrait;
            clone.lastRolledTraitRarity = original.lastRolledTraitRarity;
            clone.damageBuff = original.damageBuff;
            clone.rangeBuff = original.rangeBuff;
            clone.spaBuff = original.spaBuff;
            clone.cavespider_spawned = original.cavespider_spawned;
            clone.stray_spawned = original.stray_spawned;
            clone.zombiepig_spawned = original.zombiepig_spawned;
            clone.piglin_spawned = original.piglin_spawned;
            clone.puffer_fish_spawned = original.puffer_fish_spawned;
            clone.maxLevel = original.maxLevel;
            clone.level = original.level;
            clone.upCost = original.upCost;
            clone.damage = original.damage;
            clone.range = original.range;
            clone.spa = original.spa;
            clone.unitName = original.unitName;
            clone.iron_golem_spawned = original.iron_golem_spawned;
            clone.trait = original.trait;
            clone.commonCandies = original.commonCandies;
            clone.rareCandies = original.rareCandies;
            clone.epicCandies = original.epicCandies;
            clone.xpToAdd = original.xpToAdd;
            clone.snowgolem_spawned = original.snowgolem_spawned;
            clone.husk_spawned = original.husk_spawned;
            clone.magmacube_spawned = original.magmacube_spawned;
            clone.polarbear_spawned = original.polarbear_spawned;
            if (!event.isWasDeath()) {
                // empty if block
            }
            event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().level());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (mapdata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(0, mapdata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }
}

