/*
 * Decompiled with CFR 0.152.
 */
package net.juujks.craft_defense.procedures;

import java.util.Comparator;
import java.util.List;
import net.juujks.craft_defense.entity.AlexEntity;
import net.juujks.craft_defense.entity.CaveSpiderUnitEntity;
import net.juujks.craft_defense.entity.CreeperUnitEntity;
import net.juujks.craft_defense.entity.HuskUnitEntity;
import net.juujks.craft_defense.entity.IronGolemUnitEntity;
import net.juujks.craft_defense.entity.MagmaCubeUnitEntity;
import net.juujks.craft_defense.entity.PiglinUnitEntity;
import net.juujks.craft_defense.entity.PufferfishUnitEntity;
import net.juujks.craft_defense.entity.SkeletonUnitEntity;
import net.juujks.craft_defense.entity.SlimeUnitEntity;
import net.juujks.craft_defense.entity.SnowGolemUnitEntity;
import net.juujks.craft_defense.entity.SpiderUnitEntity;
import net.juujks.craft_defense.entity.SteveEntity;
import net.juujks.craft_defense.entity.StrayUnitEntity;
import net.juujks.craft_defense.entity.WitchUnitEntity;
import net.juujks.craft_defense.entity.ZombieUnitEntity;
import net.juujks.craft_defense.entity.ZombifiedPiglinUnitEntity;
import net.juujks.craft_defense.procedures.CallCommonProcedure;
import net.juujks.craft_defense.procedures.CallEpicProcedure;
import net.juujks.craft_defense.procedures.CallLegendaryProcedure;
import net.juujks.craft_defense.procedures.CallRareProcedure;
import net.juujks.craft_defense.procedures.CreeperExplosionProcedure;
import net.juujks.craft_defense.procedures.DamageClientProcedure;
import net.juujks.craft_defense.procedures.DmgP2Procedure;
import net.juujks.craft_defense.procedures.ShowEntityTestProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class OnTickUpdate2Procedure {
    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        LivingEntity _livingEntity2;
        if (entity == null) {
            return;
        }
        Entity nearestEnemy = null;
        String priority = "";
        double powerfulChance = 0.0;
        double nearestDistSq = 0.0;
        double dx = 0.0;
        double dz = 0.0;
        double distSq = 0.0;
        double yaw = 0.0;
        double bestScore = 0.0;
        double score = 0.0;
        boolean found = false;
        boolean attackedThisTick = false;
        entity.getPersistentData().putBoolean("unit", true);
        if (!(entity instanceof SlimeUnitEntity) && entity instanceof LivingEntity && (_livingEntity2 = (LivingEntity)entity).getAttributes().hasAttribute(Attributes.SCALE)) {
            _livingEntity2.getAttribute(Attributes.SCALE).setBaseValue(0.5);
        }
        ShowEntityTestProcedure.execute(world, x, y, z, entity);
        DmgP2Procedure.execute(world, x, y, z, entity);
        CallCommonProcedure.execute(entity);
        CallRareProcedure.execute(entity);
        CallEpicProcedure.execute(entity);
        CallLegendaryProcedure.execute(entity);
        DamageClientProcedure.execute(entity);
        bestScore = -1.0E9;
        nearestDistSq = entity.getPersistentData().getDouble("range") * (entity.getPersistentData().getDouble("range") + 1.0);
        priority = entity.getPersistentData().getString("priority");
        entity.getPersistentData().putString("priorityText", priority);
        if (priority.equals("")) {
            priority = "nearest";
        }
        entity.getPersistentData().putDouble("cooldown", entity.getPersistentData().getDouble("cooldown") + 1.0);
        Vec3 _center = new Vec3(entity.getX(), entity.getY(), entity.getZ());
        List<Entity> _entfound = world.getEntitiesOfClass(Entity.class, new AABB(_center, _center).inflate(entity.getPersistentData().getDouble("range") / 2.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_center))).toList();
        for (Entity entityiterator : _entfound) {
            if (!entityiterator.getPersistentData().getBoolean("attackable")) continue;
            dx = entityiterator.getX() - entity.getX();
            dz = entityiterator.getZ() - entity.getZ();
            distSq = dx * dx + dz * dz;
            if (priority.equals("nearest")) {
                score = 0.0 - distSq;
            } else if (priority.equals("furthest")) {
                score = distSq;
            } else if (priority.equals("strongest")) {
                score = entityiterator.getPersistentData().getDouble("powerful");
                if (score == 0.0) {
                    double d;
                    if (entityiterator instanceof LivingEntity) {
                        _livEnt = (LivingEntity)entityiterator;
                        d = _livEnt.getMaxHealth();
                    } else {
                        d = -1.0;
                    }
                    score = d;
                }
            } else if (priority.equals("weakest")) {
                score = entityiterator.getPersistentData().getDouble("powerful");
                if (score == 0.0) {
                    double d;
                    if (entityiterator instanceof LivingEntity) {
                        _livEnt = (LivingEntity)entityiterator;
                        d = _livEnt.getHealth();
                    } else {
                        d = -1.0;
                    }
                    score = d;
                }
                score = 0.0 - score;
            } else {
                score = priority.equals("aerial") ? (entityiterator.getPersistentData().getBoolean("aerial") ? 0.0 - distSq : -1.0E9) : (priority.equals("first") ? entityiterator.getPersistentData().getDouble("pathProgress") : (priority.equals("last") ? 0.0 - entityiterator.getPersistentData().getDouble("pathProgress") : 0.0 - distSq));
            }
            if (!(score > bestScore)) continue;
            bestScore = score;
            nearestDistSq = distSq;
            nearestEnemy = entityiterator;
            found = true;
        }
        CreeperExplosionProcedure.execute(world, x, y, z, entity);
        if (entity.getPersistentData().getDouble("cooldown") >= 20.0 * entity.getPersistentData().getDouble("spa") && found) {
            Level _level;
            entity.getPersistentData().putDouble("cooldown", 0.0);
            if (entity instanceof SteveEntity) {
                ((SteveEntity)entity).setAnimation("steve.attack");
            }
            if (entity instanceof AlexEntity) {
                ((AlexEntity)entity).setAnimation("attack");
            }
            if (entity instanceof ZombieUnitEntity) {
                ((ZombieUnitEntity)entity).setAnimation("zombie.attack");
            }
            if (entity instanceof CreeperUnitEntity) {
                CreeperUnitEntity animatable = (CreeperUnitEntity)entity;
                animatable.setTexture("creeper");
            }
            if (entity instanceof ZombifiedPiglinUnitEntity) {
                ((ZombifiedPiglinUnitEntity)entity).setAnimation("attack");
            }
            if (entity instanceof PiglinUnitEntity) {
                ((PiglinUnitEntity)entity).setAnimation("attack");
            }
            if (entity instanceof PufferfishUnitEntity) {
                ((PufferfishUnitEntity)entity).setAnimation("attack");
            }
            if (entity instanceof IronGolemUnitEntity) {
                ((IronGolemUnitEntity)entity).setAnimation("attack");
            }
            if (entity instanceof HuskUnitEntity) {
                ((HuskUnitEntity)entity).setAnimation("attack");
            }
            if (entity instanceof SteveEntity || entity instanceof CaveSpiderUnitEntity || entity instanceof ZombifiedPiglinUnitEntity || entity instanceof PiglinUnitEntity || entity instanceof IronGolemUnitEntity || entity instanceof HuskUnitEntity || entity instanceof SpiderUnitEntity) {
                if (world instanceof Level) {
                    _level = (Level)world;
                    if (!_level.isClientSide()) {
                        _level.playSound(null, BlockPos.containing((double)entity.getX(), (double)entity.getY(), (double)entity.getZ()), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.player.attack.sweep")), SoundSource.NEUTRAL, 1.0f, 1.0f);
                    } else {
                        _level.playLocalSound(entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.player.attack.sweep")), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
                    }
                }
                world.addParticle((ParticleOptions)ParticleTypes.SWEEP_ATTACK, nearestEnemy.getX(), nearestEnemy.getY() + 1.0, nearestEnemy.getZ(), 0.0, 1.0, 0.0);
            }
            if (entity instanceof WitchUnitEntity) {
                if (world instanceof Level) {
                    _level = (Level)world;
                    if (!_level.isClientSide()) {
                        _level.playSound(null, BlockPos.containing((double)entity.getX(), (double)entity.getY(), (double)entity.getZ()), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.experience_bottle.throw")), SoundSource.NEUTRAL, 1.0f, 1.0f);
                    } else {
                        _level.playLocalSound(entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.experience_bottle.throw")), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
                    }
                }
                if (world instanceof ServerLevel) {
                    _level = (ServerLevel)world;
                    _level.sendParticles((ParticleOptions)ParticleTypes.ENCHANTED_HIT, nearestEnemy.getX(), nearestEnemy.getY() + 1.0, nearestEnemy.getZ(), 20, 0.0, 0.0, 0.0, 0.2);
                }
            }
            if (entity instanceof PufferfishUnitEntity && world instanceof Level) {
                _level = (Level)world;
                if (!_level.isClientSide()) {
                    _level.playSound(null, BlockPos.containing((double)entity.getX(), (double)entity.getY(), (double)entity.getZ()), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.puffer_fish.blow_up")), SoundSource.NEUTRAL, 1.0f, 1.0f);
                } else {
                    _level.playLocalSound(entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.puffer_fish.blow_up")), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
                }
            }
            if (entity instanceof CreeperUnitEntity) {
                if (world instanceof Level) {
                    _level = (Level)world;
                    if (!_level.isClientSide()) {
                        _level.playSound(null, BlockPos.containing((double)entity.getX(), (double)entity.getY(), (double)entity.getZ()), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.explode")), SoundSource.NEUTRAL, 1.0f, 1.0f);
                    } else {
                        _level.playLocalSound(entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.explode")), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
                    }
                }
                if (world instanceof ServerLevel) {
                    _level = (ServerLevel)world;
                    _level.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, x, y, z, 5, 6.0, 1.0, 6.0, 1.0);
                }
            }
            if (entity instanceof SlimeUnitEntity || entity instanceof MagmaCubeUnitEntity) {
                if (world instanceof Level) {
                    _level = (Level)world;
                    if (!_level.isClientSide()) {
                        _level.playSound(null, BlockPos.containing((double)entity.getX(), (double)entity.getY(), (double)entity.getZ()), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.slime.jump")), SoundSource.NEUTRAL, 1.0f, 1.0f);
                    } else {
                        _level.playLocalSound(entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.slime.jump")), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
                    }
                }
                if (world instanceof ServerLevel) {
                    _level = (ServerLevel)world;
                    _level.sendParticles((ParticleOptions)ParticleTypes.ITEM_SLIME, nearestEnemy.getX(), nearestEnemy.getY() + 1.0, nearestEnemy.getZ(), 20, 0.0, 0.0, 0.0, 1.0);
                }
            }
            if (entity instanceof AlexEntity || entity instanceof StrayUnitEntity || entity instanceof SnowGolemUnitEntity || entity instanceof SkeletonUnitEntity) {
                if (world instanceof Level) {
                    _level = (Level)world;
                    if (!_level.isClientSide()) {
                        _level.playSound(null, BlockPos.containing((double)entity.getX(), (double)entity.getY(), (double)entity.getZ()), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.arrow.shoot")), SoundSource.NEUTRAL, 1.0f, 1.0f);
                    } else {
                        _level.playLocalSound(entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.arrow.shoot")), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
                    }
                }
                if (world instanceof ServerLevel) {
                    _level = (ServerLevel)world;
                    _level.sendParticles((ParticleOptions)ParticleTypes.CRIT, nearestEnemy.getX(), nearestEnemy.getY(), nearestEnemy.getZ(), 10, 0.0, 0.0, 0.0, 0.2);
                }
            }
            yaw = Math.atan2(dz, dx) * 57.29577951308232 - 90.0;
            Entity _ent = entity;
            _ent.setYRot((float)yaw);
            _ent.setXRot(0.0f);
            _ent.setYBodyRot(_ent.getYRot());
            _ent.setYHeadRot(_ent.getYRot());
            _ent.yRotO = _ent.getYRot();
            _ent.xRotO = _ent.getXRot();
            if (_ent instanceof LivingEntity) {
                LivingEntity _entity = (LivingEntity)_ent;
                _entity.yBodyRotO = _entity.getYRot();
                _entity.yHeadRotO = _entity.getYRot();
            }
            if (entity instanceof CreeperUnitEntity || entity instanceof PufferfishUnitEntity) {
                _center = new Vec3(entity.getX(), entity.getY(), entity.getZ());
                _entfound = world.getEntitiesOfClass(Entity.class, new AABB(_center, _center).inflate(entity.getPersistentData().getDouble("range") / 2.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_center))).toList();
                for (Entity entityiterator : _entfound) {
                    LivingEntity _entity;
                    if (!(entityiterator.getPersistentData().getDouble("powerful") <= entity.getPersistentData().getDouble("level")) || !entityiterator.getPersistentData().getBoolean("attackable")) continue;
                    entityiterator.hurt(new DamageSource(world.holderOrThrow(DamageTypes.GENERIC)), (float)entity.getPersistentData().getDouble("damage"));
                    if (!(entity instanceof PufferfishUnitEntity)) continue;
                    entityiterator.getPersistentData().putBoolean("poison", true);
                    if (!(entityiterator instanceof LivingEntity) || (_entity = (LivingEntity)entityiterator).level().isClientSide()) continue;
                    _entity.addEffect(new MobEffectInstance(MobEffects.POISON, 100, 64, true, true));
                }
            } else if (nearestEnemy.getPersistentData().getDouble("powerful") <= entity.getPersistentData().getDouble("level") && !nearestEnemy.getPersistentData().getBoolean("aerial")) {
                LivingEntity _entity;
                nearestEnemy.hurt(new DamageSource(world.holderOrThrow(DamageTypes.GENERIC)), (float)entity.getPersistentData().getDouble("damage"));
                if (entity instanceof WitchUnitEntity) {
                    if (nearestEnemy instanceof LivingEntity && !(_entity = (LivingEntity)nearestEnemy).level().isClientSide()) {
                        _entity.addEffect(new MobEffectInstance(MobEffects.POISON, 100, 32, true, true));
                    }
                    nearestEnemy.getPersistentData().putBoolean("poison", true);
                }
                if (entity instanceof CaveSpiderUnitEntity) {
                    if (nearestEnemy instanceof LivingEntity && !(_entity = (LivingEntity)nearestEnemy).level().isClientSide()) {
                        _entity.addEffect(new MobEffectInstance(MobEffects.POISON, 100, 64, true, true));
                    }
                    nearestEnemy.getPersistentData().putBoolean("poison", true);
                }
                if (entity instanceof StrayUnitEntity || entity instanceof SnowGolemUnitEntity || entity instanceof SlimeUnitEntity) {
                    nearestEnemy.getPersistentData().putBoolean("slow", true);
                }
            } else if (nearestEnemy.getPersistentData().getBoolean("aerial") && (entity instanceof AlexEntity || entity instanceof StrayUnitEntity || entity instanceof SnowGolemUnitEntity || entity instanceof SkeletonUnitEntity)) {
                nearestEnemy.hurt(new DamageSource(world.holderOrThrow(DamageTypes.GENERIC)), (float)entity.getPersistentData().getDouble("damage"));
            }
        }
    }
}

