/*
 * Decompiled with CFR 0.152.
 */
package net.juujks.craft_defense.procedures;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@EventBusSubscriber
public class VersionCheckProcedure {
    private static final String CURRENT_VERSION = "3.0";
    private static final String VERSION_URL = "https://raw.githubusercontent.com/juniperjjhdbr/craft_defense_version_check/refs/heads/main/.github/workflows/version_check.txt";

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        CompletableFuture.runAsync(() -> {
            String latest = VersionCheckProcedure.fetchLatestVersion();
            if (latest == null) {
                return;
            }
            if (!CURRENT_VERSION.equalsIgnoreCase(latest.trim())) {
                MutableComponent warning = Component.literal((String)("\u00a7c[Warning] You are using an outdated version of Craft Defense (3.0). Latest version: " + latest + ".\n\u00a77Download the latest version: "));
                MutableComponent curseforgeLink = Component.literal((String)"[CurseForge]").setStyle(Style.EMPTY.withColor(ChatFormatting.BLUE).withUnderlined(Boolean.valueOf(true)).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/craft-defense")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Open CurseForge page"))));
                MutableComponent modrinthLink = Component.literal((String)"[Modrinth]").setStyle(Style.EMPTY.withColor(ChatFormatting.GREEN).withUnderlined(Boolean.valueOf(true)).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://modrinth.com/mod/craft-defense")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Open Modrinth page"))));
                warning.append((Component)curseforgeLink).append(" ").append((Component)modrinthLink);
                player2.sendSystemMessage((Component)warning);
            }
        });
    }

    private static String fetchLatestVersion() {
        try {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(VERSION_URL)).GET().build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == 200) {
                return response.body().trim();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

