/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LCTags;
import io.github.lightman314.lightmanscurrency.api.config.ConfigAPI;
import io.github.lightman314.lightmanscurrency.api.config.ConfigFile;
import io.github.lightman314.lightmanscurrency.api.config.ConfigReloadable;
import io.github.lightman314.lightmanscurrency.api.misc.BlockProtectionHelper;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IOwnableBlock;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.money.MoneyAPI;
import io.github.lightman314.lightmanscurrency.api.money.bank.BankAPI;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.builtin.PlayerBankReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.builtin.TeamBankReference;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.api.money.types.builtin.CoinCurrencyType;
import io.github.lightman314.lightmanscurrency.api.money.types.builtin.NullCurrencyType;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationAPI;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.ownership.Owner;
import io.github.lightman314.lightmanscurrency.api.ownership.OwnershipAPI;
import io.github.lightman314.lightmanscurrency.api.ownership.builtin.FakeOwner;
import io.github.lightman314.lightmanscurrency.api.ownership.builtin.PlayerOwner;
import io.github.lightman314.lightmanscurrency.api.ownership.builtin.TeamOwner;
import io.github.lightman314.lightmanscurrency.api.ownership.listing.builtin.PlayerOwnerProvider;
import io.github.lightman314.lightmanscurrency.api.ownership.listing.builtin.TeamOwnerProvider;
import io.github.lightman314.lightmanscurrency.api.settings.pretty.PrettyTextWriter;
import io.github.lightman314.lightmanscurrency.api.settings.pretty.builtin.BookTextWriter;
import io.github.lightman314.lightmanscurrency.api.stats.StatType;
import io.github.lightman314.lightmanscurrency.api.stats.types.IntegerStat;
import io.github.lightman314.lightmanscurrency.api.stats.types.MultiMoneyStat;
import io.github.lightman314.lightmanscurrency.api.taxes.TaxAPI;
import io.github.lightman314.lightmanscurrency.api.taxes.notifications.TaxesCollectedNotification;
import io.github.lightman314.lightmanscurrency.api.taxes.notifications.TaxesPaidNotification;
import io.github.lightman314.lightmanscurrency.api.taxes.reference.builtin.TaxableTraderReference;
import io.github.lightman314.lightmanscurrency.api.ticket.TicketGroupData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.api.traders.terminal.sorting.types.SortByID;
import io.github.lightman314.lightmanscurrency.api.traders.terminal.sorting.types.SortByName;
import io.github.lightman314.lightmanscurrency.api.traders.terminal.sorting.types.SortByOffers;
import io.github.lightman314.lightmanscurrency.api.traders.terminal.sorting.types.SortByPopularity;
import io.github.lightman314.lightmanscurrency.api.traders.terminal.sorting.types.SortByRecent;
import io.github.lightman314.lightmanscurrency.api.variants.VariantProvider;
import io.github.lightman314.lightmanscurrency.common.blocks.CoinBlock;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.core.ModRegistries;
import io.github.lightman314.lightmanscurrency.common.data.types.TraderDataCache;
import io.github.lightman314.lightmanscurrency.common.gamerule.ModGameRules;
import io.github.lightman314.lightmanscurrency.common.loot.LootManager;
import io.github.lightman314.lightmanscurrency.common.menus.validation.MenuValidatorType;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.BlockEntityValidator;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.BlockValidator;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.EntityValidator;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.ItemValidator;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.SimpleValidator;
import io.github.lightman314.lightmanscurrency.common.money.ancient_money.AncientCoinSorter;
import io.github.lightman314.lightmanscurrency.common.money.ancient_money.AncientMoneyType;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.AuctionHouseCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.BankCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.EventCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.NullCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.TaxEntryCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.TraderCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.types.TextNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseBidNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseBuyerNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseCancelNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseSellerNobidNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseSellerNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.bank.BankInterestNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.bank.BankTransferNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.bank.DepositWithdrawNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.bank.LowBalanceNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.bank.SalaryPaymentNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.ejection.OwnableBlockEjectedNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.AddRemoveAllyNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.AddRemoveTradeNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.ChangeAllyPermissionNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.ChangeCreativeNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.ChangeNameNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.ChangeOwnerNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.ChangeSettingNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.CommandTradeNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.GachaTradeNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.ItemTradeNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.OutOfStockNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.PaygateNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.SlotMachineTradeNotification;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.common.seasonal_events.SeasonalEventManager;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.common.traders.commands.CommandTrader;
import io.github.lightman314.lightmanscurrency.common.traders.gacha.GachaTrader;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderDataArmor;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderDataBook;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderDataTicket;
import io.github.lightman314.lightmanscurrency.common.traders.item.ticket.TicketItemTrade;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.restrictions.ItemTradeRestriction;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.PaygateTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.DailyTrades;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.DemandPricing;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.DiscountCodes;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.FreeSample;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.PlayerDiscounts;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.PlayerListing;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.PlayerTradeLimit;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.PriceFluctuation;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.TimedSale;
import io.github.lightman314.lightmanscurrency.common.traders.rules.types.TradeLimit;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.terminal.filters.AuctionSearchFilter;
import io.github.lightman314.lightmanscurrency.common.traders.terminal.filters.BasicSearchFilter;
import io.github.lightman314.lightmanscurrency.common.traders.terminal.filters.DescriptionSearchFilter;
import io.github.lightman314.lightmanscurrency.common.traders.terminal.filters.ItemTraderSearchFilter;
import io.github.lightman314.lightmanscurrency.common.traders.terminal.filters.SlotMachineSearchFilter;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.ItemListingSerializer;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.VillagerTradeManager;
import io.github.lightman314.lightmanscurrency.integration.IntegrationUtil;
import io.github.lightman314.lightmanscurrency.integration.biomesoplenty.BOPCustomWoodTypes;
import io.github.lightman314.lightmanscurrency.integration.claiming.flan.LCFlanIntegration;
import io.github.lightman314.lightmanscurrency.integration.claiming.ftbchunks.LCFTBChunksIntegration;
import io.github.lightman314.lightmanscurrency.integration.computercraft.LCComputercraftSetup;
import io.github.lightman314.lightmanscurrency.integration.create.LCCreate;
import io.github.lightman314.lightmanscurrency.integration.curios.LCCurios;
import io.github.lightman314.lightmanscurrency.integration.ftb_filter.LCFTBFilterSystemLauncher;
import io.github.lightman314.lightmanscurrency.integration.ftbteams.LCFTBTeams;
import io.github.lightman314.lightmanscurrency.integration.immersiveengineering.LCImmersive;
import io.github.lightman314.lightmanscurrency.integration.impactor.LCImpactorCompat;
import io.github.lightman314.lightmanscurrency.network.message.data.SPacketSyncCoinData;
import io.github.lightman314.lightmanscurrency.network.message.time.SPacketSyncTime;
import io.github.lightman314.lightmanscurrency.proxy.ClientProxy;
import io.github.lightman314.lightmanscurrency.proxy.CommonProxy;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.network.ConfigurationTask;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.ParallelDispatchEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.configuration.ICustomConfigurationTask;
import net.neoforged.neoforge.network.event.RegisterConfigurationTasksEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="lightmanscurrency")
@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class LightmansCurrency {
    public static final String MODID = "lightmanscurrency";
    private static CommonProxy PROXY;
    private static final Logger LOGGER;

    public static CommonProxy getProxy() {
        return Objects.requireNonNull(PROXY, "Attempted to get the proxy before the mod was initialized!");
    }

    public LightmansCurrency(ModContainer modContainer, IEventBus eventBus, Dist side) {
        PROXY = side.isClient() ? new ClientProxy() : new CommonProxy();
        LootManager.registerDroplistListeners();
        eventBus.addListener(this::commonSetup);
        eventBus.addListener(this::clientSetup);
        LCConfig.init();
        LootManager.init();
        NeoForge.EVENT_BUS.register((Object)this);
        IntegrationUtil.SafeRunIfLoaded("biomesoplenty", BOPCustomWoodTypes::setupWoodTypes, "Error setting up BOP wood types! BOP has probably changed their API!");
        ModRegistries.register(eventBus);
        LightmansCurrency.getProxy().init(eventBus, modContainer);
        IntegrationUtil.SafeRunIfLoaded("ftbchunks", LCFTBChunksIntegration::setup, "Error setting up FTB Chunks chunk purchasing integration!");
        IntegrationUtil.SafeRunIfLoaded("flan", LCFlanIntegration::setup, "Error setting up Flans chunk purchasing integration!");
        IntegrationUtil.SafeRunIfLoaded("immersiveengineering", LCImmersive::registerRotationBlacklists, null);
        IntegrationUtil.SafeRunIfLoaded("curios", () -> LCCurios.setup(eventBus), "Error setting up Curios Compatibility!");
        IntegrationUtil.SafeRunIfLoaded("create", () -> LCCreate.init(eventBus), "Error setting up Create Integration!");
        IntegrationUtil.SafeRunIfLoaded("computercraft", () -> LCComputercraftSetup.setup(eventBus), "Error setting up ComputerCraft Integration!");
        IntegrationUtil.SafeRunIfLoaded("ftbfiltersystem", LCFTBFilterSystemLauncher::launch, "Error setting up FTB Filter System Integration!");
        VariantProvider.registerBasicVariantItem(ModItems.TRADING_CORE, ModItems.VARIANT_WAND, ModItems.ITEM_TRADE_FILTER);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LightmansCurrency.safeEnqueueWork(event, "Error during common setup!", this::commonSetupWork);
    }

    private void commonSetupWork(FMLCommonSetupEvent event) {
        ConfigFile.loadServerFiles(ConfigFile.LoadPhase.SETUP);
        IntegrationUtil.SafeRunIfLoaded("impactor", LCImpactorCompat::setup, "Error setting up Impactor Economy Compatibility");
        CoinAPI.getApi().Setup();
        MoneyAPI.getApi().RegisterCurrencyType(CoinCurrencyType.INSTANCE);
        MoneyAPI.getApi().RegisterCurrencyType(NullCurrencyType.INSTANCE);
        MoneyAPI.getApi().RegisterCurrencyType(AncientMoneyType.INSTANCE);
        CoinAPI.getApi().RegisterCustomSorter(AncientCoinSorter.INSTANCE);
        OwnershipAPI.getApi().registerOwnerType(Owner.NULL_TYPE);
        OwnershipAPI.getApi().registerOwnerType(FakeOwner.TYPE);
        OwnershipAPI.getApi().registerOwnerType(PlayerOwner.TYPE);
        OwnershipAPI.getApi().registerOwnerType(TeamOwner.TYPE);
        OwnershipAPI.getApi().registerPotentialOwnerProvider(PlayerOwnerProvider.INSTANCE);
        OwnershipAPI.getApi().registerPotentialOwnerProvider(TeamOwnerProvider.INSTANCE);
        TraderAPI.getApi().RegisterTrader(ItemTraderData.TYPE);
        TraderAPI.getApi().RegisterTrader(ItemTraderDataArmor.TYPE);
        TraderAPI.getApi().RegisterTrader(ItemTraderDataTicket.TYPE);
        TraderAPI.getApi().RegisterTrader(ItemTraderDataBook.TYPE);
        TraderAPI.getApi().RegisterTrader(SlotMachineTraderData.TYPE);
        TraderAPI.getApi().RegisterTrader(PaygateTraderData.TYPE);
        TraderAPI.getApi().RegisterTrader(AuctionHouseTrader.TYPE);
        TraderAPI.getApi().RegisterTrader(CommandTrader.TYPE);
        TraderAPI.getApi().RegisterTrader(GachaTrader.TYPE);
        ModGameRules.registerRules();
        TraderAPI.getApi().RegisterTradeRule(PlayerListing.TYPE);
        TraderAPI.getApi().RegisterTradeRule(PlayerTradeLimit.TYPE);
        TraderAPI.getApi().RegisterTradeRule(PlayerDiscounts.TYPE);
        TraderAPI.getApi().RegisterTradeRule(TimedSale.TYPE);
        TraderAPI.getApi().RegisterTradeRule(TradeLimit.TYPE);
        TraderAPI.getApi().RegisterTradeRule(FreeSample.TYPE);
        TraderAPI.getApi().RegisterTradeRule(PriceFluctuation.TYPE);
        TraderAPI.getApi().RegisterTradeRule(DemandPricing.TYPE);
        TraderAPI.getApi().RegisterTradeRule(DailyTrades.TYPE);
        TraderAPI.getApi().RegisterTradeRule(DiscountCodes.TYPE);
        TradeRule.addLoadListener(PlayerListing.LISTENER);
        TradeRule.addIgnoreMissing("lightmanscurrency:whitelist");
        TradeRule.addIgnoreMissing("lightmanscurrency:blacklist");
        NotificationAPI.getApi().RegisterNotification(ItemTradeNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(PaygateNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(SlotMachineTradeNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(OutOfStockNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(LowBalanceNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(AuctionHouseSellerNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(AuctionHouseBuyerNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(AuctionHouseSellerNobidNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(AuctionHouseBidNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(AuctionHouseCancelNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(TextNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(AddRemoveAllyNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(AddRemoveTradeNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(ChangeAllyPermissionNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(ChangeCreativeNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(ChangeNameNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(ChangeOwnerNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(ChangeSettingNotification.SIMPLE_TYPE);
        NotificationAPI.getApi().RegisterNotification(ChangeSettingNotification.ADVANCED_TYPE);
        NotificationAPI.getApi().RegisterNotification(ChangeSettingNotification.DUMB_TYPE);
        NotificationAPI.getApi().RegisterNotification(DepositWithdrawNotification.PLAYER_TYPE);
        NotificationAPI.getApi().RegisterNotification(DepositWithdrawNotification.CUSTOM_TYPE);
        NotificationAPI.getApi().RegisterNotification(DepositWithdrawNotification.SERVER_TYPE);
        NotificationAPI.getApi().RegisterNotification(BankTransferNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(BankInterestNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(TaxesCollectedNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(TaxesPaidNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(OwnableBlockEjectedNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(CommandTradeNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(GachaTradeNotification.TYPE);
        NotificationAPI.getApi().RegisterNotification(SalaryPaymentNotification.TYPE);
        NotificationAPI.getApi().RegisterCategory(NotificationCategory.GENERAL_TYPE);
        NotificationAPI.getApi().RegisterCategory(NullCategory.TYPE);
        NotificationAPI.getApi().RegisterCategory(EventCategory.TYPE);
        NotificationAPI.getApi().RegisterCategory(TraderCategory.TYPE);
        NotificationAPI.getApi().RegisterCategory(BankCategory.TYPE);
        NotificationAPI.getApi().RegisterCategory(AuctionHouseCategory.TYPE);
        NotificationAPI.getApi().RegisterCategory(TaxEntryCategory.TYPE);
        TraderAPI.getApi().RegisterTraderSearchFilter(new BasicSearchFilter());
        TraderAPI.getApi().RegisterSearchFilter(new ItemTraderSearchFilter());
        TraderAPI.getApi().RegisterSearchFilter(new SlotMachineSearchFilter());
        TraderAPI.getApi().RegisterSearchFilter(new AuctionSearchFilter());
        TraderAPI.getApi().RegisterSearchFilter(new DescriptionSearchFilter());
        TraderAPI.getApi().RegisterSortType(SortByName.INSTANCE);
        TraderAPI.getApi().RegisterSortType(SortByID.INSTANCE);
        TraderAPI.getApi().RegisterSortType(SortByOffers.INSTANCE);
        TraderAPI.getApi().RegisterSortType(SortByPopularity.INSTANCE);
        TraderAPI.getApi().RegisterSortType(SortByRecent.INSTANCE);
        TaxAPI.getApi().RegisterReferenceType(TaxableTraderReference.TYPE);
        BankAPI.getApi().RegisterReferenceType(PlayerBankReference.TYPE);
        BankAPI.getApi().RegisterReferenceType(TeamBankReference.TYPE);
        MenuValidatorType.register(SimpleValidator.TYPE);
        MenuValidatorType.register(BlockEntityValidator.TYPE);
        MenuValidatorType.register(BlockValidator.TYPE);
        MenuValidatorType.register(EntityValidator.TYPE);
        MenuValidatorType.register(ItemValidator.TYPE);
        ItemTradeRestriction.init();
        TicketGroupData.create((ItemLike)ModItems.TICKET_MASTER.get(), (ItemLike)ModItems.TICKET.get(), (ItemLike)ModItems.TICKET_STUB.get(), LCTags.Items.TICKET_MATERIAL_PAPER);
        TicketGroupData.create((ItemLike)ModItems.GOLDEN_TICKET_MASTER.get(), (ItemLike)ModItems.GOLDEN_TICKET.get(), (ItemLike)ModItems.GOLDEN_TICKET_STUB.get(), LCTags.Items.TICKET_MATERIAL_GOLD);
        ItemListingSerializer.registerDefaultSerializers();
        VillagerTradeManager.registerDefaultTrades();
        IconData.registerDefaultIcons();
        StatType.register(IntegerStat.INSTANCE);
        StatType.register(MultiMoneyStat.INSTANCE);
        BlockProtectionHelper.ProtectBlock(b -> b instanceof IOwnableBlock);
        BlockProtectionHelper.ProtectBlock(b -> b instanceof CoinBlock);
        PrettyTextWriter.register(BookTextWriter.INSTANCE);
        ItemTradeData.registerCustomItemTrade(TicketItemTrade.TYPE, TicketItemTrade::new);
        ConfigAPI.getApi().registerCustomReloadable(ConfigReloadable.simpleReloader(VersionUtil.lcResource("master_coin_list"), 100, stack -> CoinAPI.getApi().ReloadCoinDataFromFile()));
        ConfigAPI.getApi().registerCustomReloadable(ConfigReloadable.simpleReloader(VersionUtil.lcResource("persistent_traders"), 1000, stack -> TraderDataCache.TYPE.get(false).reloadPersistentTraders()));
        ConfigAPI.getApi().registerCustomReloadable(ConfigReloadable.simpleReloader(VersionUtil.lcResource("seasonal_events"), stack -> SeasonalEventManager.reload()));
        IntegrationUtil.SafeRunIfLoaded("ftbteams", LCFTBTeams::setup, "Error setting up FTB Teams compat!");
    }

    private void clientSetup(FMLClientSetupEvent event) {
        LightmansCurrency.safeEnqueueWork((ParallelDispatchEvent)event, "Error during client setup!", LightmansCurrency.getProxy()::setupClient);
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player target = event.getEntity();
        SPacketSyncTime.syncWith(target);
        LCAdminMode.sendSyncPacket(target);
    }

    public static void LogDebug(String message) {
        LOGGER.debug(message);
    }

    public static void LogDebug(String message, Object ... objects) {
        LOGGER.debug(message, objects);
    }

    public static void LogInfo(String message) {
        if ((Integer)LCConfig.COMMON.debugLevel.get() > 0) {
            LOGGER.debug("INFO: " + message);
        } else {
            LOGGER.info(message);
        }
    }

    public static void LogInfo(String message, Object ... objects) {
        if ((Integer)LCConfig.COMMON.debugLevel.get() > 0) {
            LOGGER.debug("INFO: " + message, objects);
        } else {
            LOGGER.info(message, objects);
        }
    }

    public static void LogWarning(String message) {
        if ((Integer)LCConfig.COMMON.debugLevel.get() > 1) {
            LOGGER.debug("WARN: " + message);
        } else {
            LOGGER.warn(message);
        }
    }

    public static void LogWarning(String message, Object ... objects) {
        if ((Integer)LCConfig.COMMON.debugLevel.get() > 1) {
            LOGGER.debug("WARN: " + message, objects);
        } else {
            LOGGER.warn(message, objects);
        }
    }

    public static void LogError(String message) {
        if ((Integer)LCConfig.COMMON.debugLevel.get() > 2) {
            LOGGER.debug("ERROR: " + message);
        } else {
            LOGGER.error(message);
        }
    }

    public static void LogError(String message, Object ... objects) {
        if ((Integer)LCConfig.COMMON.debugLevel.get() > 2) {
            LOGGER.debug("ERROR: " + message, objects);
        } else {
            LOGGER.error(message, objects);
        }
    }

    public static void safeEnqueueWork(ParallelDispatchEvent event, String errorMessage, Runnable work) {
        event.enqueueWork(() -> {
            try {
                work.run();
            }
            catch (Throwable t) {
                LightmansCurrency.LogError(errorMessage, t);
            }
        });
    }

    public static <T extends ParallelDispatchEvent> void safeEnqueueWork(T event, String errorMessage, Consumer<T> work) {
        event.enqueueWork(() -> {
            try {
                work.accept(event);
            }
            catch (Throwable t) {
                LightmansCurrency.LogError(errorMessage, t);
            }
        });
    }

    private void setupConfigTasks(RegisterConfigurationTasksEvent event) {
        event.register((ConfigurationTask)new SyncCoinDataTask());
    }

    static {
        LOGGER = LogManager.getLogger();
    }

    private static class SyncCoinDataTask
    implements ICustomConfigurationTask {
        private SyncCoinDataTask() {
        }

        public ConfigurationTask.Type type() {
            return SPacketSyncCoinData.CONFIG_TYPE;
        }

        public void run(Consumer<CustomPacketPayload> sender) {
            sender.accept(CoinAPI.getApi().getSyncPacket().configTask());
        }
    }
}

