/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.variants.VariantProvider;
import io.github.lightman314.lightmanscurrency.api.variants.item.IVariantItem;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.ModelVariantDataManager;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.data.ModelVariant;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.properties.VariantProperties;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.core.ModDataComponents;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.core.ModRegistries;
import io.github.lightman314.lightmanscurrency.common.core.groups.BundleRequestFilter;
import io.github.lightman314.lightmanscurrency.common.core.groups.RegistryObjectBiBundle;
import io.github.lightman314.lightmanscurrency.common.core.groups.RegistryObjectBundle;
import io.github.lightman314.lightmanscurrency.common.core.variants.Color;
import io.github.lightman314.lightmanscurrency.common.core.variants.WoodType;
import io.github.lightman314.lightmanscurrency.common.items.CouponItem;
import io.github.lightman314.lightmanscurrency.common.items.MoneyBagItem;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import io.github.lightman314.lightmanscurrency.common.items.ancient_coins.AncientCoinType;
import io.github.lightman314.lightmanscurrency.common.items.data.MoneyBagData;
import io.github.lightman314.lightmanscurrency.util.ListUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;

@EventBusSubscriber(modid="lightmanscurrency")
public class ModCreativeGroups {
    public static final ResourceLocation COIN_GROUP_ID = VersionUtil.lcResource("coins");
    public static final ResourceLocation MACHINE_GROUP_ID = VersionUtil.lcResource("machines");
    public static final ResourceLocation TRADER_GROUP_ID = VersionUtil.lcResource("traders");
    public static final ResourceLocation UPGRADE_GROUP_ID = VersionUtil.lcResource("upgrades");
    public static final ResourceLocation EXTRA_GROUP_ID = VersionUtil.lcResource("extra");
    public static final Supplier<CreativeModeTab> COIN_GROUP = ModRegistries.CREATIVE_TABS.register("coins", () -> CreativeModeTab.builder().title((Component)LCText.CREATIVE_GROUP_COINS.get(new Object[0])).icon(ModCreativeGroups.ezIcon(ModBlocks.COINPILE_GOLD)).displayItems((parameters, p) -> {
        ModCreativeGroups.ezPop(p, ModItems.COIN_COPPER);
        ModCreativeGroups.ezPop(p, ModBlocks.COINPILE_COPPER);
        ModCreativeGroups.ezPop(p, ModBlocks.COINBLOCK_COPPER);
        ModCreativeGroups.ezPop(p, ModItems.COIN_IRON);
        ModCreativeGroups.ezPop(p, ModBlocks.COINPILE_IRON);
        ModCreativeGroups.ezPop(p, ModBlocks.COINBLOCK_IRON);
        ModCreativeGroups.ezPop(p, ModItems.COIN_GOLD);
        ModCreativeGroups.ezPop(p, ModBlocks.COINPILE_GOLD);
        ModCreativeGroups.ezPop(p, ModBlocks.COINBLOCK_GOLD);
        ModCreativeGroups.ezPop(p, ModItems.COIN_EMERALD);
        ModCreativeGroups.ezPop(p, ModBlocks.COINPILE_EMERALD);
        ModCreativeGroups.ezPop(p, ModBlocks.COINBLOCK_EMERALD);
        ModCreativeGroups.ezPop(p, ModItems.COIN_DIAMOND);
        ModCreativeGroups.ezPop(p, ModBlocks.COINPILE_DIAMOND);
        ModCreativeGroups.ezPop(p, ModBlocks.COINBLOCK_DIAMOND);
        ModCreativeGroups.ezPop(p, ModItems.COIN_NETHERITE);
        ModCreativeGroups.ezPop(p, ModBlocks.COINPILE_NETHERITE);
        ModCreativeGroups.ezPop(p, ModBlocks.COINBLOCK_NETHERITE);
        ModCreativeGroups.ezPop(p, ModItems.WALLET_LEATHER);
        ModCreativeGroups.ezPop(p, ModItems.WALLET_COPPER);
        ModCreativeGroups.ezPop(p, ModItems.WALLET_IRON);
        ModCreativeGroups.ezPop(p, ModItems.WALLET_GOLD);
        ModCreativeGroups.ezPop(p, ModItems.WALLET_EMERALD);
        ModCreativeGroups.ezPop(p, ModItems.WALLET_DIAMOND);
        ModCreativeGroups.ezPop(p, ModItems.WALLET_NETHERITE);
        ModCreativeGroups.ezPop(p, ModItems.WALLET_NETHER_STAR);
        ModCreativeGroups.ezPop(p, ModItems.WALLET_ENDER_DRAGON);
        ModCreativeGroups.ezPop(p, ModItems.ATM_CARD);
        ModCreativeGroups.ezPop(p, ModItems.TRADING_CORE);
        ModCreativeGroups.ezPop(p, ModItems.ITEM_TRADE_FILTER);
        ModCreativeGroups.ezPop(p, ModItems.VARIANT_WAND);
        ModCreativeGroups.ezPop(p, ModItems.COIN_CHOCOLATE_COPPER);
        ModCreativeGroups.ezPop(p, ModBlocks.COINPILE_CHOCOLATE_COPPER);
        ModCreativeGroups.ezPop(p, ModBlocks.COINBLOCK_CHOCOLATE_COPPER);
        ModCreativeGroups.ezPop(p, ModItems.COIN_CHOCOLATE_IRON);
        ModCreativeGroups.ezPop(p, ModBlocks.COINPILE_CHOCOLATE_IRON);
        ModCreativeGroups.ezPop(p, ModBlocks.COINBLOCK_CHOCOLATE_IRON);
        ModCreativeGroups.ezPop(p, ModItems.COIN_CHOCOLATE_GOLD);
        ModCreativeGroups.ezPop(p, ModBlocks.COINPILE_CHOCOLATE_GOLD);
        ModCreativeGroups.ezPop(p, ModBlocks.COINBLOCK_CHOCOLATE_GOLD);
        ModCreativeGroups.ezPop(p, ModItems.COIN_CHOCOLATE_EMERALD);
        ModCreativeGroups.ezPop(p, ModBlocks.COINPILE_CHOCOLATE_EMERALD);
        ModCreativeGroups.ezPop(p, ModBlocks.COINBLOCK_CHOCOLATE_EMERALD);
        ModCreativeGroups.ezPop(p, ModItems.COIN_CHOCOLATE_DIAMOND);
        ModCreativeGroups.ezPop(p, ModBlocks.COINPILE_CHOCOLATE_DIAMOND);
        ModCreativeGroups.ezPop(p, ModBlocks.COINBLOCK_CHOCOLATE_DIAMOND);
        ModCreativeGroups.ezPop(p, ModItems.COIN_CHOCOLATE_NETHERITE);
        ModCreativeGroups.ezPop(p, ModBlocks.COINPILE_CHOCOLATE_NETHERITE);
        ModCreativeGroups.ezPop(p, ModBlocks.COINBLOCK_CHOCOLATE_NETHERITE);
        for (AncientCoinType type : AncientCoinType.values()) {
            p.accept(type.asItem());
        }
    }).build());
    public static final Supplier<CreativeModeTab> MACHINE_GROUP = ModRegistries.CREATIVE_TABS.register("machines", () -> CreativeModeTab.builder().withTabsBefore(new ResourceLocation[]{COIN_GROUP_ID}).title((Component)LCText.CREATIVE_GROUP_MACHINES.get(new Object[0])).icon(ModCreativeGroups.ezIcon(ModBlocks.COIN_MINT)).displayItems((parameters, p) -> {
        ModCreativeGroups.ezPop(p, ModBlocks.COIN_MINT);
        ModCreativeGroups.ezPop(p, ModBlocks.ATM);
        ModCreativeGroups.ezPop(p, ModItems.PORTABLE_ATM);
        ModCreativeGroups.ezPop(p, ModBlocks.CASH_REGISTER);
        ModCreativeGroups.ezPop(p, ModBlocks.TERMINAL);
        ModCreativeGroups.ezPop(p, ModBlocks.GEM_TERMINAL);
        ModCreativeGroups.ezPop(p, ModItems.PORTABLE_TERMINAL);
        ModCreativeGroups.ezPop(p, ModItems.PORTABLE_GEM_TERMINAL);
        ModCreativeGroups.ezPop(p, ModBlocks.ITEM_TRADER_INTERFACE);
        ModCreativeGroups.ezPop(p, ModBlocks.TAX_COLLECTOR);
        ModCreativeGroups.ezPop(p, ModBlocks.AUCTION_STAND, BundleRequestFilter.VANILLA);
        ModCreativeGroups.ezPop(p, ModBlocks.TICKET_STATION);
        p.accept(TicketItem.CreateTicket(ModItems.TICKET_MASTER.get(), -1L));
        p.accept(TicketItem.CreateTicket(ModItems.TICKET_PASS.get(), -1L));
        p.accept(TicketItem.CreateTicket(ModItems.TICKET.get(), -1L));
        p.accept(CouponItem.CreateCoupon(ModItems.COUPON.get(), "3.14159265358979", Color.YELLOW.hexColor));
        ModCreativeGroups.ezPop(p, ModItems.TICKET_STUB);
        p.accept(TicketItem.CreateTicket(ModItems.GOLDEN_TICKET_MASTER.get(), -2L));
        p.accept(TicketItem.CreateTicket(ModItems.GOLDEN_TICKET_PASS.get(), -2L));
        p.accept(TicketItem.CreateTicket(ModItems.GOLDEN_TICKET.get(), -2L));
        ModCreativeGroups.ezPop(p, ModItems.GOLDEN_TICKET_STUB);
        ModCreativeGroups.ezPop(p, ModBlocks.COIN_CHEST);
        ModCreativeGroups.ezPop(p, ModBlocks.PIGGY_BANK);
        ModCreativeGroups.ezPop(p, ModBlocks.COINJAR_BLUE);
        p.accept(MoneyBagItem.createItem((ItemLike)ModBlocks.MONEY_BAG.get(), MoneyBagData.EMPTY));
    }).build());
    public static final Supplier<CreativeModeTab> TRADER_GROUP = ModRegistries.CREATIVE_TABS.register("traders", () -> CreativeModeTab.builder().withTabsBefore(new ResourceLocation[]{MACHINE_GROUP_ID}).title((Component)LCText.CREATIVE_GROUP_TRADING.get(new Object[0])).icon(ModCreativeGroups.ezIcon((ItemLike)ModBlocks.DISPLAY_CASE.get(Color.WHITE))).displayItems((parameters, p) -> {
        ModCreativeGroups.ezPop(p, ModBlocks.DISPLAY_CASE);
        ModCreativeGroups.ezPop(p, ModBlocks.SHELF, BundleRequestFilter.VANILLA);
        ModCreativeGroups.ezPop(p, ModBlocks.SHELF_2x2, BundleRequestFilter.VANILLA);
        ModCreativeGroups.ezPop(p, ModBlocks.CARD_DISPLAY, BundleRequestFilter.VANILLA);
        ModCreativeGroups.ezPop(p, ModBlocks.VENDING_MACHINE);
        ModCreativeGroups.ezPop(p, ModBlocks.FREEZER);
        ModCreativeGroups.ezPop(p, ModBlocks.VENDING_MACHINE_LARGE);
        ModCreativeGroups.ezPop(p, ModBlocks.ARMOR_DISPLAY);
        ModCreativeGroups.ezPop(p, ModBlocks.TICKET_KIOSK);
        ModCreativeGroups.ezPop(p, ModBlocks.BOOKSHELF_TRADER, BundleRequestFilter.VANILLA);
        ModCreativeGroups.ezPop(p, ModBlocks.SLOT_MACHINE);
        ModCreativeGroups.ezPop(p, ModBlocks.GACHA_MACHINE);
        ModCreativeGroups.ezPop(p, ModBlocks.ITEM_NETWORK_TRADER_1);
        ModCreativeGroups.ezPop(p, ModBlocks.ITEM_NETWORK_TRADER_2);
        ModCreativeGroups.ezPop(p, ModBlocks.ITEM_NETWORK_TRADER_3);
        ModCreativeGroups.ezPop(p, ModBlocks.ITEM_NETWORK_TRADER_4);
        ModCreativeGroups.ezPop(p, ModBlocks.PAYGATE);
        ModCreativeGroups.ezPop(p, ModBlocks.COMMAND_TRADER);
    }).build());
    public static final Supplier<CreativeModeTab> UPGRADE_GROUP = ModRegistries.CREATIVE_TABS.register("upgrades", () -> CreativeModeTab.builder().withTabsBefore(new ResourceLocation[]{TRADER_GROUP_ID}).title((Component)LCText.CREATIVE_GROUP_UPGRADES.get(new Object[0])).icon(ModCreativeGroups.ezIcon(ModItems.ITEM_CAPACITY_UPGRADE_1)).displayItems((parameters, p) -> {
        ModCreativeGroups.ezPop(p, ModItems.UPGRADE_SMITHING_TEMPLATE);
        ModCreativeGroups.ezPop(p, ModItems.ITEM_CAPACITY_UPGRADE_1);
        ModCreativeGroups.ezPop(p, ModItems.ITEM_CAPACITY_UPGRADE_2);
        ModCreativeGroups.ezPop(p, ModItems.ITEM_CAPACITY_UPGRADE_3);
        ModCreativeGroups.ezPop(p, ModItems.ITEM_CAPACITY_UPGRADE_4);
        ModCreativeGroups.ezPop(p, ModItems.SPEED_UPGRADE_1);
        ModCreativeGroups.ezPop(p, ModItems.SPEED_UPGRADE_2);
        ModCreativeGroups.ezPop(p, ModItems.SPEED_UPGRADE_3);
        ModCreativeGroups.ezPop(p, ModItems.SPEED_UPGRADE_4);
        ModCreativeGroups.ezPop(p, ModItems.SPEED_UPGRADE_5);
        ModCreativeGroups.ezPop(p, ModItems.OFFER_UPGRADE_1);
        ModCreativeGroups.ezPop(p, ModItems.OFFER_UPGRADE_2);
        ModCreativeGroups.ezPop(p, ModItems.OFFER_UPGRADE_3);
        ModCreativeGroups.ezPop(p, ModItems.OFFER_UPGRADE_4);
        ModCreativeGroups.ezPop(p, ModItems.OFFER_UPGRADE_5);
        ModCreativeGroups.ezPop(p, ModItems.OFFER_UPGRADE_6);
        ModCreativeGroups.ezPop(p, ModItems.NETWORK_UPGRADE);
        ModCreativeGroups.ezPop(p, ModItems.VOID_UPGRADE);
        ModCreativeGroups.ezPop(p, ModItems.HOPPER_UPGRADE);
        ModCreativeGroups.ezPop(p, ModItems.INTERACTION_UPGRADE_1);
        ModCreativeGroups.ezPop(p, ModItems.INTERACTION_UPGRADE_2);
        ModCreativeGroups.ezPop(p, ModItems.INTERACTION_UPGRADE_3);
        ModCreativeGroups.ezPop(p, ModItems.COIN_CHEST_EXCHANGE_UPGRADE);
        ModCreativeGroups.ezPop(p, ModItems.COIN_CHEST_MAGNET_UPGRADE_1);
        ModCreativeGroups.ezPop(p, ModItems.COIN_CHEST_MAGNET_UPGRADE_2);
        ModCreativeGroups.ezPop(p, ModItems.COIN_CHEST_MAGNET_UPGRADE_3);
        ModCreativeGroups.ezPop(p, ModItems.COIN_CHEST_MAGNET_UPGRADE_4);
        ModCreativeGroups.ezPop(p, ModItems.COIN_CHEST_BANK_UPGRADE);
        ModCreativeGroups.ezPop(p, ModItems.COIN_CHEST_SECURITY_UPGRADE);
    }).build());
    @Nullable
    public static Supplier<CreativeModeTab> EXTRA_GROUP = WoodType.hasModdedValues() ? ModRegistries.CREATIVE_TABS.register("extra", () -> CreativeModeTab.builder().withTabsBefore(new ResourceLocation[]{TRADER_GROUP_ID}).withTabsAfter(new ResourceLocation[]{UPGRADE_GROUP_ID}).title((Component)LCText.CREATIVE_GROUP_EXTRA.get(new Object[0])).icon(ModCreativeGroups.ezRandomIcon(ModCreativeGroups::getExtraGroup)).displayItems((parameters, p) -> {
        ModCreativeGroups.ezPop(p, ModBlocks.AUCTION_STAND, BundleRequestFilter.MODDED);
        ModCreativeGroups.ezPop(p, ModBlocks.SHELF, BundleRequestFilter.MODDED);
        ModCreativeGroups.ezPop(p, ModBlocks.SHELF_2x2, BundleRequestFilter.MODDED);
        ModCreativeGroups.ezPop(p, ModBlocks.CARD_DISPLAY, BundleRequestFilter.MODDED);
        ModCreativeGroups.ezPop(p, ModBlocks.BOOKSHELF_TRADER, BundleRequestFilter.MODDED);
    }).build()) : null;

    public static void init() {
    }

    private static CreativeModeTab getExtraGroup() {
        return EXTRA_GROUP.get();
    }

    @SubscribeEvent
    public static void buildVanillaTabContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
            event.accept((ItemLike)ModBlocks.PIGGY_BANK.get());
            event.accept((ItemLike)ModBlocks.COINJAR_BLUE.get());
        }
        if (event.getTabKey() == CreativeModeTabs.REDSTONE_BLOCKS) {
            event.accept((ItemLike)ModBlocks.PAYGATE.get());
        }
        if (event.getTabKey() == CreativeModeTabs.COLORED_BLOCKS) {
            event.acceptAll(ModCreativeGroups.convertToStack(ModBlocks.VENDING_MACHINE.getAllSorted()));
            event.acceptAll(ModCreativeGroups.convertToStack(ModBlocks.VENDING_MACHINE_LARGE.getAllSorted()));
            event.acceptAll(ModCreativeGroups.convertToStack(ModBlocks.FREEZER.getAllSorted()));
            event.acceptAll(ModCreativeGroups.convertToStack(ModBlocks.CARD_DISPLAY.getAllSorted()));
            event.acceptAll(ModCreativeGroups.convertToStack(ModBlocks.GACHA_MACHINE.getAllSorted()));
            for (Color c : Color.values()) {
                ItemStack stack = new ItemStack((ItemLike)ModBlocks.SUS_JAR.get());
                if (c != Color.WHITE) {
                    stack.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(c.hexColor, true));
                }
                event.accept(stack);
            }
        }
        if (event.getTabKey() == CreativeModeTabs.OP_BLOCKS && event.hasPermissions()) {
            event.accept((ItemLike)ModBlocks.COMMAND_TRADER.get());
        }
    }

    private static Supplier<ItemStack> ezIcon(Supplier<? extends ItemLike> item) {
        return Suppliers.memoize(() -> new ItemStack((ItemLike)item.get()));
    }

    private static Supplier<ItemStack> ezIcon(ItemLike item) {
        return Suppliers.memoize(() -> new ItemStack(item));
    }

    private static Supplier<ItemStack> ezRandomIcon(@Nonnull Supplier<CreativeModeTab> tabSource) {
        return () -> {
            CreativeModeTab tab = (CreativeModeTab)tabSource.get();
            if (tab == null) {
                return new ItemStack((ItemLike)ModItems.TRADING_CORE.get());
            }
            return ListUtil.randomItemFromCollection(tab.getDisplayItems(), new ItemStack((ItemLike)ModItems.TRADING_CORE.get()));
        };
    }

    public static void ezPop(CreativeModeTab.Output populator, ItemLike item) {
        populator.accept(item);
        IVariantItem itemVariant = VariantProvider.getVariantItem(item.asItem());
        if (itemVariant != null && LightmansCurrency.getProxy().isClient()) {
            ArrayList<Object> foundVariants = new ArrayList<Object>();
            for (ResourceLocation resourceLocation : itemVariant.getValidVariants()) {
                ModelVariant variant = ModelVariantDataManager.getVariant(resourceLocation);
                if (variant == null || !variant.getOrDefault(VariantProperties.SHOW_IN_CREATIVE).showFor(itemVariant)) continue;
                foundVariants.add(Pair.of((Object)resourceLocation, (Object)variant));
            }
            if (!foundVariants.isEmpty()) {
                foundVariants.sort(ModelVariant.COMPARATOR);
                for (Pair pair : foundVariants) {
                    ItemStack stack = new ItemStack(item);
                    stack.set(ModDataComponents.MODEL_VARIANT, (Object)((ResourceLocation)pair.getFirst()));
                    if (((ModelVariant)pair.getSecond()).getOrDefault(VariantProperties.SHOW_IN_CREATIVE).locked()) {
                        stack.set(ModDataComponents.VARIANT_LOCK, (Object)Unit.INSTANCE);
                    }
                    populator.accept(stack);
                }
            }
        }
    }

    public static void ezPop(CreativeModeTab.Output populator, List<? extends ItemLike> items) {
        for (ItemLike itemLike : items) {
            ModCreativeGroups.ezPop(populator, itemLike);
        }
    }

    public static void ezPop(CreativeModeTab.Output populator, Supplier<? extends ItemLike> item) {
        ModCreativeGroups.ezPop(populator, item.get());
    }

    public static void ezPop(CreativeModeTab.Output populator, RegistryObjectBundle<? extends ItemLike, ?> bundle) {
        ModCreativeGroups.ezPop(populator, bundle.getAllSorted());
    }

    public static void ezPop(CreativeModeTab.Output populator, RegistryObjectBundle<? extends ItemLike, ?> bundle, BundleRequestFilter filter) {
        ModCreativeGroups.ezPop(populator, bundle.getAllSorted(filter));
    }

    public static void ezPop(CreativeModeTab.Output populator, RegistryObjectBiBundle<? extends ItemLike, ?, ?> bundle) {
        ModCreativeGroups.ezPop(populator, bundle.getAllSorted());
    }

    public static void ezPop(CreativeModeTab.Output populator, RegistryObjectBiBundle<? extends ItemLike, ?, ?> bundle, BundleRequestFilter filter) {
        ModCreativeGroups.ezPop(populator, bundle.getAllSorted(filter));
    }

    private static Collection<ItemStack> convertToStack(Collection<? extends ItemLike> list) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (ItemLike itemLike : list) {
            result.add(new ItemStack(itemLike));
        }
        return result;
    }
}

