/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.capability.variant;

import io.github.lightman314.lightmanscurrency.api.misc.blocks.IDeepBlock;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.ITallBlock;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IWideBlock;
import io.github.lightman314.lightmanscurrency.api.variants.block.block_entity.IVariantDataStorage;
import io.github.lightman314.lightmanscurrency.api.variants.block.builtin.VariantChunkDataStorageAttachment;
import io.github.lightman314.lightmanscurrency.api.variants.block.builtin.VariantDataStorageAttachment;
import io.github.lightman314.lightmanscurrency.common.core.ModAttachmentTypes;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;

public class CapabilityVariantData {
    public static final BlockCapability<IVariantDataStorage, Void> CAPABILITY = BlockCapability.createVoid((ResourceLocation)VersionUtil.lcResource("variant_data"), IVariantDataStorage.class);

    public static void registerBlockEntity(RegisterCapabilitiesEvent event, BlockEntityType<?> ... types) {
        for (BlockEntityType<?> type : types) {
            event.registerBlockEntity(CAPABILITY, type, (be, c) -> (IVariantDataStorage)be.getData(VariantDataStorageAttachment.TYPE));
        }
    }

    public static void registerNormalBlock(RegisterCapabilitiesEvent event, Block ... blocks) {
        CapabilityVariantData.registerMultiBlock(event, (s, p) -> p, blocks);
    }

    public static void registerLCMultiBlock(RegisterCapabilitiesEvent event, Block ... blocks) {
        CapabilityVariantData.registerMultiBlock(event, (state, pos) -> {
            IDeepBlock deep;
            IWideBlock wide;
            ITallBlock tall;
            Block b = state.getBlock();
            if (b instanceof ITallBlock && (tall = (ITallBlock)b).getIsTop((BlockState)state)) {
                pos = tall.getOtherHeight((BlockPos)pos, (BlockState)state);
            }
            if (b instanceof IWideBlock && (wide = (IWideBlock)b).getIsRight((BlockState)state)) {
                pos = wide.getOtherSide((BlockPos)pos, (BlockState)state);
            }
            if (b instanceof IDeepBlock && (deep = (IDeepBlock)b).getIsBack((BlockState)state)) {
                pos = deep.getOtherDepth((BlockPos)pos, (BlockState)state);
            }
            return pos;
        }, blocks);
    }

    public static void registerMultiBlock(RegisterCapabilitiesEvent event, BiFunction<BlockState, BlockPos, BlockPos> getMultiblockCorner, Block ... blocks) {
        event.registerBlock(CAPABILITY, (level, pos, state, be, c) -> {
            pos = (BlockPos)getMultiblockCorner.apply(state, pos);
            LevelChunk chunk = level.getChunkAt(pos);
            VariantChunkDataStorageAttachment data = (VariantChunkDataStorageAttachment)chunk.getData(ModAttachmentTypes.VARIANT_CHUNK_DATA);
            return data.getData(pos);
        }, blocks);
    }
}

