/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.config.client.screen.builtin.subscreens.list;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.config.client.screen.ConfigScreen;
import io.github.lightman314.lightmanscurrency.api.config.client.screen.builtin.subscreens.list.ListScreenSettings;
import io.github.lightman314.lightmanscurrency.api.config.client.screen.options.ConfigFileOption;
import io.github.lightman314.lightmanscurrency.api.config.options.ConfigOption;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ListOptionScreen
extends ConfigScreen
implements IScrollable {
    private final ListScreenSettings settings;
    public final ConfigFileOption file;
    private final ConfigOption<?> option;
    private final List<AbstractWidget> displayEntries = new ArrayList<AbstractWidget>();
    private int visibleEntries = 1;
    private int scroll = 0;

    public ListOptionScreen(Screen parent, ConfigFileOption file, ConfigOption<?> option, ListScreenSettings settings) {
        super(parent);
        this.settings = settings;
        this.settings.setScreen(this);
        this.file = file;
        this.option = option;
        this.option.addListener(this::onOptionChanged);
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = newScroll;
        this.onScrollChanged();
    }

    @Override
    public int getMaxScroll() {
        return IScrollable.calculateMaxScroll(this.visibleEntries, this.displayEntries.size());
    }

    @Override
    protected void initialize(ScreenArea screenArea) {
        this.visibleEntries = (screenArea.height - 80) / 30;
        this.setupWidgets();
        this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.centerX() - 105, screenArea.height - 25)).width(100)).text(LCText.CONFIG_OPTION_LIST_ADD).pressAction(this::addOption)).addon(EasyAddonHelper.activeCheck(this.settings::canAddEntry))).build());
        this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.centerX() + 5, screenArea.height - 25)).width(100)).text(LCText.CONFIG_BACK).pressAction(this::onClose)).build());
        this.addChild(((ScrollListener.Builder)ScrollListener.builder().area(screenArea)).listener(this).build());
        this.addChild(((ScrollBarWidget.Builder)ScrollBarWidget.builder().scrollable(this).position(screenArea.centerX() + 150 + 10, 40)).height(screenArea.height - 80).build());
    }

    @Override
    protected List<Component> getTitleSections() {
        return List.of(this.file.name(), this.option.getDisplayName());
    }

    private void onOptionChanged(ConfigOption<?> option) {
        this.revalidateWidgets();
    }

    public boolean canEdit() {
        return this.file.canEdit(this.minecraft);
    }

    private void addOption() {
        this.settings.addEntry();
        this.revalidateWidgets();
    }

    private void setupWidgets() {
        this.displayEntries.clear();
        this.revalidateWidgets();
    }

    private void revalidateWidgets() {
        if (this.displayEntries.size() != this.settings.getListSize()) {
            for (AbstractWidget widget : this.displayEntries) {
                this.removeChild(widget);
            }
            this.displayEntries.clear();
            for (int i = 0; i < this.settings.getListSize(); ++i) {
                this.addEntry(this.settings.buildEntry(i));
            }
            this.validateScroll();
            this.onScrollChanged();
        }
    }

    private void addEntry(AbstractWidget widget) {
        this.displayEntries.add(this.addChild(widget));
    }

    private void onScrollChanged() {
        ScreenArea area = this.getArea();
        int index = 0;
        int yPos = 40;
        int xPos = area.centerX() - 150;
        for (AbstractWidget widget : this.displayEntries) {
            boolean bl = widget.visible = index >= this.scroll && index < this.scroll + this.visibleEntries;
            if (widget.visible) {
                widget.setPosition(xPos, yPos);
                yPos += 30;
            }
            ++index;
        }
    }

    @Override
    protected void afterClose() {
        this.option.removeListener(this::onOptionChanged);
        this.settings.setScreen(null);
    }
}

