/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.config.client.screen.builtin.subscreens.list.settings;

import com.mojang.datafixers.util.Either;
import io.github.lightman314.lightmanscurrency.api.config.client.screen.builtin.subscreens.list.settings.EasyListSettings;
import io.github.lightman314.lightmanscurrency.api.config.client.screen.widgets.builtin.list.ListEditBoxOption;
import io.github.lightman314.lightmanscurrency.api.config.options.basic.LongListOption;
import io.github.lightman314.lightmanscurrency.client.util.text_inputs.LongParser;
import io.github.lightman314.lightmanscurrency.client.util.text_inputs.TextInputUtil;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.components.AbstractWidget;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class LongListSettings
extends EasyListSettings<Long, LongListOption> {
    public LongListSettings(LongListOption option, Consumer<Object> changeHandler) {
        super(option, changeHandler);
    }

    @Override
    protected Long getBackupValue() {
        return 0L;
    }

    @Override
    protected Long getNewEntryValue() {
        return Math.clamp(0L, ((LongListOption)this.option).lowerLimit, ((LongListOption)this.option).upperLimit);
    }

    @Override
    protected Either<Long, Void> tryCastValue(Object newValue) {
        if (newValue instanceof Long) {
            Long l = (Long)newValue;
            return Either.left((Object)l);
        }
        return Either.right(null);
    }

    @Override
    public AbstractWidget buildEntry(int index) {
        return ListEditBoxOption.builder(this.option, index, this).inputBoxSetup(handler -> TextInputUtil.longBuilder().apply(LongParser.builder().min(((LongListOption)this.option).lowerLimit).max(((LongListOption)this.option).upperLimit).consumer()).startingValue((Long)this.getValue(index)).handler(handler::accept)).optionChangeHandler(text -> {
            float newValue = ((Long)this.getValue(index)).longValue();
            if (newValue == 0.0f && text.getValue().isEmpty()) {
                return;
            }
            text.setValue(String.valueOf(newValue));
        }).build();
    }
}

