/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.config.client.screen.widgets.builtin.list;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.config.client.screen.builtin.subscreens.list.ListScreenSettings;
import io.github.lightman314.lightmanscurrency.api.config.options.ConfigOption;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconUtil;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.ITooltipWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidgetWithChildren;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.util.TooltipHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class ListOptionWidget
extends EasyWidgetWithChildren
implements ITooltipWidget {
    public static final int WIDTH = 300;
    public static final int HEIGHT = 20;
    public static final int HALF_WIDTH = 150;
    protected final ConfigOption<?> option;
    protected final int index;
    private final ListScreenSettings listSettings;
    private final List<Pair<AbstractWidget, ScreenPosition>> children = new ArrayList<Pair<AbstractWidget, ScreenPosition>>();

    protected ListOptionWidget(ListOptionBuilder<?> builder) {
        super(builder);
        this.option = builder.option;
        this.index = builder.index;
        this.listSettings = builder.settings;
    }

    @Override
    public final void addChildren(ScreenArea area) {
        this.addChildAtRelativePosition(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().icon(IconUtil.ICON_X).pressAction(this::removeValue)).addon(EasyAddonHelper.tooltip(LCText.CONFIG_OPTION_LIST_REMOVE))).addon(EasyAddonHelper.visibleCheck(this.listSettings::canRemoveEntry))).build(), ScreenPosition.of(280, 0));
        this.addMoreChildren(area);
    }

    protected abstract void addMoreChildren(ScreenArea var1);

    protected final <T> T addChildAtRelativePosition(T child, ScreenPosition position) {
        if (child instanceof AbstractWidget) {
            AbstractWidget aw = (AbstractWidget)child;
            this.children.add((Pair<AbstractWidget, ScreenPosition>)Pair.of((Object)aw, (Object)position));
        }
        return this.addChild(child);
    }

    @Override
    protected void renderTick() {
        for (Pair<AbstractWidget, ScreenPosition> pair : this.children) {
            AbstractWidget widget = (AbstractWidget)pair.getFirst();
            widget.visible = this.isVisible();
            if (!this.isVisible()) continue;
            ScreenPosition newPos = ((ScreenPosition)pair.getSecond()).offset(this.getPosition());
            widget.setPosition(newPos.x, newPos.y);
        }
    }

    @Override
    protected void renderWidget(EasyGuiGraphics gui) {
        MutableComponent name = LCText.CONFIG_OPTION_LIST_ENTRY.get(this.index + 1);
        int width = gui.font.width((FormattedText)name);
        gui.drawShadowed((Component)name, 150 - width - 5, 5, 0xFFFFFF);
    }

    @Override
    public List<Component> getTooltipText() {
        return TooltipHelper.splitTooltips(this.option.getCommentTooltips(), new ChatFormatting[0]);
    }

    @Override
    public List<Component> getTooltipText(int mouseX, int mouseY) {
        ScreenArea area = this.getArea();
        ScreenArea leftArea = area.ofSize(area.width / 2, area.height);
        if (leftArea.isMouseInArea(mouseX, mouseY)) {
            return this.getTooltipText();
        }
        return null;
    }

    protected final void changeValue(Object newValue) {
        this.listSettings.setEntry(this.index, newValue);
    }

    protected final void removeValue() {
        if (this.listSettings.canRemoveEntry()) {
            this.listSettings.removeEntry(this.index);
        }
    }

    protected static abstract class ListOptionBuilder<T extends ListOptionBuilder<T>>
    extends EasyWidget.EasyBuilder<T> {
        private final ConfigOption<?> option;
        protected final int index;
        private final ListScreenSettings settings;

        protected ListOptionBuilder(ConfigOption<?> option, int index, ListScreenSettings settings) {
            super(300, 20);
            this.option = option;
            this.index = index;
            this.settings = settings;
        }
    }
}

