/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.ejection;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.api.ejection.EjectionData;
import io.github.lightman314.lightmanscurrency.api.ejection.builtin.BasicEjectionData;
import io.github.lightman314.lightmanscurrency.api.misc.player.OwnerData;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public interface IDumpable {
    @Nonnull
    public EjectionData buildEjectionData(@Nonnull Level var1, @Nonnull BlockPos var2, @Nullable BlockState var3);

    public static IDumpable preCollected(List<ItemStack> contents, Component name, OwnerData owner) {
        return new LazyDumpable(contents, name, owner);
    }

    public static class LazyDumpable
    implements IDumpable {
        private final ImmutableList<ItemStack> contents;
        private final Component name;
        private final OwnerData owner = new OwnerData(() -> true);

        protected LazyDumpable(List<ItemStack> contents, Component name, OwnerData owner) {
            this.contents = ImmutableList.copyOf(contents);
            this.name = name;
            this.owner.copyFrom(owner);
        }

        @Override
        @Nonnull
        public EjectionData buildEjectionData(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state) {
            return new BasicEjectionData(this.owner, (Container)InventoryUtil.buildInventory(this.contents), this.name);
        }
    }
}

