/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.events;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.AlertData;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.ICancellableEvent;
import org.jetbrains.annotations.ApiStatus;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class TradeEvent
extends Event {
    private final TradeData trade;
    private final TradeContext context;

    public final boolean hasPlayerReference() {
        return this.context.hasPlayerReference();
    }

    @Nullable
    public final PlayerReference getPlayerReference() {
        return this.context.getPlayerReference();
    }

    public final TradeData getTrade() {
        return this.trade;
    }

    public final int getTradeStock() {
        return this.trade.getStock(this.context);
    }

    public final int getTradeIndex() {
        return this.getTrader().indexOfTrade(this.trade);
    }

    public final TraderData getTrader() {
        return this.context.getTrader();
    }

    public final TradeContext getContext() {
        return this.context;
    }

    protected TradeEvent(TradeData trade, TradeContext context) {
        this.trade = trade;
        this.context = context;
    }

    public static class PostTradeEvent
    extends TradeEvent {
        private boolean isDirty = false;
        private final MoneyValue pricePaid;
        private final MoneyValue taxesPaid;
        private final List<?> product;

        public MoneyValue getPricePaid() {
            return this.pricePaid;
        }

        public MoneyValue getTaxesPaid() {
            return this.taxesPaid;
        }

        @ApiStatus.Experimental
        public List<?> getProduct() {
            return ImmutableList.copyOf(this.product);
        }

        public PostTradeEvent(TradeData trade, TradeContext context, MoneyValue pricePaid, MoneyValue taxesPaid) {
            this(trade, context, pricePaid, taxesPaid, new ArrayList());
        }

        public PostTradeEvent(TradeData trade, TradeContext context, MoneyValue pricePaid, MoneyValue taxesPaid, List<?> product) {
            super(trade, context);
            this.pricePaid = pricePaid;
            this.taxesPaid = taxesPaid;
            this.product = product;
        }

        public boolean isDirty() {
            return this.isDirty;
        }

        public void markDirty() {
            this.isDirty = true;
        }

        public void clean() {
            this.isDirty = false;
        }
    }

    public static class TradeCostEvent
    extends TradeEvent {
        private boolean forceFree = false;
        private int pricePercentage = 100;
        private final MoneyValue baseCost;

        public boolean forcedFree() {
            return this.forceFree;
        }

        public void makeFree() {
            this.forceFree = true;
        }

        public void makeNotFree() {
            this.forceFree = false;
        }

        public int getPricePercentage() {
            return this.pricePercentage;
        }

        public void setPricePercentage(int pricePercentage) {
            this.pricePercentage = pricePercentage;
        }

        public void giveDiscount(int percentage) {
            this.pricePercentage -= percentage;
        }

        public void hikePrice(int percentage) {
            this.pricePercentage += percentage;
        }

        public MoneyValue getBaseCost() {
            return this.baseCost;
        }

        public boolean getCostResultIsFree() {
            return this.forceFree || this.pricePercentage <= 0 || this.baseCost.isFree();
        }

        public MoneyValue getCostResult() {
            return this.getCostResultIsFree() ? MoneyValue.free() : this.baseCost.percentageOfValue(this.pricePercentage);
        }

        @Deprecated(since="2.2.2.5")
        public TradeCostEvent(TradeData trade, TradeContext context) {
            this(trade, context, TradeRule.getBaseCost(trade, context));
        }

        public TradeCostEvent(TradeData trade, TradeContext context, MoneyValue baseCost) {
            super(trade, context);
            this.baseCost = baseCost;
        }

        public final boolean matches(TradeData trade) {
            return this.getTrade() == trade;
        }

        public final boolean matches(TradeCostEvent event) {
            return this.getTrade() == event.getTrade() && this.forceFree == event.forceFree && this.pricePercentage == event.pricePercentage && this.baseCost.equals(event.baseCost);
        }
    }

    public static class PreTradeEvent
    extends TradeEvent
    implements ICancellableEvent {
        private final List<AlertData> alerts = new ArrayList<AlertData>();

        public PreTradeEvent(TradeData trade, TradeContext context) {
            super(trade, context);
        }

        public void addAlert(AlertData alert, boolean cancelTrade) {
            this.alerts.add(alert);
            if (cancelTrade) {
                this.setCanceled(true);
            }
        }

        public void addHelpful(MutableComponent message) {
            this.addAlert(AlertData.helpful(message), false);
        }

        public void addNeutral(MutableComponent message) {
            this.addAlert(AlertData.neutral(message), false);
        }

        public void addWarning(MutableComponent message) {
            this.addAlert(AlertData.warn(message), false);
        }

        public void addError(MutableComponent message) {
            this.addAlert(AlertData.error(message), false);
        }

        public void addDenial(MutableComponent message) {
            this.addAlert(AlertData.error(message), true);
        }

        public List<AlertData> getAlertInfo() {
            return this.alerts;
        }
    }
}

