/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.events;

import io.github.lightman314.lightmanscurrency.common.attachments.WalletHandler;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class WalletDropEvent
extends PlayerEvent
implements ICancellableEvent {
    private Container walletInventory;
    private ItemStack walletStack;
    public final DamageSource source;
    private List<ItemStack> walletDrops = new ArrayList<ItemStack>();
    public final boolean keepWallet;
    public final boolean destroyWallet;
    public final int coinDropPercent;

    public Container getWalletInventory() {
        return this.walletInventory;
    }

    public ItemStack getWalletStack() {
        ItemStack result = this.walletStack.copy();
        if (WalletItem.isWallet(result)) {
            WalletItem.getDataWrapper(result).setContents(this.walletInventory, null);
        }
        return result;
    }

    public void setWalletStack(ItemStack wallet) {
        this.walletStack = wallet.copy();
        this.walletInventory = WalletItem.getDataWrapper(wallet).getContents();
    }

    public List<ItemStack> getDrops() {
        return this.walletDrops;
    }

    public void setDrops(List<ItemStack> drops) {
        this.walletDrops = new ArrayList<ItemStack>(drops);
    }

    public void addDrop(ItemStack drop) {
        this.walletDrops.add(drop);
    }

    public void addDrops(Collection<ItemStack> drop) {
        this.walletDrops.addAll(drop);
    }

    public WalletDropEvent(Player player, WalletHandler walletHandler, DamageSource source, boolean keepWallet, boolean destroyWallet, int coinDropPercent) {
        super(player);
        this.walletStack = walletHandler.getWallet().copy();
        this.walletInventory = WalletItem.getDataWrapper(this.walletStack).getContents();
        this.source = source;
        this.keepWallet = keepWallet;
        this.destroyWallet = destroyWallet;
        this.coinDropPercent = coinDropPercent;
    }
}

