/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.misc;

import com.mojang.brigadier.context.CommandContext;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public class EasyText {
    public static MutableComponent empty() {
        return Component.empty();
    }

    public static MutableComponent literal(String text) {
        return Component.literal((String)text);
    }

    public static MutableComponent translatable(String translation, Object ... children) {
        return Component.translatableEscape((String)translation, (Object[])children);
    }

    public static MutableComponent translatableWithFallback(String translation, String fallback) {
        return Component.translatableWithFallback((String)translation, (String)fallback);
    }

    @Nullable
    public static MutableComponent translatableOrNull(String translationKey, Object ... children) {
        Language lang = Language.getInstance();
        if (lang.has(translationKey)) {
            return EasyText.translatable(translationKey, children);
        }
        return null;
    }

    public static MutableComponent makeMutable(Component text) {
        if (text instanceof MutableComponent) {
            MutableComponent mc = (MutableComponent)text;
            return mc;
        }
        return text.copy();
    }

    public static void sendMessage(Player player, Component message) {
        player.sendSystemMessage(message);
    }

    public static void sendCommandSucess(CommandContext<CommandSourceStack> stack, Component message, boolean postToAdmins) {
        EasyText.sendCommandSucess((CommandSourceStack)stack.getSource(), message, postToAdmins);
    }

    public static void sendCommandSucess(CommandSourceStack stack, Component message, boolean postToAdmins) {
        stack.sendSuccess(() -> message, postToAdmins);
    }

    public static void sendCommandFail(CommandContext<CommandSourceStack> stack, Component message) {
        EasyText.sendCommandFail((CommandSourceStack)stack.getSource(), message);
    }

    public static void sendCommandFail(CommandSourceStack stack, Component message) {
        stack.sendFailure(message);
    }

    public static Component loadComponentOrString(String componentJson, HolderLookup.Provider lookup) {
        try {
            return Component.Serializer.fromJson((String)componentJson, (HolderLookup.Provider)lookup);
        }
        catch (Exception exception) {
            return EasyText.literal(componentJson);
        }
    }
}

