/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.misc.blockentity;

import io.github.lightman314.lightmanscurrency.api.variants.VariantProvider;
import io.github.lightman314.lightmanscurrency.api.variants.block.IVariantBlock;
import io.github.lightman314.lightmanscurrency.api.variants.block.block_entity.IVariantDataStorage;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import io.github.lightman314.lightmanscurrency.util.BlockEntityUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class EasyBlockEntity
extends BlockEntity
implements IClientTracker,
IVariantDataStorage {
    @Nullable
    private ResourceLocation currentVariant = null;
    private boolean variantLocked = false;

    public final RegistryAccess registryAccess() {
        return this.level.registryAccess();
    }

    @Override
    @Nullable
    public ResourceLocation getCurrentVariant() {
        return this.currentVariant;
    }

    @Override
    public boolean isVariantLocked() {
        return this.variantLocked;
    }

    @Override
    public void setVariant(@Nullable ResourceLocation variant, boolean variantLocked) {
        this.currentVariant = variant;
        this.variantLocked = variantLocked;
        this.setChanged();
        if (this.isServer()) {
            BlockEntityUtil.sendUpdatePacket((BlockEntity)this, this.saveVariantPacket());
        }
    }

    public EasyBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public boolean isClient() {
        return this.level == null || this.level.isClientSide;
    }

    protected final CompoundTag saveVariantPacket() {
        CompoundTag tag = new CompoundTag();
        if (this.currentVariant != null) {
            tag.putString("Variant", this.currentVariant.toString());
        } else {
            tag.putBoolean("NoVariant", true);
        }
        tag.putBoolean("VariantLocked", this.variantLocked);
        return tag;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        if (this.currentVariant != null) {
            tag.putString("Variant", this.currentVariant.toString());
        }
        if (this.variantLocked) {
            tag.putBoolean("VariantLocked", this.variantLocked);
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        if (tag.contains("Variant")) {
            this.currentVariant = VersionUtil.parseResource(tag.getString("Variant"));
        } else if (tag.contains("NoVariant")) {
            this.currentVariant = null;
        }
        if (tag.contains("VariantLocked")) {
            this.variantLocked = tag.getBoolean("VariantLocked");
        }
        super.loadAdditional(tag, registries);
    }

    public void onLoad() {
        BlockState state;
        if (this.currentVariant != null && VariantProvider.getVariantBlock((state = this.getBlockState()).getBlock()) != null && !((Boolean)state.getValue((Property)IVariantBlock.VARIANT)).booleanValue()) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue((Property)IVariantBlock.VARIANT, (Comparable)Boolean.valueOf(true)));
        }
        if (this.isClient()) {
            BlockEntityUtil.requestUpdatePacket(this);
        }
        super.onLoad();
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider lookup) {
        return this.saveWithoutMetadata(lookup);
    }
}

