/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.misc.client.sprites;

import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.FixedSizeSprite;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public interface FlexibleHeightSprite {
    default public void render(EasyGuiGraphics gui, ScreenPosition position, int height) {
        this.render(gui, position.x, position.y, height);
    }

    public void render(EasyGuiGraphics var1, int var2, int var3, int var4);

    public int getWidth();

    default public boolean canFitInSize(int height) {
        return true;
    }

    default public FixedSizeSprite ofSize(int height) {
        return new FixedSprite(this, height);
    }

    public static class FixedSprite
    implements FixedSizeSprite {
        private final FlexibleHeightSprite sprite;
        private final int height;

        private FixedSprite(FlexibleHeightSprite sprite, int height) {
            this.sprite = sprite;
            this.height = height;
        }

        @Override
        public int getWidth() {
            return this.sprite.getWidth();
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        public void render(EasyGuiGraphics gui, int x, int y) {
            if (this.sprite.canFitInSize(this.height)) {
                this.sprite.render(gui, x, y, this.height);
            }
        }
    }
}

