/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.misc.data;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.data.CustomDataType;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import io.github.lightman314.lightmanscurrency.common.util.LookupHelper;
import io.github.lightman314.lightmanscurrency.network.message.data.SPacketSyncCustomData;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;

@ParametersAreNonnullByDefault
@FieldsAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class CustomData
implements IClientTracker,
LazyPacketData.IBuilderProvider {
    private boolean initialized = false;
    private boolean isClient = false;
    private boolean loaded = false;
    private Runnable setChanged = () -> {};

    public abstract CustomDataType<?> getType();

    @Override
    public final boolean isClient() {
        return this.isClient;
    }

    @Override
    public final boolean isServer() {
        return IClientTracker.super.isServer();
    }

    public final CustomData initClient() {
        if (this.initialized) {
            return this;
        }
        this.isClient = true;
        this.initialized = true;
        return this;
    }

    public final void initServer(Runnable setChanged) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.setChanged = setChanged;
        try {
            this.serverInit();
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error caught in the custom data's serverInit function!", t);
        }
    }

    public abstract void save(CompoundTag var1, HolderLookup.Provider var2);

    public final void loadData(CompoundTag tag, HolderLookup.Provider lookup) {
        if (this.isClient || this.loaded) {
            return;
        }
        this.loaded = true;
        this.load(tag, lookup);
    }

    protected abstract void load(CompoundTag var1, HolderLookup.Provider var2);

    public final void receivePacket(LazyPacketData message) {
        if (this.isServer()) {
            return;
        }
        this.parseSyncPacket(message, message.lookup);
    }

    protected abstract void parseSyncPacket(LazyPacketData var1, HolderLookup.Provider var2);

    protected void serverInit() {
    }

    public abstract void onPlayerJoin(ServerPlayer var1);

    public final void sendSyncPacket(LazyPacketData.Builder builder) {
        if (this.isClient) {
            return;
        }
        new SPacketSyncCustomData(this.getType(), builder.build()).sendToAll();
    }

    public final void sendSyncPacket(LazyPacketData.Builder builder, ServerPlayer player) {
        if (this.isClient) {
            return;
        }
        new SPacketSyncCustomData(this.getType(), builder.build()).sendTo(player);
    }

    public final void setChanged() {
        this.setChanged.run();
    }

    @Override
    public final LazyPacketData.Builder builder() {
        return LazyPacketData.builder((HolderLookup.Provider)LookupHelper.getRegistryAccess());
    }
}

