/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.money.bank.reference;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.ISidedObject;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.BankAPI;
import io.github.lightman314.lightmanscurrency.api.money.bank.IBankAccount;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReferenceType;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.builtin.PlayerBankReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.builtin.TeamBankReference;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.IMoneyHolder;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.MoneyHolder;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class BankReference
extends MoneyHolder.Slave
implements ISidedObject {
    private Supplier<Boolean> isClient = () -> false;
    protected final BankReferenceType type;

    @Override
    public boolean isClient() {
        return this.isClient.get();
    }

    @Override
    public BankReference flagAsClient() {
        return this.flagAsClient(true);
    }

    @Override
    public BankReference flagAsClient(boolean isClient) {
        this.isClient = () -> isClient;
        return this;
    }

    @Override
    public BankReference flagAsClient(IClientTracker parent) {
        this.isClient = parent::isClient;
        return this;
    }

    protected BankReference(BankReferenceType type) {
        this.type = type;
    }

    public final boolean isValid() {
        return this.get() != null;
    }

    @Nullable
    public abstract IBankAccount get();

    public int sortPriority() {
        return 0;
    }

    public abstract boolean isSalaryTarget(PlayerReference var1);

    public boolean isSalaryTarget(Player player) {
        return this.isSalaryTarget(PlayerReference.of(player));
    }

    public abstract boolean allowedAccess(PlayerReference var1);

    public abstract boolean allowedAccess(Player var1);

    public abstract int salaryPermission(PlayerReference var1);

    public final int salaryPermission(Player player) {
        return LCAdminMode.isAdminPlayer(player) ? Integer.MAX_VALUE : this.salaryPermission(PlayerReference.of(player));
    }

    public boolean canPersist(Player player) {
        return true;
    }

    public final CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag);
        tag.putString("Type", this.type.id.toString());
        return tag;
    }

    protected abstract void saveAdditional(CompoundTag var1);

    public final void encode(FriendlyByteBuf buffer) {
        buffer.writeUtf(this.type.id.toString());
        this.encodeAdditional(buffer);
    }

    protected abstract void encodeAdditional(FriendlyByteBuf var1);

    @Nullable
    public static BankReference load(CompoundTag tag) {
        if (tag.contains("Type")) {
            BankReferenceType type = BankAPI.getApi().GetReferenceType(VersionUtil.parseResource(tag.getString("Type")));
            if (type != null) {
                return type.load(tag);
            }
            LightmansCurrency.LogWarning("No Bank Reference Type '" + String.valueOf(type) + "' could be loaded.");
        } else {
            if (tag.contains("PlayerID")) {
                return PlayerBankReference.of(tag.getUUID("PlayerID"));
            }
            if (tag.contains("TeamID")) {
                return TeamBankReference.of(tag.getLong("TeamID"));
            }
        }
        return null;
    }

    public static BankReference decode(FriendlyByteBuf buffer) {
        BankReferenceType type = BankAPI.getApi().GetReferenceType(VersionUtil.parseResource(buffer.readUtf()));
        if (type != null) {
            return type.decode(buffer);
        }
        LightmansCurrency.LogWarning("No Bank Reference Type '" + String.valueOf(type) + "' could be decoded.");
        return null;
    }

    @Override
    @Nullable
    protected IMoneyHolder getParent() {
        return this.get();
    }

    @Nullable
    public abstract IconData getIcon();

    public boolean equals(Object obj) {
        if (obj instanceof BankReference) {
            BankReference br = (BankReference)obj;
            return br.save().equals((Object)this.save());
        }
        return false;
    }

    public int hashCode() {
        return this.save().hashCode();
    }
}

