/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.money.coins.atm.icons;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.atm.ATMExchangeButton;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class ATMIconData {
    protected final int xPos;
    protected final int yPos;

    protected ATMIconData(JsonObject data) throws JsonSyntaxException, ResourceLocationException {
        this.xPos = GsonHelper.getAsInt((JsonObject)data, (String)"x");
        this.yPos = GsonHelper.getAsInt((JsonObject)data, (String)"y");
    }

    protected ATMIconData(int xPos, int yPos) {
        this.xPos = xPos;
        this.yPos = yPos;
    }

    public final JsonObject save(HolderLookup.Provider lookup) {
        JsonObject data = new JsonObject();
        data.addProperty("type", this.getType().toString());
        data.addProperty("x", (Number)this.xPos);
        data.addProperty("y", (Number)this.yPos);
        this.saveAdditional(data, lookup);
        return data;
    }

    protected abstract ResourceLocation getType();

    protected abstract void saveAdditional(JsonObject var1, HolderLookup.Provider var2);

    @OnlyIn(value=Dist.CLIENT)
    public abstract void render(ATMExchangeButton var1, EasyGuiGraphics var2, boolean var3);
}

