/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.money.value.builtin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.player.OwnerData;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.ChainData;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.coin.CoinEntry;
import io.github.lightman314.lightmanscurrency.api.money.types.builtin.CoinCurrencyType;
import io.github.lightman314.lightmanscurrency.api.money.value.IItemBasedValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.builtin.CoinValuePair;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.DisplayEntry;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.display.CoinPriceEntry;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public final class CoinValue
extends MoneyValue
implements IItemBasedValue {
    public final ImmutableList<CoinValuePair> coinValues;
    private final String chain;
    private CompoundTag backup = null;

    @Nonnull
    public String getChain() {
        return this.chain;
    }

    @Override
    public boolean isEmpty() {
        return this.coinValues.isEmpty();
    }

    @Override
    public boolean isInvalid() {
        return this.backup != null;
    }

    public boolean isValid() {
        return this.isFree() || !this.coinValues.isEmpty();
    }

    @Override
    @Nonnull
    protected String generateUniqueName() {
        return this.generateCustomUniqueName(this.chain);
    }

    @Override
    @Nonnull
    protected ResourceLocation getType() {
        return CoinCurrencyType.TYPE;
    }

    private CoinValue(@Nonnull String chain, @Nonnull CompoundTag backup) {
        this.chain = chain;
        this.coinValues = ImmutableList.of();
        this.backup = backup;
    }

    private CoinValue(@Nonnull String chain, @Nonnull List<CoinValuePair> values) {
        this.chain = chain;
        this.coinValues = ImmutableList.copyOf(CoinValue.roundValue(this.chain, values));
    }

    public static MoneyValue create(@Nonnull String chain, @Nonnull List<CoinValuePair> coinValues) {
        return coinValues.isEmpty() ? MoneyValue.empty() : new CoinValue(chain, coinValues);
    }

    @Override
    public void saveAdditional(@Nonnull CompoundTag tag) {
        if (this.backup != null) {
            tag.merge(this.backup);
            return;
        }
        tag.putString("Chain", this.chain);
        ListTag valueList = new ListTag();
        for (CoinValuePair pair : this.coinValues) {
            valueList.add((Object)pair.save());
        }
        tag.put("Value", (Tag)valueList);
    }

    @Nonnull
    public static MoneyValue loadCoinValue(@Nonnull CompoundTag tag) {
        if (tag.contains("Chain", 8)) {
            boolean dataLoaded = true;
            if (CoinAPI.getApi().NoDataAvailable()) {
                LightmansCurrency.LogWarning("Coin Value loaded before receiving the Chain Data packet. Will assume all value pairs are valid and don't need rounding!");
                dataLoaded = false;
            }
            String chain = tag.getString("Chain");
            ChainData chainData = CoinAPI.getApi().ChainData(chain);
            if (chainData == null && dataLoaded) {
                return new CoinValue(chain, tag);
            }
            if (tag.contains("Value", 9)) {
                ListTag valueList = tag.getList("Value", 10);
                ArrayList<CoinValuePair> pairList = new ArrayList<CoinValuePair>();
                for (int i = 0; i < valueList.size(); ++i) {
                    try {
                        pairList.add(CoinValuePair.load(chainData, valueList.getCompound(i)));
                        continue;
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                return CoinValue.create(chain, pairList);
            }
        }
        return MoneyValue.empty();
    }

    @Nullable
    public static MoneyValue loadDeprecated(@Nonnull CompoundTag tag) {
        if (tag.contains("Free", 1)) {
            return MoneyValue.free();
        }
        if (tag.contains("Value", 9)) {
            ListTag valueList = tag.getList("Value", 10);
            if (valueList.isEmpty()) {
                return MoneyValue.empty();
            }
            ArrayList<CoinValuePair> pairList = new ArrayList<CoinValuePair>();
            ChainData chainData = null;
            for (int i = 0; i < valueList.size(); ++i) {
                CompoundTag entry = valueList.getCompound(i);
                Item coin = (Item)BuiltInRegistries.ITEM.get(VersionUtil.parseResource(entry.getString("Coin")));
                int amount = entry.getInt("Amount");
                if (chainData == null) {
                    chainData = CoinAPI.getApi().ChainDataOfCoin(coin);
                }
                if (chainData == null || !chainData.containsEntry(coin)) continue;
                pairList.add(new CoinValuePair(coin, amount));
            }
            if (chainData != null) {
                return CoinValue.create(chainData.chain, pairList);
            }
        }
        return MoneyValue.empty();
    }

    @Nullable
    public static MoneyValue loadDeprecated(@Nonnull CompoundTag parentTag, @Nonnull String key) {
        if (parentTag.contains(key, 3)) {
            return CoinValue.fromNumber("main", (long)parentTag.getInt(key));
        }
        if (parentTag.contains(key, 9)) {
            ListTag listNBT = parentTag.getList(key, 10);
            if (listNBT.isEmpty()) {
                return MoneyValue.empty();
            }
            ArrayList<CoinValuePair> pairList = new ArrayList<CoinValuePair>();
            ChainData chainData = null;
            for (int i = 0; i < listNBT.size(); ++i) {
                CompoundTag thisCompound = listNBT.getCompound(i);
                Item coin = (Item)BuiltInRegistries.ITEM.get(VersionUtil.parseResource(thisCompound.getString("id")));
                int amount = thisCompound.getInt("amount");
                if (chainData == null) {
                    chainData = CoinAPI.getApi().ChainDataOfCoin(coin);
                }
                if (chainData == null || !chainData.containsEntry(coin)) continue;
                pairList.add(new CoinValuePair(coin, amount));
            }
            if (chainData != null) {
                return CoinValue.create(chainData.chain, pairList);
            }
        } else if (parentTag.contains(key, 1) && parentTag.getBoolean(key)) {
            return MoneyValue.free();
        }
        return MoneyValue.empty();
    }

    public static MoneyValue fromNumber(@Nonnull String chain, long valueNumber) {
        return CoinValue.fromNumber(CoinAPI.getApi().ChainData(chain), valueNumber);
    }

    public static MoneyValue fromNumber(ChainData chainData, long valueNumber) {
        if (valueNumber <= 0L) {
            return MoneyValue.empty();
        }
        if (chainData == null) {
            return MoneyValue.empty();
        }
        long pendingValue = valueNumber;
        List<CoinEntry> entries = chainData.getAllEntries(false, ChainData.SORT_HIGHEST_VALUE_FIRST);
        ArrayList<CoinValuePair> pairList = new ArrayList<CoinValuePair>();
        for (CoinEntry entry : entries) {
            long entryValue = entry.getCoreValue();
            if (pendingValue < entryValue || entryValue == 0L) continue;
            long thisCount = pendingValue / entryValue;
            pendingValue %= entryValue;
            if (thisCount > 0L) {
                int intCount;
                if (thisCount >= Integer.MAX_VALUE) {
                    LightmansCurrency.LogWarning("Value count of " + new ItemStack((ItemLike)entry.getCoin()).getHoverName().getString() + " is greater than the maximum integer value!");
                    intCount = Integer.MAX_VALUE;
                } else {
                    intCount = (int)thisCount;
                }
                pairList.add(new CoinValuePair(entry.getCoin(), intCount));
            }
            if (pendingValue > 0L) continue;
            break;
        }
        return CoinValue.create(chainData.chain, pairList);
    }

    @Nonnull
    public static MoneyValue fromItemOrValue(Item coin, long value) {
        return CoinValue.fromItemOrValue(coin, 1, value);
    }

    @Nonnull
    public static MoneyValue fromItemOrValue(Item coin, int itemCount, long value) {
        ChainData chainData = CoinAPI.getApi().ChainDataOfCoin(coin);
        if (chainData != null) {
            return new CoinValue(chainData.chain, Lists.newArrayList((Object[])new CoinValuePair[]{new CoinValuePair(coin, itemCount)}));
        }
        return CoinValue.fromNumber("main", value);
    }

    @Override
    public MoneyValue addValue(@Nonnull MoneyValue addedValue) {
        if (this.sameType(addedValue)) {
            return CoinValue.fromNumber(this.chain, this.getCoreValue() + addedValue.getCoreValue());
        }
        return null;
    }

    @Override
    public boolean containsValue(@Nonnull MoneyValue queryValue) {
        if (this.sameType(queryValue)) {
            return this.getCoreValue() >= queryValue.getCoreValue();
        }
        return false;
    }

    @Override
    public MoneyValue subtractValue(@Nonnull MoneyValue removedValue) {
        if (this.sameType(removedValue) && this.containsValue(removedValue)) {
            return CoinValue.fromNumber(this.chain, this.getCoreValue() - removedValue.getCoreValue());
        }
        return null;
    }

    @Override
    @Nonnull
    public MoneyValue multiplyValue(double multiplier) {
        BigDecimal value = BigDecimal.valueOf(this.getCoreValue());
        BigDecimal result = value.multiply(BigDecimal.valueOf(multiplier));
        if (result.compareTo(BigDecimal.valueOf(0.5)) < 0) {
            return MoneyValue.empty();
        }
        if (result.compareTo(BigDecimal.valueOf(Long.MAX_VALUE)) > 0) {
            return CoinValue.fromNumber(this.chain, Long.MAX_VALUE);
        }
        long rounding = 0L;
        if (result.remainder(BigDecimal.ONE).compareTo(BigDecimal.valueOf(0.5)) >= 0) {
            rounding = 1L;
        }
        return CoinValue.fromNumber(this.chain, result.longValue() + rounding);
    }

    @Override
    public MoneyValue percentageOfValue(int percentage, boolean roundUp) {
        long partial;
        if (percentage == 100) {
            return this;
        }
        if (percentage == 0) {
            return MoneyValue.free();
        }
        long value = this.getCoreValue();
        long newValue = value * (long)MathUtil.clamp(percentage, 0, 1000) / 100L;
        if (roundUp && (partial = value * (long)MathUtil.clamp(percentage, 0, 1000) % 100L) > 0L) {
            ++newValue;
        }
        if (newValue == 0L) {
            return MoneyValue.free();
        }
        return CoinValue.fromNumber(this.chain, newValue);
    }

    @Override
    @Nonnull
    public MoneyValue getSmallestValue() {
        return CoinValue.fromNumber(this.chain, 1L);
    }

    @Override
    @Nonnull
    public MoneyValue fromCoreValue(long value) {
        return CoinValue.fromNumber(this.chain, value);
    }

    @Override
    @Nonnull
    public List<ItemStack> onBlockBroken(@Nonnull OwnerData owner) {
        return this.getAsSeperatedItemList();
    }

    private static List<CoinValuePair> roundValue(@Nonnull String chain, @Nonnull List<CoinValuePair> list) {
        ChainData chainData = CoinAPI.getApi().ChainData(chain);
        if (chainData == null) {
            return list;
        }
        while (CoinValue.needsRounding(chainData, list)) {
            for (int i = 0; i < list.size(); ++i) {
                if (!CoinValue.needsRounding(chainData, list, i)) continue;
                CoinValuePair pair = list.get(i);
                CoinEntry entry = chainData.findEntry(pair.coin);
                Pair<CoinEntry, Integer> exchange = entry.getUpperExchange();
                int largeAmount = 0;
                while (pair.amount >= (Integer)exchange.getSecond()) {
                    ++largeAmount;
                    pair = pair.removeAmount((Integer)exchange.getSecond());
                }
                if (pair.amount == 0) {
                    list.remove(i);
                    --i;
                } else {
                    list.set(i, pair);
                }
                for (int j = 0; j < list.size(); ++j) {
                    if (!((CoinEntry)exchange.getFirst()).matches(list.get((int)j).coin)) continue;
                    list.set(j, list.get(j).addAmount(largeAmount));
                    largeAmount = 0;
                }
                if (largeAmount <= 0) continue;
                list.add(new CoinValuePair(((CoinEntry)exchange.getFirst()).getCoin(), largeAmount));
            }
        }
        return CoinValue.sortValue(chainData, list);
    }

    private static List<CoinValuePair> sortValue(@Nonnull ChainData chainData, List<CoinValuePair> list) {
        ArrayList<CoinValuePair> newList = new ArrayList<CoinValuePair>();
        while (!list.isEmpty()) {
            long largestValue = chainData.getCoreValue(list.getFirst().coin);
            int largestIndex = 0;
            for (int i = 1; i < list.size(); ++i) {
                long thisValue = chainData.getCoreValue(list.get((int)i).coin);
                if (thisValue <= largestValue) continue;
                largestIndex = i;
                largestValue = thisValue;
            }
            newList.add(list.get(largestIndex));
            list.remove(largestIndex);
        }
        return newList;
    }

    private static boolean needsRounding(@Nonnull ChainData chainData, @Nonnull List<CoinValuePair> list) {
        for (int i = 0; i < list.size(); ++i) {
            if (!CoinValue.needsRounding(chainData, list, i)) continue;
            return true;
        }
        return false;
    }

    private static boolean needsRounding(@Nonnull ChainData chainData, @Nonnull List<CoinValuePair> list, int index) {
        CoinValuePair pair = list.get(index);
        Pair<CoinEntry, Integer> exchange = chainData.getUpperExchange(pair.coin);
        if (exchange != null) {
            return pair.amount >= (Integer)exchange.getSecond();
        }
        return false;
    }

    public List<CoinValuePair> getEntries() {
        return this.coinValues;
    }

    @Override
    @Nonnull
    public List<ItemStack> getAsItemList() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (CoinValuePair entry : this.coinValues) {
            items.add(new ItemStack((ItemLike)entry.coin, entry.amount));
        }
        return items;
    }

    public long getEntry(Item coinItem) {
        for (CoinValuePair pair : this.coinValues) {
            if (pair.coin != coinItem) continue;
            return pair.amount;
        }
        return 0L;
    }

    @Override
    @Nonnull
    public MutableComponent getText(@Nonnull MutableComponent emptyText) {
        ChainData chainData = CoinAPI.getApi().ChainData(this.chain);
        if (chainData == null) {
            return EasyText.literal("ERROR");
        }
        return chainData.formatValue(this, emptyText);
    }

    @Override
    public long getCoreValue() {
        ChainData chainData = CoinAPI.getApi().ChainData(this.chain);
        if (chainData == null) {
            return 0L;
        }
        long value = 0L;
        for (CoinValuePair pricePair : this.coinValues) {
            value += chainData.getCoreValue(pricePair.coin) * (long)pricePair.amount;
        }
        return Math.max(0L, value);
    }

    @Override
    protected void writeAdditionalToJson(@Nonnull JsonObject json) {
        JsonArray array = new JsonArray();
        for (CoinValuePair pair : this.coinValues) {
            array.add((JsonElement)pair.toJson());
        }
        json.add("Value", (JsonElement)array);
        json.addProperty("Chain", this.chain);
    }

    public static MoneyValue loadCoinValue(@Nonnull JsonObject json) throws JsonSyntaxException, ResourceLocationException {
        String chain = GsonHelper.getAsString((JsonObject)json, (String)"Chain");
        ChainData data = CoinAPI.getApi().ChainData(chain);
        if (data == null) {
            throw new JsonSyntaxException("No " + chain + " chain has been registered!");
        }
        ArrayList<CoinValuePair> valuePairs = new ArrayList<CoinValuePair>();
        JsonArray entryArray = GsonHelper.getAsJsonArray((JsonObject)json, (String)"Value");
        for (int i = 0; i < entryArray.size(); ++i) {
            try {
                valuePairs.add(CoinValuePair.fromJson(data, GsonHelper.convertToJsonObject((JsonElement)entryArray.get(i), (String)("Value[" + i + "]"))));
                continue;
            }
            catch (JsonSyntaxException | ResourceLocationException e) {
                LightmansCurrency.LogError("Error parsing Coin Value entry #" + (i + 1) + "!", e);
            }
        }
        if (valuePairs.isEmpty()) {
            throw new JsonSyntaxException("Coin Value entry has no valid coin/count entries to parse.");
        }
        return CoinValue.create(chain, valuePairs);
    }

    public static MoneyValue loadDeprecated(JsonElement json) throws JsonSyntaxException, ResourceLocationException {
        if (json.isJsonPrimitive()) {
            JsonPrimitive primitive = json.getAsJsonPrimitive();
            if (primitive.isNumber()) {
                return CoinValue.fromNumber("main", primitive.getAsNumber().longValue());
            }
            if (primitive.isBoolean() && primitive.getAsBoolean()) {
                return MoneyValue.empty();
            }
            if (primitive.isString()) {
                double displayValue = Double.parseDouble(primitive.getAsString());
                ChainData mainChain = CoinAPI.getApi().ChainData("main");
                if (mainChain != null) {
                    return mainChain.getDisplayData().parseDisplayInput(displayValue);
                }
            }
        } else {
            if (json.isJsonArray()) {
                JsonArray list = json.getAsJsonArray();
                ArrayList<CoinValuePair> valuePairs = new ArrayList<CoinValuePair>();
                ChainData chainData = null;
                for (int i = 0; i < list.size(); ++i) {
                    try {
                        int quantity;
                        JsonObject coinData = list.get(i).getAsJsonObject();
                        Item coin = (Item)BuiltInRegistries.ITEM.get(VersionUtil.parseResource(GsonHelper.getAsString((JsonObject)coinData, (String)"Coin")));
                        if (chainData == null) {
                            chainData = CoinAPI.getApi().ChainDataOfCoin(coin);
                        }
                        if ((quantity = GsonHelper.getAsInt((JsonObject)coinData, (String)"Count", (int)1)) <= 0) {
                            throw new JsonSyntaxException("Count was less than 1");
                        }
                        if (chainData == null) {
                            throw new JsonSyntaxException("Coin Item was not a valid coin!");
                        }
                        if (chainData.findEntry(coin) == null) {
                            throw new JsonSyntaxException("Coin Item is not a valid coin, or is on a different chain from the rest of the value!");
                        }
                        if (chainData.findEntry(coin).isSideChain()) {
                            throw new JsonSyntaxException("Coin Item is from a side-chain, and thus cannot be used for value storage!");
                        }
                        valuePairs.add(new CoinValuePair(coin, quantity));
                        continue;
                    }
                    catch (JsonSyntaxException | ResourceLocationException e) {
                        LightmansCurrency.LogError("Error parsing CoinValue entry #" + (i + 1), e);
                    }
                }
                if (valuePairs.isEmpty() || chainData == null) {
                    throw new JsonSyntaxException("Coin Value entry has no valid coin/count entries to parse.");
                }
                return CoinValue.create(chainData.chain, valuePairs);
            }
            if (json.isJsonObject()) {
                JsonPrimitive f2;
                JsonElement f;
                JsonObject j = json.getAsJsonObject();
                if (j.has("Free") && (f = j.get("Free")).isJsonPrimitive() && (f2 = f.getAsJsonPrimitive()).isBoolean() && f2.getAsBoolean()) {
                    return MoneyValue.free();
                }
                if (j.has("Value")) {
                    JsonArray valueList = j.get("Value").getAsJsonArray();
                    ChainData chainData = null;
                    ArrayList<CoinValuePair> pairs = new ArrayList<CoinValuePair>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        try {
                            int quantity;
                            JsonObject coinData = valueList.get(i).getAsJsonObject();
                            Item coin = (Item)BuiltInRegistries.ITEM.get(VersionUtil.parseResource(GsonHelper.getAsString((JsonObject)coinData, (String)"Coin")));
                            if (chainData == null) {
                                chainData = CoinAPI.getApi().ChainDataOfCoin(coin);
                            }
                            if ((quantity = GsonHelper.getAsInt((JsonObject)coinData, (String)"Count", (int)1)) <= 0) {
                                throw new JsonSyntaxException("Count was less than 1");
                            }
                            if (chainData == null) {
                                throw new JsonSyntaxException("Coin Item was not a valid coin!");
                            }
                            if (chainData.findEntry(coin) == null) {
                                throw new JsonSyntaxException("Coin Item is not a valid coin, or is on a different chain from the rest of the value!");
                            }
                            if (chainData.findEntry(coin).isSideChain()) {
                                throw new JsonSyntaxException("Coin Item is from a side-chain, and thus cannot be used for value storage!");
                            }
                            pairs.add(new CoinValuePair(coin, quantity));
                            continue;
                        }
                        catch (JsonSyntaxException | ResourceLocationException e) {
                            LightmansCurrency.LogError("Error parsing CoinValue entry #" + (i + 1), e);
                        }
                    }
                    if (pairs.isEmpty() || chainData == null) {
                        throw new JsonSyntaxException("Coin Value entry has no valid coin/count entries to parse.");
                    }
                    return CoinValue.create(chainData.chain, pairs);
                }
            }
        }
        throw new JsonSyntaxException("Coin Value entry input is not a valid Json Element.");
    }

    @Override
    @Nonnull
    public DisplayEntry getDisplayEntry(@Nullable List<Component> additionalTooltips, boolean tooltipOverride) {
        return new CoinPriceEntry(this, additionalTooltips, tooltipOverride);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (CoinValuePair pair : this.coinValues) {
            if (!sb.isEmpty()) {
                sb.append(',');
            }
            sb.append(pair.amount).append('x').append(BuiltInRegistries.ITEM.getKey((Object)pair.coin));
        }
        return "CoinValue:" + String.valueOf(sb);
    }
}

