/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.ownership.builtin;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.ownership.Owner;
import io.github.lightman314.lightmanscurrency.api.ownership.OwnerType;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class FakeOwner
extends Owner {
    public static final OwnerType TYPE = OwnerType.create(VersionUtil.lcResource("fake"), (tag, lookup) -> FakeOwner.of(Component.Serializer.fromJson((String)tag.getString("Name"), (HolderLookup.Provider)lookup)));
    private final MutableComponent name;

    private FakeOwner(@Nonnull MutableComponent name) {
        this.name = name;
    }

    @Nonnull
    public static FakeOwner of(@Nonnull String name) {
        return FakeOwner.of(EasyText.literal(name));
    }

    @Nonnull
    public static FakeOwner of(@Nonnull MutableComponent name) {
        return new FakeOwner(name);
    }

    @Override
    @Nonnull
    public MutableComponent getName() {
        return this.name.copy();
    }

    @Override
    @Nonnull
    public MutableComponent getCommandLabel() {
        return LCText.COMMAND_LCADMIN_DATA_OWNER_CUSTOM.get(this.getName());
    }

    @Override
    public boolean stillValid() {
        return true;
    }

    @Override
    public boolean alwaysValid() {
        return true;
    }

    @Override
    public boolean isOnline() {
        return false;
    }

    @Override
    public boolean isAdmin(@Nonnull PlayerReference player) {
        return false;
    }

    @Override
    public boolean isMember(@Nonnull PlayerReference player) {
        return false;
    }

    @Override
    @Nonnull
    public PlayerReference asPlayerReference() {
        return PlayerReference.NULL;
    }

    @Override
    @Nullable
    public BankReference asBankReference() {
        return null;
    }

    @Override
    public void pushNotification(@Nonnull Supplier<? extends Notification> notificationSource, int notificationLevel, boolean sendToChat) {
    }

    @Override
    @Nonnull
    public OwnerType getType() {
        return TYPE;
    }

    @Override
    protected void saveAdditional(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider lookup) {
        tag.putString("Name", Component.Serializer.toJson((Component)this.name, (HolderLookup.Provider)lookup));
    }

    @Override
    @Nonnull
    public Owner copy() {
        return new FakeOwner(this.name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean matches(@Nonnull Owner other) {
        if (!(other instanceof FakeOwner)) return false;
        FakeOwner fo = (FakeOwner)other;
        if (!fo.name.equals((Object)this.name)) return false;
        return true;
    }
}

