/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.trader_interface.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.trader_interface.blockentity.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.api.trader_interface.data.TradeReference;
import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TraderInterfaceTargets {
    private final TraderInterfaceBlockEntity parent;
    private final List<Long> traders = new ArrayList<Long>();
    private final List<TradeReference> trades = new ArrayList<TradeReference>();

    public TraderInterfaceTargets(TraderInterfaceBlockEntity parent) {
        this.parent = parent;
    }

    @Nullable
    public TradeData loadTrade(CompoundTag tag, HolderLookup.Provider lookup) {
        return this.parent.deserializeTrade(tag, lookup);
    }

    public CompoundTag save(HolderLookup.Provider lookup) {
        CompoundTag tag = new CompoundTag();
        tag.putLongArray("Traders", this.traders);
        ListTag tradeList = new ListTag();
        for (TradeReference trade : this.trades) {
            tradeList.add((Object)trade.save(lookup));
        }
        tag.put("Trades", (Tag)tradeList);
        return tag;
    }

    public void load(CompoundTag tag, HolderLookup.Provider lookup) {
        if (tag.contains("Traders") && tag.contains("Trades")) {
            this.traders.clear();
            this.trades.clear();
            for (long id : tag.getLongArray("Traders")) {
                this.traders.add(id);
            }
            ListTag tradeList = tag.getList("Trades", 10);
            for (int i = 0; i < tradeList.size(); ++i) {
                TradeReference trade = TradeReference.load(this, tradeList.getCompound(i), lookup);
                if (trade != null) {
                    this.trades.add(trade);
                    continue;
                }
                LightmansCurrency.LogDebug("Failed to load a Trade Reference\n" + tradeList.getCompound(i).getAsString());
            }
        }
    }

    public void loadFromOldData(CompoundTag tag, HolderLookup.Provider lookup) {
        this.traders.clear();
        this.trades.clear();
        this.traders.add(tag.getLong("TraderID"));
        int tradeIndex = -1;
        TradeData trade = null;
        if (tag.contains("TradeIndex")) {
            tradeIndex = tag.getInt("TradeIndex");
        } else if (tag.contains("tradeIndex")) {
            tradeIndex = tag.getInt("tradeIndex");
        }
        if (tag.contains("Trade")) {
            trade = this.loadTrade(tag.getCompound("Trade"), lookup);
        } else if (tag.contains("trade")) {
            trade = this.loadTrade(tag.getCompound("trade"), lookup);
        }
        if (tradeIndex >= 0 && trade != null) {
            this.trades.add(TradeReference.of(this, tradeIndex, trade));
        }
    }

    @Nullable
    public TraderData getTrader() {
        if (!this.traders.isEmpty()) {
            return TraderAPI.getApi().GetTrader(this.parent.isClient(), (long)this.traders.getFirst());
        }
        return null;
    }

    public int getTraderCount() {
        return this.traders.size();
    }

    public List<TraderData> getTraders() {
        if (this.parent.getInteractionType().targetsTraders()) {
            ArrayList<TraderData> list = new ArrayList<TraderData>();
            for (long traderID : this.traders) {
                TraderData trader = TraderAPI.getApi().GetTrader(this.parent.isClient(), traderID);
                if (trader == null) continue;
                list.add(trader);
            }
            return list;
        }
        return Lists.newArrayList((Object[])new TraderData[]{this.getTrader()});
    }

    public TradeData copyTrade(TradeData trade) {
        if (trade == null) {
            return null;
        }
        return this.loadTrade(trade.getAsNBT((HolderLookup.Provider)this.parent.registryAccess()), (HolderLookup.Provider)this.parent.registryAccess());
    }

    public List<TradeReference> getTradeReferences() {
        return ImmutableList.copyOf(this.trades);
    }

    public boolean toggleTrader(long traderID) {
        if (this.traders.contains(traderID)) {
            this.traders.remove(traderID);
            if (this.traders.isEmpty()) {
                this.trades.clear();
            }
            return true;
        }
        if (this.parent.getInteractionType().trades() && !this.traders.isEmpty()) {
            return false;
        }
        if (this.traders.size() >= this.parent.getSelectableCount()) {
            return false;
        }
        this.traders.add(traderID);
        return true;
    }

    public boolean tick(Predicate<TraderData> allowedTraders) {
        boolean changed;
        block6: {
            int selectableCount;
            block5: {
                changed = false;
                selectableCount = Math.max(1, this.parent.getSelectableCount());
                for (int i = 0; i < this.traders.size(); ++i) {
                    TraderData trader = TraderAPI.getApi().GetTrader(this.parent.isClient(), (long)this.traders.get(i));
                    if (trader != null && allowedTraders.test(trader)) continue;
                    this.traders.remove(i--);
                }
                if (!this.parent.getInteractionType().trades()) break block5;
                if (this.traders.size() > 1) {
                    long first = this.traders.getFirst();
                    this.traders.clear();
                    this.traders.add(first);
                    changed = true;
                }
                while (this.trades.size() > selectableCount) {
                    this.trades.removeLast();
                    changed = true;
                }
                break block6;
            }
            if (!this.parent.getInteractionType().targetsTraders()) break block6;
            if (!this.trades.isEmpty()) {
                this.trades.clear();
                changed = true;
            }
            while (this.traders.size() > selectableCount) {
                this.traders.removeLast();
                changed = true;
            }
        }
        return changed;
    }

    public boolean toggleTrade(int tradeIndex) {
        if (this.parent.getInteractionType().targetsTraders()) {
            return false;
        }
        for (int i = 0; i < this.trades.size(); ++i) {
            TradeReference trade = this.trades.get(i);
            if (trade.getTradeIndex() != tradeIndex) continue;
            this.trades.remove(i);
            return true;
        }
        if (this.trades.size() >= this.parent.getSelectableCount()) {
            return false;
        }
        TradeReference trade = TradeReference.of(this, tradeIndex);
        if (trade != null) {
            this.trades.add(trade);
            return true;
        }
        return false;
    }
}

