/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.traders.blocks;

import io.github.lightman314.lightmanscurrency.api.misc.blockentity.IOwnableBlockEntity;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.ICapabilityBlock;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IOwnableBlock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public interface ITraderBlock
extends IOwnableBlock,
ICapabilityBlock {
    @Nullable
    default public BlockEntity getBlockEntity(@Nonnull BlockState state, @Nonnull LevelAccessor level, @Nonnull BlockPos pos) {
        return level.getBlockEntity(this.getCapabilityBlockPos(state, level, pos));
    }

    @Override
    default public boolean canBreak(@Nonnull Player player, @Nonnull LevelAccessor level, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        BlockEntity blockEntity = this.getBlockEntity(state, level, pos);
        if (blockEntity instanceof IOwnableBlockEntity) {
            IOwnableBlockEntity ownableBlockEntity = (IOwnableBlockEntity)blockEntity;
            return ownableBlockEntity.canBreak(player);
        }
        return true;
    }

    default public ItemStack getDropBlockItem(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new ItemStack((ItemLike)state.getBlock());
    }
}

