/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.traders.blocks;

import io.github.lightman314.lightmanscurrency.api.misc.blocks.ITallBlock;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.LazyShapes;
import io.github.lightman314.lightmanscurrency.api.traders.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.api.traders.blocks.TraderBlockRotatable;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class TraderBlockTallRotatable
extends TraderBlockRotatable
implements ITallBlock {
    protected static final BooleanProperty ISBOTTOM = BlockStateProperties.BOTTOM;
    private final BiFunction<Direction, Boolean, VoxelShape> shape;

    protected TraderBlockTallRotatable(BlockBehaviour.Properties properties) {
        this(properties, LazyShapes.TALL_BOX_SHAPE);
    }

    protected TraderBlockTallRotatable(BlockBehaviour.Properties properties, VoxelShape shape) {
        this(properties, LazyShapes.lazyTallSingleShape(shape));
    }

    protected TraderBlockTallRotatable(BlockBehaviour.Properties properties, BiFunction<Direction, Boolean, VoxelShape> shape) {
        super(properties.pushReaction(PushReaction.BLOCK));
        this.shape = shape;
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)ISBOTTOM, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected boolean shouldMakeTrader(BlockState state) {
        return this.getIsBottom(state);
    }

    @Override
    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return this.shape.apply(this.getFacing(state), this.getIsBottom(state));
    }

    @Override
    protected void createBlockStateDefinition(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ISBOTTOM});
    }

    @Override
    public BlockState getStateForPlacement(@Nonnull BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)ISBOTTOM, (Comparable)Boolean.valueOf(true));
    }

    @Override
    public void setPlacedBy(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity player, @Nonnull ItemStack stack) {
        if (this.isReplaceable(level, pos.above())) {
            level.setBlockAndUpdate(pos.above(), (BlockState)((BlockState)this.defaultBlockState().setValue((Property)ISBOTTOM, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING))));
        } else {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof TraderBlockEntity) {
                TraderBlockEntity be = (TraderBlockEntity)blockEntity;
                be.flagAsLegitBreak();
            }
            level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            if (player instanceof Player) {
                Player p = (Player)player;
                ItemStack giveStack = stack.copy();
                giveStack.setCount(1);
                InventoryUtil.safeGiveToPlayer(p.getInventory(), giveStack);
            }
        }
        this.setPlacedByBase(level, pos, state, player, stack);
    }

    @Deprecated
    public boolean getReplacable(Level level, BlockPos pos, BlockState ignored, LivingEntity player, ItemStack stack) {
        return level.getBlockState(pos).getBlock() == Blocks.AIR;
    }

    @Override
    @Nonnull
    public BlockState playerWillDestroy(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        TraderBlockEntity trader;
        this.playerWillDestroyBase(level, pos, state, player);
        BlockEntity blockEntity = this.getBlockEntity(state, (LevelAccessor)level, pos);
        if (blockEntity instanceof TraderBlockEntity && !(trader = (TraderBlockEntity)blockEntity).canBreak(player)) {
            return state;
        }
        this.setAir(level, this.getOtherHeight(pos, state), player);
        return state;
    }

    @Override
    public void removeOtherBlocks(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockPos pos) {
        this.setAir(level, this.getOtherHeight(pos, state), null);
    }
}

