/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.traders.discount_codes;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LCTags;
import io.github.lightman314.lightmanscurrency.api.traders.discount_codes.IDiscountCodeSource;
import io.github.lightman314.lightmanscurrency.common.core.ModDataComponents;
import io.github.lightman314.lightmanscurrency.common.items.CouponItem;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CouponSource
implements IDiscountCodeSource {
    private final IItemHandler container;
    private final Consumer<ItemStack> overflowHandler;

    public CouponSource(Container container, Consumer<ItemStack> overflowHandler) {
        this((IItemHandler)new InvWrapper(container), overflowHandler);
    }

    public CouponSource(IItemHandler container, Consumer<ItemStack> overflowHandler) {
        this.container = container;
        this.overflowHandler = overflowHandler;
    }

    @Override
    public boolean containsCode(String code) {
        int hash = code.hashCode();
        for (int i = 0; i < this.container.getSlots(); ++i) {
            if (!this.isCode(hash, this.container.getStackInSlot(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Integer> getDiscountCodes() {
        HashSet<Integer> temp = new HashSet<Integer>();
        for (int i = 0; i < this.container.getSlots(); ++i) {
            ItemStack item = this.container.getStackInSlot(i);
            if (!InventoryUtil.ItemHasTag(item, LCTags.Items.COUPONS)) continue;
            temp.add(CouponItem.GetCouponCode(item));
        }
        return temp;
    }

    protected boolean isCode(int code, ItemStack item) {
        if (item.isEmpty()) {
            return false;
        }
        if (InventoryUtil.ItemHasTag(item, LCTags.Items.COUPONS)) {
            return code == CouponItem.GetCouponCode(item);
        }
        return false;
    }

    @Override
    public boolean consumeCode(String code) {
        int hash = code.hashCode();
        ArrayList<Pair> targets = new ArrayList<Pair>();
        for (int i = 0; i < this.container.getSlots(); ++i) {
            int c;
            ItemStack item = this.container.getStackInSlot(i).copy();
            if (!InventoryUtil.ItemHasTag(item, LCTags.Items.COUPONS) || hash != (c = CouponItem.GetCouponCode(item))) continue;
            int uses = TicketItem.getUseCount(item);
            if (uses < 0) {
                return true;
            }
            targets.add(Pair.of((Object)i, (Object)((Integer)item.get(ModDataComponents.TICKET_USES))));
        }
        targets.sort(Comparator.comparingInt(Pair::getSecond));
        for (Pair pair : targets) {
            int target = (Integer)pair.getFirst();
            ItemStack extracted = this.container.extractItem(target, Integer.MAX_VALUE, true);
            if (extracted.isEmpty() || !this.isCode(hash, extracted) || (extracted = this.container.extractItem(target, 1, false)).isEmpty()) continue;
            if (!this.isCode(hash, extracted)) {
                this.quickInsert(target, extracted);
                continue;
            }
            int uses = TicketItem.getUseCount(extracted);
            if (uses > 1) {
                TicketItem.setUseCount(extracted, uses - 1);
                this.quickInsert(target, extracted);
            }
            return true;
        }
        return false;
    }

    private void quickInsert(int preferredSlot, ItemStack stack) {
        ItemStack remainder = this.container.insertItem(preferredSlot, stack, false);
        if (!remainder.isEmpty() && !(remainder = ItemHandlerHelper.insertItem((IItemHandler)this.container, (ItemStack)remainder, (boolean)false)).isEmpty()) {
            this.overflowHandler.accept(remainder);
        }
    }
}

