/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.traders.trade.comparison;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

public class ProductComparisonResult {
    private final boolean sameProduct;
    private final boolean sameNBT;
    private final int quantityDifference;

    public boolean Identical() {
        return this.SameProductType() && this.SameProductNBT() && this.SameProductQuantity();
    }

    public boolean SameProductType() {
        return this.sameProduct;
    }

    public boolean SameProductNBT() {
        return this.sameNBT;
    }

    public boolean SameProductQuantity() {
        return this.quantityDifference == 0;
    }

    public int ProductQuantityDifference() {
        return this.quantityDifference;
    }

    private ProductComparisonResult(boolean sameProduct, boolean sameNBT, int quantityDifference) {
        this.sameProduct = sameProduct;
        this.sameNBT = sameNBT;
        this.quantityDifference = quantityDifference;
    }

    public static ProductComparisonResult CompareItem(ItemStack trueItem, ItemStack expectedItem) {
        return ProductComparisonResult.CompareItem(trueItem, expectedItem, true);
    }

    public static ProductComparisonResult CompareItem(ItemStack trueItem, ItemStack expectedItem, boolean checkNBT) {
        boolean isItemEqual = trueItem.getItem() == expectedItem.getItem();
        boolean isTagEqual = checkNBT ? trueItem.getComponents().equals((Object)expectedItem.getComponents()) : true;
        int quantityDifference = trueItem.getCount() - expectedItem.getCount();
        return new ProductComparisonResult(isItemEqual, isTagEqual, quantityDifference);
    }

    public static ProductComparisonResult CreateRaw(boolean sameProduct, boolean sameNBT, int quantityDifference) {
        return new ProductComparisonResult(sameProduct, sameNBT, quantityDifference);
    }

    public static List<ProductComparisonResult> CompareTwoItems(ItemStack true1, ItemStack true2, ItemStack expected1, ItemStack expected2) {
        return ProductComparisonResult.CompareTwoItems(true1, true2, expected1, expected2, true);
    }

    public static List<ProductComparisonResult> CompareTwoItems(ItemStack true1, ItemStack true2, ItemStack expected1, ItemStack expected2, boolean checkNBT) {
        boolean flipMatch;
        ArrayList<ProductComparisonResult> results = new ArrayList<ProductComparisonResult>();
        boolean bl = flipMatch = true1.getItem() == expected2.getItem() && true2.getItem() == expected1.getItem() && true1.getItem() != true2.getItem() && expected1.getItem() != expected2.getItem();
        if (flipMatch) {
            results.add(ProductComparisonResult.CompareItem(true1, expected2, checkNBT));
            results.add(ProductComparisonResult.CompareItem(true2, expected1));
        } else {
            results.add(ProductComparisonResult.CompareItem(true1, expected1));
            results.add(ProductComparisonResult.CompareItem(true2, expected2));
        }
        return results;
    }

    public static ProductComparisonResult CompareFluid(FluidStack trueFluid, FluidStack expectedFluid) {
        boolean isFluidEqual = trueFluid.getFluid() == expectedFluid.getFluid();
        boolean isTagEqual = trueFluid.getComponents().equals((Object)expectedFluid.getComponents());
        int quantityDifference = trueFluid.getAmount() - expectedFluid.getAmount();
        return new ProductComparisonResult(isFluidEqual, isTagEqual, quantityDifference);
    }

    public static ProductComparisonResult CompareEnergy(int original, int query) {
        return new ProductComparisonResult(true, true, original - query);
    }
}

