/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.variants;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.variants.block.IVariantBlock;
import io.github.lightman314.lightmanscurrency.api.variants.block.VariantBlockWrapper;
import io.github.lightman314.lightmanscurrency.api.variants.item.IVariantItem;
import io.github.lightman314.lightmanscurrency.api.variants.item.VariantItemWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

@ParametersAreNonnullByDefault
public class VariantProvider<T, V> {
    private static final VariantProvider<Block, IVariantBlock> BLOCK_PROVIDER = new VariantProvider(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).getKey(arg_0));
    private static final VariantProvider<Item, IVariantItem> ITEM_PROVIDER;
    private final List<Function<T, V>> providers = new ArrayList<Function<T, V>>();
    private final Function<T, ResourceLocation> keyGetter;
    private final List<ResourceLocation> nullValues = new ArrayList<ResourceLocation>();
    private final Map<ResourceLocation, V> resultCache = new HashMap<ResourceLocation, V>();

    private void addProvider(Function<T, V> provider) {
        if (!this.resultCache.isEmpty() || !this.nullValues.isEmpty()) {
            LightmansCurrency.LogWarning("Variant Provider registered after results have already been cached!", new Throwable());
        }
        this.providers.add(Objects.requireNonNull(provider));
    }

    public VariantProvider(Function<T, ResourceLocation> keyGetter) {
        this.keyGetter = keyGetter;
    }

    @Nullable
    public final V get(T value) {
        ResourceLocation key = this.keyGetter.apply(value);
        if (this.resultCache.containsKey(key)) {
            return this.resultCache.get(key);
        }
        if (this.nullValues.contains(key)) {
            return null;
        }
        for (Function<T, V> provider : this.providers) {
            V result = provider.apply(value);
            if (result == null) continue;
            this.resultCache.put(key, result);
            return result;
        }
        this.nullValues.add(key);
        return null;
    }

    public static void registerVariantBlock(VariantBlockWrapper variant) {
        BLOCK_PROVIDER.addProvider(block -> {
            if (block == variant.getBlock()) {
                return variant;
            }
            return null;
        });
    }

    public static void registerVariantBlock(Function<Block, IVariantBlock> provider) {
        BLOCK_PROVIDER.addProvider(Objects.requireNonNull(provider));
    }

    @SafeVarargs
    public static void registerBasicVariantItem(Supplier<Item> ... items) {
        for (Supplier<Item> sup : items) {
            VariantProvider.registerVariantItem(VariantItemWrapper.simple(sup));
        }
    }

    public static void registerBasicVariantItem(Item ... items) {
        for (Item i : items) {
            VariantProvider.registerVariantItem(VariantItemWrapper.simple(i));
        }
    }

    public static void registerVariantItem(VariantItemWrapper variant) {
        ITEM_PROVIDER.addProvider(item -> {
            if (item == variant.getItem()) {
                return variant;
            }
            return null;
        });
    }

    public static void registerVariantItem(Function<Item, IVariantItem> provider) {
        ITEM_PROVIDER.addProvider(Objects.requireNonNull(provider));
    }

    @Nullable
    public static IVariantBlock getVariantBlock(BlockState state) {
        return VariantProvider.getVariantBlock(state.getBlock());
    }

    @Nullable
    public static IVariantBlock getVariantBlock(Block block) {
        return BLOCK_PROVIDER.get(block);
    }

    @Nullable
    public static IVariantItem getVariantItem(ItemStack stack) {
        return VariantProvider.getVariantItem(stack.getItem());
    }

    @Nullable
    public static IVariantItem getVariantItem(Item item) {
        return ITEM_PROVIDER.get(item);
    }

    static {
        BLOCK_PROVIDER.addProvider(b -> {
            if (b instanceof IVariantBlock) {
                IVariantBlock vb = (IVariantBlock)b;
                return vb;
            }
            return null;
        });
        ITEM_PROVIDER = new VariantProvider(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getKey(arg_0));
        ITEM_PROVIDER.addProvider(i -> {
            BlockItem bi;
            IVariantBlock block;
            if (i instanceof IVariantItem) {
                IVariantItem vi = (IVariantItem)i;
                return vi;
            }
            if (i instanceof BlockItem && (block = VariantProvider.getVariantBlock((bi = (BlockItem)i).getBlock())) != null) {
                return VariantItemWrapper.simple(i);
            }
            return null;
        });
    }
}

