/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.variants.block.block_entity;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.capability.variant.CapabilityVariantData;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.neoforge.common.extensions.ILevelExtension;

public interface IVariantDataStorage {
    @Nullable
    public ResourceLocation getCurrentVariant();

    public boolean isVariantLocked();

    default public void setVariant(@Nullable ResourceLocation variant) {
        this.setVariant(variant, this.isVariantLocked());
    }

    public void setVariant(@Nullable ResourceLocation var1, boolean var2);

    @Nullable
    public static IVariantDataStorage get(BlockGetter level, BlockPos pos) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be != null) {
            return IVariantDataStorage.get(be);
        }
        if (level instanceof ILevelExtension) {
            ILevelExtension l = (ILevelExtension)level;
            return (IVariantDataStorage)l.getCapability(CapabilityVariantData.CAPABILITY, pos);
        }
        LightmansCurrency.LogWarning("Unable to obtain the IVariantDataStorage capability as the level " + level.getClass().getName() + " is not a proper level!");
        return null;
    }

    @Nullable
    @Deprecated
    public static IVariantDataStorage get(@Nullable BlockEntity be) {
        if (be == null) {
            return null;
        }
        if (be instanceof IVariantDataStorage) {
            IVariantDataStorage result = (IVariantDataStorage)be;
            return result;
        }
        if (!be.hasLevel()) {
            return null;
        }
        return (IVariantDataStorage)be.getLevel().getCapability(CapabilityVariantData.CAPABILITY, be.getBlockPos(), null, be);
    }

    @Nullable
    public static IVariantDataStorage get(LootContext context) {
        if (context.hasParam(LootContextParams.BLOCK_ENTITY)) {
            return IVariantDataStorage.get((BlockEntity)context.getParam(LootContextParams.BLOCK_ENTITY));
        }
        if (context.hasParam(LootContextParams.ORIGIN)) {
            BlockPos pos = BlockPos.containing((Position)((Position)context.getParam(LootContextParams.ORIGIN)));
            return IVariantDataStorage.get((BlockGetter)context.getLevel(), pos);
        }
        return null;
    }
}

