/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.variants.block.builtin;

import io.github.lightman314.lightmanscurrency.api.variants.block.block_entity.IVariantDataStorage;
import io.github.lightman314.lightmanscurrency.common.core.ModAttachmentTypes;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.attachment.AttachmentSyncHandler;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;

public class VariantDataStorageAttachment
implements IVariantDataStorage {
    public static final Supplier<AttachmentType<VariantDataStorageAttachment>> TYPE = ModAttachmentTypes.VARIANT_BLOCK_DATA;
    public static final IAttachmentSerializer<CompoundTag, VariantDataStorageAttachment> SERIALIZER = new Serializer();
    public static final AttachmentSyncHandler<VariantDataStorageAttachment> SYNC_HANDLER = new SyncHandler();
    @Nullable
    private ResourceLocation variant = null;
    private boolean locked = false;
    private final IAttachmentHolder parent;

    public VariantDataStorageAttachment(IAttachmentHolder parent) {
        this.parent = parent;
    }

    @Override
    @Nullable
    public ResourceLocation getCurrentVariant() {
        return this.variant;
    }

    @Override
    public boolean isVariantLocked() {
        return this.locked;
    }

    @Override
    public void setVariant(@Nullable ResourceLocation variant, boolean locked) {
        this.variant = variant;
        this.locked = locked;
        this.parent.setData(TYPE, (Object)this);
    }

    private CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        if (this.variant != null) {
            tag.putString("Variant", this.variant.toString());
        }
        if (this.locked) {
            tag.putBoolean("Locked", true);
        }
        return tag;
    }

    private void read(CompoundTag tag) {
        this.variant = tag.contains("Variant") ? VersionUtil.parseResource(tag.getString("Variant")) : null;
        this.locked = tag.getBoolean("Locked");
    }

    private static class Serializer
    implements IAttachmentSerializer<CompoundTag, VariantDataStorageAttachment> {
        private Serializer() {
        }

        public VariantDataStorageAttachment read(IAttachmentHolder holder, CompoundTag tag, HolderLookup.Provider provider) {
            VariantDataStorageAttachment a;
            if (holder instanceof BlockEntity) {
                BlockEntity be = (BlockEntity)holder;
                a = new VariantDataStorageAttachment((IAttachmentHolder)be);
            } else {
                a = new VariantDataStorageAttachment(null);
            }
            a.read(tag);
            return a;
        }

        @Nullable
        public CompoundTag write(VariantDataStorageAttachment attachment, HolderLookup.Provider provider) {
            if (attachment.variant != null || attachment.locked) {
                return attachment.write();
            }
            return null;
        }
    }

    private static class SyncHandler
    implements AttachmentSyncHandler<VariantDataStorageAttachment> {
        private SyncHandler() {
        }

        public void write(RegistryFriendlyByteBuf buffer, VariantDataStorageAttachment data, boolean initialSync) {
            boolean hasVariant = data.variant != null;
            buffer.writeBoolean(hasVariant);
            if (hasVariant) {
                buffer.writeResourceLocation(data.variant);
            }
            buffer.writeBoolean(data.locked);
        }

        @Nullable
        public VariantDataStorageAttachment read(IAttachmentHolder holder, RegistryFriendlyByteBuf buffer, @Nullable VariantDataStorageAttachment oldData) {
            VariantDataStorageAttachment data = oldData == null ? new VariantDataStorageAttachment(holder) : oldData;
            boolean hasVariant = buffer.readBoolean();
            data.variant = hasVariant ? buffer.readResourceLocation() : null;
            data.locked = buffer.readBoolean();
            if (data.variant == null && !data.locked) {
                return null;
            }
            return data;
        }
    }
}

