/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.FixedSizeSprite;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.FlexibleSizeSprite;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.SpriteSource;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.SpriteUtil;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.builtin.NineSliceSprite;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.builtin.WidgetStateSprite;
import io.github.lightman314.lightmanscurrency.api.misc.icons.ItemIcon;
import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.terminal.TerminalSorter;
import io.github.lightman314.lightmanscurrency.api.traders.terminal.sorting.SortTypeKey;
import io.github.lightman314.lightmanscurrency.api.traders.terminal.sorting.TerminalSortType;
import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyMenuScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.NetworkTraderButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.dropdown.DropdownWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.text_inputs.TextBoxWrapper;
import io.github.lightman314.lightmanscurrency.client.util.text_inputs.TextInputUtil;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.menus.TerminalMenu;
import io.github.lightman314.lightmanscurrency.network.message.trader.CPacketOpenTrades;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class NetworkTerminalScreen
extends EasyMenuScreen<TerminalMenu>
implements IScrollable {
    private static final ResourceLocation GUI_TEXTURE = VersionUtil.lcResource("textures/gui/container/network_terminal.png");
    public static final FlexibleSizeSprite BACKGROUND_SPRITE = new NineSliceSprite(new SpriteSource(GUI_TEXTURE, 0, 0, 100, 100), 25);
    public static final FlexibleSizeSprite BUTTON_BACKGROUND_SPRITE = new NineSliceSprite(new SpriteSource(GUI_TEXTURE, 0, 100, 100, 100), 25);
    public static final FixedSizeSprite BUTTON_SAVE = WidgetStateSprite.lazyHoverable(VersionUtil.lcResource("common/widgets/button_save"), 12, 12);
    private TextBoxWrapper<String> searchField;
    private int searchWidth = 118;
    private static int scroll = 0;
    private static String lastSearch = "";
    private DropdownWidget sortSelection;
    private List<TerminalSortType> sortTypeCache;
    ScrollBarWidget scrollBar;
    private int columns;
    private int rows;
    List<NetworkTraderButton> traderButtons;
    private List<TraderData> filteredTraderList = new ArrayList<TraderData>();
    private static TerminalSortType latestSorter = null;

    private List<TraderData> traderList() {
        List<TraderData> traderList = TraderAPI.getApi().GetAllNetworkTraders(true);
        traderList.sort(TerminalSorter.getDefaultSorter(NetworkTerminalScreen.getLatestSorter()));
        return traderList;
    }

    private static TerminalSortType getLatestSorter() {
        if (latestSorter == null && (latestSorter = NetworkTerminalScreen.getConfiguredSortType()) == null) {
            latestSorter = TraderAPI.getApi().GetAllSortTypes().getFirst();
        }
        return latestSorter;
    }

    @Nullable
    private static TerminalSortType getConfiguredSortType() {
        SortTypeKey key = SortTypeKey.parse((String)LCConfig.CLIENT.terminalDefaultSorting.get());
        return TraderAPI.getApi().GetSortType(key);
    }

    public NetworkTerminalScreen(TerminalMenu menu, Inventory inventory, Component ignored) {
        super(menu, inventory, (Component)LCText.GUI_NETWORK_TERMINAL_TITLE.get(new Object[0]));
    }

    private ScreenArea calculateSize() {
        if (this.minecraft == null) {
            return this.getArea();
        }
        this.columns = 1;
        int columnLimit = (Integer)LCConfig.CLIENT.terminalColumnLimit.get();
        int availableWidth = this.minecraft.getWindow().getGuiScaledWidth() - 146 - 30;
        while (availableWidth >= 146 && this.columns < columnLimit) {
            availableWidth -= 146;
            ++this.columns;
        }
        int availableHeight = this.minecraft.getWindow().getGuiScaledHeight() - 30 - 45;
        this.rows = 1;
        int rowLimit = (Integer)LCConfig.CLIENT.terminalRowLimit.get();
        while (availableHeight >= 30 && this.rows < rowLimit) {
            availableHeight -= 30;
            ++this.rows;
        }
        this.resize(this.columns * 146 + 30, this.rows * 30 + 45);
        return this.getArea();
    }

    @Override
    protected void initialize(ScreenArea screenArea) {
        screenArea = this.calculateSize();
        this.searchWidth = (this.columns - 1) * 146;
        this.searchField = this.addChild(TextInputUtil.stringBuilder().position(screenArea.pos.offset(28, 10)).size(this.searchWidth - 17, 9).noBorder().maxLength(256).startingValue(lastSearch).textColor(0xFFFFFF).handler(this::onSearchChanged).wrap().build());
        this.sortTypeCache = TraderAPI.getApi().GetAllSortTypes();
        this.addChild(((DropdownWidget.Builder)DropdownWidget.builder().position(screenArea.pos.offset(screenArea.width - 146 + 18, 8))).width(102).options(this.sortTypeCache.stream().map(TerminalSortType::getName).toList()).selected(this.getStartingSortIndex()).selectAction(this::changeSortType).build());
        this.addChild(((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(screenArea.width - 146, 8))).sprite(BUTTON_SAVE).addon(EasyAddonHelper.visibleCheck(this::canSaveSortType))).pressAction(this::saveSortType)).build());
        this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().position(screenArea.pos.offset(screenArea.width - 24, 4))).pressAction(this::OpenAllTraders)).icon(ItemIcon.ofItem(ModBlocks.ITEM_NETWORK_TRADER_4)).addon(EasyAddonHelper.tooltip(LCText.TOOLTIP_NETWORK_TERMINAL_OPEN_ALL))).build());
        this.scrollBar = this.addChild(((ScrollBarWidget.Builder)ScrollBarWidget.builder().position(screenArea.pos.offset(16 + 146 * this.columns, 25))).height(30 * this.rows + 2).scrollable(this).build());
        this.initTraderButtons(screenArea);
        this.updateTraderList();
        this.validateScroll();
    }

    private void initTraderButtons(ScreenArea screenArea) {
        this.traderButtons = new ArrayList<NetworkTraderButton>();
        for (int y = 0; y < this.rows; ++y) {
            for (int x = 0; x < this.columns; ++x) {
                NetworkTraderButton newButton = this.addChild(((NetworkTraderButton.Builder)((NetworkTraderButton.Builder)NetworkTraderButton.builder().position(screenArea.pos.offset(15 + x * 146, 26 + y * 30))).pressAction(this::OpenTrader)).build());
                this.traderButtons.add(newButton);
            }
        }
    }

    @Override
    public void renderBG(EasyGuiGraphics gui) {
        BACKGROUND_SPRITE.render(gui, 0, 0, this.imageWidth, this.imageHeight);
        SpriteUtil.SEARCH_ICON.render(gui, 14, 7);
        SpriteUtil.SEARCH_FIELD.render(gui, 25, 8, this.searchWidth);
        BUTTON_BACKGROUND_SPRITE.render(gui, 14, 25, this.imageWidth - 28, this.imageHeight - 43);
    }

    protected void onSearchChanged(String newSearch) {
        if (newSearch.equals(lastSearch)) {
            return;
        }
        lastSearch = newSearch;
        this.updateTraderList();
    }

    @Override
    public boolean keyPressed(int key, int scanCode, int mods) {
        EditBox b = this.searchField.getWrappedWidget();
        String s = b.getValue();
        if (b.keyPressed(key, scanCode, mods)) {
            if (!Objects.equals(s, b.getValue())) {
                this.updateTraderList();
            }
            return true;
        }
        return b.isFocused() && b.isVisible() && key != 256 || super.keyPressed(key, scanCode, mods);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.handleScrollWheel(deltaY)) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    private void OpenTrader(EasyButton button) {
        int index = this.getTraderIndex(button);
        if (index >= 0 && index < this.filteredTraderList.size()) {
            new CPacketOpenTrades(this.filteredTraderList.get(index).getID()).send();
        }
    }

    private int getTraderIndex(EasyButton button) {
        if (button instanceof NetworkTraderButton && this.traderButtons.contains((Object)button)) {
            return this.traderButtons.indexOf((Object)button) + scroll * this.columns;
        }
        return -1;
    }

    private void updateTraderList() {
        StringBuilder fullSearch = new StringBuilder();
        String extra = (String)LCConfig.CLIENT.terminalBonusFilters.get();
        if (!extra.isBlank()) {
            fullSearch = fullSearch.append(extra);
        }
        if (!this.searchField.getValue().isBlank()) {
            if (!fullSearch.isEmpty()) {
                fullSearch.append(" ");
            }
            fullSearch.append(this.searchField.getValue());
        }
        this.filteredTraderList = TraderAPI.getApi().FilterTraders(this.traderList(), fullSearch.toString());
        this.validateScroll();
        this.updateTraderButtons();
    }

    private void updateTraderButtons() {
        int startIndex = scroll * this.columns;
        for (int i = 0; i < this.traderButtons.size(); ++i) {
            if (startIndex + i < this.filteredTraderList.size()) {
                this.traderButtons.get(i).SetData(this.filteredTraderList.get(startIndex + i));
                continue;
            }
            this.traderButtons.get(i).SetData(null);
        }
    }

    @Override
    public int currentScroll() {
        return scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        scroll = newScroll;
        this.updateTraderButtons();
    }

    @Override
    public int getMaxScroll() {
        return IScrollable.calculateMaxScroll(this.columns * this.rows, this.columns, this.filteredTraderList.size());
    }

    private int getStartingSortIndex() {
        return Math.max(0, this.sortTypeCache.indexOf(NetworkTerminalScreen.getLatestSorter()));
    }

    private boolean canSaveSortType() {
        return NetworkTerminalScreen.getConfiguredSortType() != latestSorter;
    }

    private void changeSortType(int newIndex) {
        if (this.sortTypeCache != null && newIndex >= 0 && newIndex < this.sortTypeCache.size()) {
            latestSorter = this.sortTypeCache.get(newIndex);
            this.updateTraderList();
        }
    }

    private void saveSortType() {
        LCConfig.CLIENT.terminalDefaultSorting.set(NetworkTerminalScreen.getLatestSorter().getKey().toString());
    }

    private void OpenAllTraders(EasyButton button) {
        new CPacketOpenTrades(-1L).send();
    }
}

