/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.salary;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.client.sprites.SpriteUtil;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconUtil;
import io.github.lightman314.lightmanscurrency.api.money.bank.IBankAccount;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.salary.CustomTarget;
import io.github.lightman314.lightmanscurrency.api.money.bank.salary.SalaryData;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ATMScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.salary.SalarySubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.salary.SalaryTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.BankAccountSelectionWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SalaryTargetTab
extends SalarySubTab.EditTab {
    private final Map<String, CustomTarget> extraOptions = new HashMap<String, CustomTarget>();
    private List<BankReference> ignoreList = new ArrayList<BankReference>();
    private List<BankReference> targetCache = new ArrayList<BankReference>();

    public SalaryTargetTab(SalaryTab tab, ATMScreen screen) {
        super(tab, screen);
    }

    @Override
    public IconData getIcon() {
        return IconUtil.ICON_ALEX_HEAD;
    }

    @Override
    @Nullable
    public Component getTooltip() {
        return LCText.TOOLTIP_BANK_SALARY_TARGETS.get(new Object[0]);
    }

    @Override
    protected void initialize(ScreenArea screenArea, boolean firstOpen) {
        IBankAccount account = this.menu.getBankAccount();
        this.extraOptions.clear();
        if (account != null) {
            this.extraOptions.putAll(account.extraSalaryTargets());
        }
        int extraSpace = this.extraOptions.size() * 10;
        if (!this.extraOptions.isEmpty()) {
            extraSpace += 15;
        }
        int yPos = 20;
        for (Map.Entry<String, CustomTarget> entry : this.extraOptions.entrySet()) {
            this.addChild(((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(20, yPos))).sprite(SpriteUtil.createCheckbox(() -> this.isOptionEnabled((String)entry.getKey()))).pressAction(() -> this.toggleExtraOption((String)entry.getKey()))).build());
            yPos += 10;
        }
        int availableSpace = 130 - extraSpace;
        this.addChild(((BankAccountSelectionWidget.Builder)BankAccountSelectionWidget.builder().position(screenArea.pos.offset(20, 10 + extraSpace))).width(screenArea.width - 40).rows(availableSpace / 20).filter(this::accountAllowed).highlight(this::accountSelected).handler(this::toggleTarget).build());
        this.updateTargetCache();
    }

    @Override
    public void renderBG(EasyGuiGraphics gui) {
        if (!this.extraOptions.isEmpty()) {
            gui.drawString((Component)LCText.GUI_BANK_SALARY_TARGETS_CUSTOM.get(new Object[0]), 20, 5, 0x404040);
            int yPos = 21;
            for (CustomTarget option : this.extraOptions.values()) {
                gui.drawString(option.getName(), 32, yPos, 0x404040);
                yPos += 10;
            }
        }
    }

    @Override
    public void tick() {
        this.updateTargetCache();
    }

    private void updateTargetCache() {
        SalaryData salary = this.parent.getSelectedSalary();
        if (salary == null) {
            this.targetCache = new ArrayList<BankReference>();
            this.ignoreList = new ArrayList<BankReference>();
        }
        this.targetCache = salary.getPlayerTargets();
        this.ignoreList = new ArrayList<BankReference>(salary.getCustomTargetAccounts());
        this.ignoreList.add(this.menu.getBankAccountReference());
    }

    private boolean accountAllowed(BankReference reference) {
        return this.ignoreList.stream().noneMatch(br -> br.equals(reference));
    }

    private boolean accountSelected(BankReference reference) {
        return this.targetCache.stream().anyMatch(br -> br.equals(reference));
    }

    private boolean isOptionEnabled(String option) {
        SalaryData salary = this.parent.getSelectedSalary();
        if (salary == null) {
            return false;
        }
        return salary.getCustomTargetSelections().contains(option);
    }

    private void toggleExtraOption(String option) {
        this.SendEditMessage(this.builder().setString("CustomTarget", option).setBoolean("NewState", !this.isOptionEnabled(option)));
    }

    private void toggleTarget(BankReference account) {
        this.SendEditMessage(this.builder().setCompound("DirectTarget", account.save()).setBoolean("NewState", !this.accountSelected(account)));
    }

    @Override
    public boolean blockInventoryClosing() {
        return true;
    }
}

