/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.core;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.icons.IconData;
import io.github.lightman314.lightmanscurrency.api.money.input.MoneyValueWidget;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeDirection;
import io.github.lightman314.lightmanscurrency.client.gui.widget.dropdown.DropdownWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.core.MultiPriceTab;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;

public class MultiPriceClientTab
extends TraderStorageClientTab<MultiPriceTab> {
    DropdownWidget directionInput;
    MoneyValueWidget priceInput;
    private final List<TradeDirection> directionOptions = new ArrayList<TradeDirection>();

    public MultiPriceClientTab(Object screen, MultiPriceTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    public boolean tabVisible() {
        return false;
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconData.Null();
    }

    @Override
    @Nullable
    public Component getTooltip() {
        return EasyText.empty();
    }

    @Override
    protected void initialize(ScreenArea screenArea, boolean firstOpen) {
        int startingIndex = this.setupDirectionOptions();
        if (this.directionOptions.size() > 1) {
            this.directionInput = this.addChild(((DropdownWidget.Builder)DropdownWidget.builder().position(screenArea.pos.offset(screenArea.width - 100, 19))).width(80).options(this.directionOptions.stream().map(d -> d.getName()).toList()).selected(startingIndex).build());
            this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(20, 15))).text(this::getSetDirectionText).width(screenArea.width - 130)).pressAction(this::setTradeDirections)).addon(EasyAddonHelper.activeCheck(this::canSetDirection))).build());
        } else {
            this.directionInput = null;
        }
        this.priceInput = this.addChild(((MoneyValueWidget.Builder)MoneyValueWidget.builder().position(screenArea.centerX() - 88, screenArea.y + 40)).oldIfNotFirst(firstOpen, this.priceInput).startingValue(this.getCommonPrice()).build());
        this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(30, 120))).text(this::getSetPriceText).pressAction(this::setTradePrices)).width(screenArea.width - 60)).addon(EasyAddonHelper.activeCheck(this::canSetPrice))).build());
    }

    private Component getSetPriceText() {
        return LCText.BUTTON_TRADER_SET_ALL_PRICES.get(((MultiPriceTab)this.commonTab).selectedCount());
    }

    private Component getSetDirectionText() {
        return LCText.BUTTON_TRADER_SET_ALL_DIRECTIONS.get(((MultiPriceTab)this.commonTab).selectedCount());
    }

    private boolean hasCommonPrice() {
        TraderData trader = ((ITraderStorageMenu)this.menu).getTrader();
        if (trader != null) {
            List<TradeData> trades = ((MultiPriceTab)this.commonTab).getSelectedTrades();
            if (trades.isEmpty()) {
                return false;
            }
            MoneyValue price = trades.getFirst().getCost();
            if (trades.size() == 1) {
                return true;
            }
            for (int i = 1; i < trades.size(); ++i) {
                if (price.equals(trades.get(i).getCost())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Nonnull
    private MoneyValue getCommonPrice() {
        TraderData trader = ((ITraderStorageMenu)this.menu).getTrader();
        if (trader != null) {
            List<TradeData> trades = ((MultiPriceTab)this.commonTab).getSelectedTrades();
            if (trades.isEmpty()) {
                return MoneyValue.empty();
            }
            MoneyValue price = trades.getFirst().getCost();
            if (trades.size() == 1) {
                return price;
            }
            for (int i = 1; i < trades.size(); ++i) {
                if (price.equals(trades.get(i).getCost())) continue;
                return MoneyValue.empty();
            }
            return price;
        }
        return MoneyValue.empty();
    }

    private int setupDirectionOptions() {
        TraderData trader = ((ITraderStorageMenu)this.menu).getTrader();
        this.directionOptions.clear();
        if (trader != null) {
            this.directionOptions.addAll(trader.validDirectionOptions());
            if (this.directionOptions.size() > 1) {
                List<TradeData> trades = ((MultiPriceTab)this.commonTab).getSelectedTrades();
                if (trades.isEmpty()) {
                    return 0;
                }
                TradeDirection result = trades.getFirst().getTradeDirection();
                if (trades.size() > 1) {
                    for (int i = 1; i < trades.size(); ++i) {
                        if (trades.get(i).getTradeDirection() == result) continue;
                        return 0;
                    }
                }
                return Math.max(0, this.directionOptions.indexOf((Object)result));
            }
        }
        return 0;
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
    }

    private boolean canSetPrice() {
        if (this.priceInput == null) {
            return false;
        }
        MoneyValue price = this.priceInput.getCurrentValue();
        return !this.hasCommonPrice() || !price.equals(this.getCommonPrice());
    }

    private void setTradePrices() {
        ((MultiPriceTab)this.commonTab).setPrices(this.priceInput.getCurrentValue());
    }

    private boolean canSetDirection() {
        if (this.directionOptions.size() <= 1 || this.directionInput == null) {
            return false;
        }
        TradeDirection direction = this.directionOptions.get(this.directionInput.getCurrentlySelected());
        for (TradeData trade : ((MultiPriceTab)this.commonTab).getSelectedTrades()) {
            if (trade.getTradeDirection() == direction) continue;
            return true;
        }
        return false;
    }

    private void setTradeDirections() {
        if (this.directionInput == null) {
            return;
        }
        ((MultiPriceTab)this.commonTab).setTradeDirection(this.directionOptions.get(this.directionInput.getCurrentlySelected()));
    }
}

